/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.codeStyle.arrangement;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.codeStyle.arrangement.ArrangementExtendableSettings;
import com.intellij.psi.codeStyle.arrangement.ArrangementSettings;
import com.intellij.psi.codeStyle.arrangement.ArrangementSettingsSerializer;
import com.intellij.psi.codeStyle.arrangement.group.ArrangementGroupingRule;
import com.intellij.psi.codeStyle.arrangement.match.ArrangementMatchRule;
import com.intellij.psi.codeStyle.arrangement.match.ArrangementSectionRule;
import com.intellij.psi.codeStyle.arrangement.match.DefaultArrangementEntryMatcherSerializer;
import com.intellij.psi.codeStyle.arrangement.match.StdArrangementEntryMatcher;
import com.intellij.psi.codeStyle.arrangement.match.StdArrangementMatchRule;
import com.intellij.psi.codeStyle.arrangement.std.ArrangementSettingsToken;
import com.intellij.psi.codeStyle.arrangement.std.StdArrangementExtendableSettings;
import com.intellij.psi.codeStyle.arrangement.std.StdArrangementRuleAliasToken;
import com.intellij.psi.codeStyle.arrangement.std.StdArrangementSettings;
import com.intellij.psi.codeStyle.arrangement.std.StdArrangementTokens;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.jdom.Attribute;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DefaultArrangementSettingsSerializer
implements ArrangementSettingsSerializer {
    private static final Logger LOG = Logger.getInstance((String)("#" + DefaultArrangementSettingsSerializer.class.getName()));
    @NotNull
    @NonNls
    private static final String GROUPS_ELEMENT_NAME = "groups";
    @NotNull
    @NonNls
    private static final String GROUP_ELEMENT_NAME = "group";
    @NotNull
    @NonNls
    private static final String RULES_ELEMENT_NAME = "rules";
    @NotNull
    @NonNls
    private static final String TOKENS_ELEMENT_NAME = "tokens";
    @NotNull
    @NonNls
    private static final String TOKEN_ELEMENT_NAME = "token";
    @NotNull
    @NonNls
    private static final String TOKEN_ID = "id";
    @NotNull
    @NonNls
    private static final String TOKEN_NAME = "name";
    @NotNull
    @NonNls
    private static final String SECTION_ELEMENT_NAME = "section";
    @NotNull
    @NonNls
    private static final String SECTION_START_ATTRIBUTE = "start_comment";
    @NotNull
    @NonNls
    private static final String SECTION_END_ATTRIBUTE = "end_comment";
    @NotNull
    @NonNls
    private static final String RULE_ELEMENT_NAME = "rule";
    @NotNull
    @NonNls
    private static final String TYPE_ELEMENT_NAME = "type";
    @NotNull
    @NonNls
    private static final String MATCHER_ELEMENT_NAME = "match";
    @NotNull
    @NonNls
    private static final String ORDER_TYPE_ELEMENT_NAME = "order";
    @NotNull
    private final DefaultArrangementEntryMatcherSerializer myMatcherSerializer;
    @NotNull
    private final Mixin myMixin;
    @NotNull
    private final ArrangementSettings myDefaultSettings;

    public DefaultArrangementSettingsSerializer(@NotNull StdArrangementSettings defaultSettings) {
        if (defaultSettings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "defaultSettings", "com/intellij/psi/codeStyle/arrangement/DefaultArrangementSettingsSerializer", "<init>"));
        }
        this(Mixin.NULL, defaultSettings);
    }

    public DefaultArrangementSettingsSerializer(@NotNull Mixin mixin, @NotNull StdArrangementSettings defaultSettings) {
        if (mixin == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mixin", "com/intellij/psi/codeStyle/arrangement/DefaultArrangementSettingsSerializer", "<init>"));
        }
        if (defaultSettings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "defaultSettings", "com/intellij/psi/codeStyle/arrangement/DefaultArrangementSettingsSerializer", "<init>"));
        }
        this.myMixin = new MutableMixin(mixin);
        this.myMatcherSerializer = new DefaultArrangementEntryMatcherSerializer(this.myMixin);
        this.myDefaultSettings = defaultSettings;
    }

    @Override
    public void serialize(@NotNull ArrangementSettings s, @NotNull Element holder) {
        List<ArrangementSectionRule> sections;
        boolean isDefaultRules;
        List<ArrangementGroupingRule> groupings;
        boolean isDefaultGroupings;
        Set<StdArrangementRuleAliasToken> tokensDefinition;
        boolean isDefault;
        if (s == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "s", "com/intellij/psi/codeStyle/arrangement/DefaultArrangementSettingsSerializer", "serialize"));
        }
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/psi/codeStyle/arrangement/DefaultArrangementSettingsSerializer", "serialize"));
        }
        if (!(s instanceof StdArrangementSettings)) {
            return;
        }
        StdArrangementSettings settings = (StdArrangementSettings)s;
        if (settings instanceof ArrangementExtendableSettings && this.myDefaultSettings instanceof ArrangementExtendableSettings && !(isDefault = (tokensDefinition = ((ArrangementExtendableSettings)((Object)settings)).getRuleAliases()).equals(((ArrangementExtendableSettings)this.myDefaultSettings).getRuleAliases()))) {
            Element tokensElement = new Element(TOKENS_ELEMENT_NAME);
            for (StdArrangementRuleAliasToken definition : tokensDefinition) {
                Element tokenElement = new Element(TOKEN_ELEMENT_NAME);
                tokenElement.setAttribute(TOKEN_ID, definition.getId());
                tokenElement.setAttribute(TOKEN_NAME, definition.getName());
                Element rulesElement = new Element(RULES_ELEMENT_NAME);
                for (StdArrangementMatchRule rule : definition.getDefinitionRules()) {
                    rulesElement.addContent(this.serialize(rule));
                }
                tokenElement.addContent(rulesElement);
                tokensElement.addContent(tokenElement);
            }
            holder.addContent(tokensElement);
        }
        if (!(isDefaultGroupings = (groupings = settings.getGroupings()).equals(this.myDefaultSettings.getGroupings()))) {
            Element groupingsElement = new Element(GROUPS_ELEMENT_NAME);
            holder.addContent(groupingsElement);
            for (ArrangementGroupingRule group : groupings) {
                Element groupElement = new Element(GROUP_ELEMENT_NAME);
                groupingsElement.addContent(groupElement);
                groupElement.addContent(new Element(TYPE_ELEMENT_NAME).setText(group.getGroupingType().getId()));
                groupElement.addContent(new Element(ORDER_TYPE_ELEMENT_NAME).setText(group.getOrderType().getId()));
            }
        }
        if (!(isDefaultRules = (sections = settings.getSections()).equals(this.myDefaultSettings.getSections()))) {
            Element rulesElement = new Element(RULES_ELEMENT_NAME);
            holder.addContent(rulesElement);
            for (ArrangementSectionRule section : sections) {
                rulesElement.addContent(this.serialize(section));
            }
        }
    }

    @Override
    @Nullable
    public ArrangementSettings deserialize(@NotNull Element element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/codeStyle/arrangement/DefaultArrangementSettingsSerializer", "deserialize"));
        }
        Set<StdArrangementRuleAliasToken> tokensDefinition = this.deserializeTokensDefinition(element, this.myDefaultSettings);
        List<ArrangementGroupingRule> groupingRules = this.deserializeGropings(element, this.myDefaultSettings);
        Element rulesElement = element.getChild(RULES_ELEMENT_NAME);
        ArrayList sectionRules = ContainerUtil.newArrayList();
        if (rulesElement == null) {
            sectionRules.addAll(this.myDefaultSettings.getSections());
        } else {
            sectionRules.addAll(this.deserializeSectionRules(rulesElement, tokensDefinition));
            if (sectionRules.isEmpty()) {
                List<StdArrangementMatchRule> rules = this.deserializeRules(rulesElement, tokensDefinition);
                return StdArrangementSettings.createByMatchRules(groupingRules, rules);
            }
        }
        if (tokensDefinition == null) {
            return new StdArrangementSettings(groupingRules, sectionRules);
        }
        return new StdArrangementExtendableSettings(groupingRules, sectionRules, tokensDefinition);
    }

    @Nullable
    private Set<StdArrangementRuleAliasToken> deserializeTokensDefinition(@NotNull Element element, @NotNull ArrangementSettings defaultSettings) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/codeStyle/arrangement/DefaultArrangementSettingsSerializer", "deserializeTokensDefinition"));
        }
        if (defaultSettings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "defaultSettings", "com/intellij/psi/codeStyle/arrangement/DefaultArrangementSettingsSerializer", "deserializeTokensDefinition"));
        }
        if (!(defaultSettings instanceof ArrangementExtendableSettings)) {
            return null;
        }
        Element tokensRoot = element.getChild(TOKENS_ELEMENT_NAME);
        if (tokensRoot == null) {
            return ((ArrangementExtendableSettings)this.myDefaultSettings).getRuleAliases();
        }
        THashSet tokenDefinitions = new THashSet();
        List tokens = tokensRoot.getChildren(TOKEN_ELEMENT_NAME);
        for (Element token : tokens) {
            Attribute id = token.getAttribute(TOKEN_ID);
            Attribute name = token.getAttribute(TOKEN_NAME);
            assert (id != null && name != null) : "Can not find id for token: " + token;
            Element rules = token.getChild(RULES_ELEMENT_NAME);
            List<StdArrangementMatchRule> tokenRules = rules == null ? ContainerUtil.emptyList() : this.deserializeRules(rules, null);
            tokenDefinitions.add(new StdArrangementRuleAliasToken(id.getValue(), name.getValue(), tokenRules));
        }
        return tokenDefinitions;
    }

    @NotNull
    private List<ArrangementGroupingRule> deserializeGropings(@NotNull Element element, @Nullable ArrangementSettings defaultSettings) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/codeStyle/arrangement/DefaultArrangementSettingsSerializer", "deserializeGropings"));
        }
        Element groups = element.getChild(GROUPS_ELEMENT_NAME);
        if (groups == null) {
            List<ArrangementGroupingRule> list = defaultSettings == null ? ContainerUtil.newSmartList() : defaultSettings.getGroupings();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/codeStyle/arrangement/DefaultArrangementSettingsSerializer", "deserializeGropings"));
            }
            return list;
        }
        ArrayList<ArrangementGroupingRule> groupings = new ArrayList<ArrangementGroupingRule>();
        for (Object group : groups.getChildren(GROUP_ELEMENT_NAME)) {
            Element groupElement = (Element)group;
            String groupingTypeId = groupElement.getChildText(TYPE_ELEMENT_NAME);
            ArrangementSettingsToken groupingType = StdArrangementTokens.byId(groupingTypeId);
            if (groupingType == null) {
                groupingType = this.myMixin.deserializeToken(groupingTypeId);
            }
            if (groupingType == null) {
                LOG.warn(String.format("Can't deserialize grouping type token by id '%s'", groupingTypeId));
                continue;
            }
            String orderTypeId = groupElement.getChildText(ORDER_TYPE_ELEMENT_NAME);
            ArrangementSettingsToken orderType = StdArrangementTokens.byId(orderTypeId);
            if (orderType == null) {
                orderType = this.myMixin.deserializeToken(orderTypeId);
            }
            if (orderType == null) {
                LOG.warn(String.format("Can't deserialize grouping order type token by id '%s'", orderTypeId));
                continue;
            }
            groupings.add(new ArrangementGroupingRule(groupingType, orderType));
        }
        ArrayList<ArrangementGroupingRule> arrayList = groupings;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/codeStyle/arrangement/DefaultArrangementSettingsSerializer", "deserializeGropings"));
        }
        return arrayList;
    }

    @NotNull
    private List<ArrangementSectionRule> deserializeSectionRules(@NotNull Element rulesElement, @Nullable Set<StdArrangementRuleAliasToken> tokens) {
        if (rulesElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rulesElement", "com/intellij/psi/codeStyle/arrangement/DefaultArrangementSettingsSerializer", "deserializeSectionRules"));
        }
        ArrayList<ArrangementSectionRule> sectionRules = new ArrayList<ArrangementSectionRule>();
        for (Object o : rulesElement.getChildren(SECTION_ELEMENT_NAME)) {
            Element sectionElement = (Element)o;
            List<StdArrangementMatchRule> rules = this.deserializeRules(sectionElement, tokens);
            Attribute start = sectionElement.getAttribute(SECTION_START_ATTRIBUTE);
            String startComment = start != null ? start.getValue().trim() : null;
            Attribute end = sectionElement.getAttribute(SECTION_END_ATTRIBUTE);
            String endComment = end != null ? end.getValue().trim() : null;
            sectionRules.add(ArrangementSectionRule.create(startComment, endComment, rules));
        }
        ArrayList<ArrangementSectionRule> arrayList = sectionRules;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/codeStyle/arrangement/DefaultArrangementSettingsSerializer", "deserializeSectionRules"));
        }
        return arrayList;
    }

    @NotNull
    private List<StdArrangementMatchRule> deserializeRules(@NotNull Element element, @Nullable Set<StdArrangementRuleAliasToken> aliases) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/codeStyle/arrangement/DefaultArrangementSettingsSerializer", "deserializeRules"));
        }
        if (aliases != null && this.myMixin instanceof MutableMixin) {
            ((MutableMixin)this.myMixin).setMyRuleAliases(aliases);
        }
        ArrayList<StdArrangementMatchRule> rules = new ArrayList<StdArrangementMatchRule>();
        for (Object o : element.getChildren(RULE_ELEMENT_NAME)) {
            Object c;
            Element ruleElement = (Element)o;
            Element matcherElement = ruleElement.getChild(MATCHER_ELEMENT_NAME);
            if (matcherElement == null) continue;
            StdArrangementEntryMatcher matcher = null;
            Iterator iterator = matcherElement.getChildren().iterator();
            while (iterator.hasNext() && (matcher = this.myMatcherSerializer.deserialize((Element)(c = iterator.next()))) == null) {
            }
            if (matcher == null) {
                List list = ContainerUtil.newSmartList();
                if (list == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/codeStyle/arrangement/DefaultArrangementSettingsSerializer", "deserializeRules"));
                }
                return list;
            }
            Element orderTypeElement = ruleElement.getChild(ORDER_TYPE_ELEMENT_NAME);
            ArrangementSettingsToken orderType = null;
            if (orderTypeElement != null) {
                String orderTypeId = orderTypeElement.getText();
                orderType = StdArrangementTokens.byId(orderTypeId);
                if (orderType == null) {
                    orderType = this.myMixin.deserializeToken(orderTypeId);
                }
                if (orderType == null) {
                    LOG.warn(String.format("Can't deserialize matching rule order type for id '%s'. Falling back to default (%s)", orderTypeId, ArrangementMatchRule.DEFAULT_ORDER_TYPE.getId()));
                }
            }
            if (orderType == null) {
                orderType = ArrangementMatchRule.DEFAULT_ORDER_TYPE;
            }
            rules.add(new StdArrangementMatchRule(matcher, orderType));
        }
        ArrayList<StdArrangementMatchRule> arrayList = rules;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/codeStyle/arrangement/DefaultArrangementSettingsSerializer", "deserializeRules"));
        }
        return arrayList;
    }

    @Nullable
    public Element serialize(@NotNull ArrangementMatchRule rule) {
        if (rule == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", RULE_ELEMENT_NAME, "com/intellij/psi/codeStyle/arrangement/DefaultArrangementSettingsSerializer", "serialize"));
        }
        Element matcherElement = this.myMatcherSerializer.serialize(rule.getMatcher());
        if (matcherElement == null) {
            return null;
        }
        Element result = new Element(RULE_ELEMENT_NAME);
        result.addContent(new Element(MATCHER_ELEMENT_NAME).addContent(matcherElement));
        if (rule.getOrderType() != ArrangementMatchRule.DEFAULT_ORDER_TYPE) {
            result.addContent(new Element(ORDER_TYPE_ELEMENT_NAME).setText(rule.getOrderType().getId()));
        }
        return result;
    }

    @Nullable
    public Element serialize(@NotNull ArrangementSectionRule section) {
        if (section == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", SECTION_ELEMENT_NAME, "com/intellij/psi/codeStyle/arrangement/DefaultArrangementSettingsSerializer", "serialize"));
        }
        Element sectionElement = new Element(SECTION_ELEMENT_NAME);
        if (StringUtil.isNotEmpty((String)section.getStartComment())) {
            sectionElement.setAttribute(SECTION_START_ATTRIBUTE, section.getStartComment());
        }
        if (StringUtil.isNotEmpty((String)section.getEndComment())) {
            sectionElement.setAttribute(SECTION_END_ATTRIBUTE, section.getEndComment());
        }
        List<StdArrangementMatchRule> rules = section.getMatchRules();
        for (int i2 = 0; i2 < rules.size(); ++i2) {
            StdArrangementMatchRule rule = rules.get(i2);
            if (i2 == 0 && !StringUtil.isEmpty((String)section.getStartComment()) || i2 == rules.size() - 1 && !StringUtil.isEmpty((String)section.getEndComment())) continue;
            sectionElement.addContent(this.serialize(rule));
        }
        return sectionElement;
    }

    public static interface Mixin {
        public static final Mixin NULL = new Mixin(){

            @Override
            @Nullable
            public ArrangementSettingsToken deserializeToken(@NotNull String id) {
                if (id == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", DefaultArrangementSettingsSerializer.TOKEN_ID, "com/intellij/psi/codeStyle/arrangement/DefaultArrangementSettingsSerializer$Mixin$1", "deserializeToken"));
                }
                return null;
            }
        };

        @Nullable
        public ArrangementSettingsToken deserializeToken(@NotNull String var1);
    }

    public static class MutableMixin
    implements Mixin {
        private final Mixin myDelegate;
        private Set<StdArrangementRuleAliasToken> myRuleAliases;

        public MutableMixin(Mixin delegate) {
            this.myDelegate = delegate;
        }

        public void setMyRuleAliases(Set<StdArrangementRuleAliasToken> aliases) {
            this.myRuleAliases = aliases;
        }

        @Override
        @Nullable
        public ArrangementSettingsToken deserializeToken(@NotNull String id) {
            if (id == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", DefaultArrangementSettingsSerializer.TOKEN_ID, "com/intellij/psi/codeStyle/arrangement/DefaultArrangementSettingsSerializer$MutableMixin", "deserializeToken"));
            }
            ArrangementSettingsToken token = this.myDelegate.deserializeToken(id);
            if (token != null || this.myRuleAliases == null) {
                return token;
            }
            for (StdArrangementRuleAliasToken alias : this.myRuleAliases) {
                if (!StringUtil.equals((CharSequence)alias.getId(), (CharSequence)id)) continue;
                return alias;
            }
            return null;
        }
    }
}

