/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.usages.actions;

import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.usages.Usage;
import com.intellij.usages.UsageView;
import com.intellij.usages.impl.UsageViewImpl;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;

public class RemoveUsageAction
extends AnAction {
    @Override
    public void update(AnActionEvent e) {
        e.getPresentation().setEnabled(RemoveUsageAction.getUsages(e).length > 0);
    }

    @Override
    public void actionPerformed(AnActionEvent e) {
        RemoveUsageAction.process(RemoveUsageAction.getUsages(e), e.getData(UsageView.USAGE_VIEW_KEY));
    }

    private static void process(@NotNull Usage[] usages, @NotNull UsageView usageView) {
        if (usages == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "usages", "com/intellij/usages/actions/RemoveUsageAction", "process"));
        }
        if (usageView == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "usageView", "com/intellij/usages/actions/RemoveUsageAction", "process"));
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        if (usages.length == 0) {
            return;
        }
        Arrays.sort(usages, UsageViewImpl.USAGE_COMPARATOR);
        Usage nextToSelect = RemoveUsageAction.getNextToSelect(usageView, usages[usages.length - 1]);
        for (Usage usage : usages) {
            usageView.removeUsage(usage);
        }
        if (nextToSelect != null) {
            usageView.selectUsages(new Usage[]{nextToSelect});
        }
    }

    @NotNull
    private static Usage[] getUsages(AnActionEvent context) {
        ApplicationManager.getApplication().assertIsDispatchThread();
        UsageView usageView = context.getData(UsageView.USAGE_VIEW_KEY);
        if (usageView == null) {
            if (Usage.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/usages/actions/RemoveUsageAction", "getUsages"));
            }
            return Usage.EMPTY_ARRAY;
        }
        Usage[] usages = context.getData(UsageView.USAGES_KEY);
        Usage[] usageArray = usages == null ? Usage.EMPTY_ARRAY : usages;
        if (usageArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/usages/actions/RemoveUsageAction", "getUsages"));
        }
        return usageArray;
    }

    private static Usage getNextToSelect(@NotNull UsageView usageView, @NotNull Usage toDelete) {
        if (usageView == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "usageView", "com/intellij/usages/actions/RemoveUsageAction", "getNextToSelect"));
        }
        if (toDelete == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toDelete", "com/intellij/usages/actions/RemoveUsageAction", "getNextToSelect"));
        }
        return ((UsageViewImpl)usageView).getNextToSelect(toDelete);
    }
}

