/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.net;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.components.ApplicationComponentAdapter;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.popup.util.PopupUtil;
import com.intellij.openapi.util.Getter;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.KeyValue;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.StaticGetter;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.openapi.wm.IdeFrame;
import com.intellij.util.SystemProperties;
import com.intellij.util.WaitForProgressToShow;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.net.AuthenticationDialog;
import com.intellij.util.net.AuthenticationPanel;
import com.intellij.util.net.HttpProxyConfigurable;
import com.intellij.util.net.IdeaWideAuthenticator;
import com.intellij.util.net.IdeaWideProxySelector;
import com.intellij.util.proxy.CommonProxy;
import com.intellij.util.proxy.PropertiesEncryptionSupport;
import com.intellij.util.proxy.SharedProxyConfig;
import com.intellij.util.xmlb.SerializationFilter;
import com.intellij.util.xmlb.SkipDefaultsSerializationFilter;
import com.intellij.util.xmlb.XmlSerializer;
import com.intellij.util.xmlb.XmlSerializerUtil;
import com.intellij.util.xmlb.annotations.Transient;
import gnu.trove.THashMap;
import gnu.trove.THashSet;
import gnu.trove.TObjectObjectProcedure;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.InetSocketAddress;
import java.net.PasswordAuthentication;
import java.net.Proxy;
import java.net.ProxySelector;
import java.net.SocketAddress;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.stream.Collectors;
import javax.crypto.spec.SecretKeySpec;
import javax.swing.JComponent;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@State(name="HttpConfigurable", storages={@Storage(value="proxy.settings.xml"), @Storage(value="other.xml", deprecated=true)})
public class HttpConfigurable
implements PersistentStateComponent<HttpConfigurable>,
ApplicationComponentAdapter,
Disposable {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.util.net.HttpConfigurable");
    private static final File PROXY_CREDENTIALS_FILE = new File(PathManager.getOptionsPath(), "proxy.settings.pwd");
    public static final int CONNECTION_TIMEOUT = SystemProperties.getIntProperty((String)"idea.connection.timeout", (int)10000);
    public static final int READ_TIMEOUT = SystemProperties.getIntProperty((String)"idea.read.timeout", (int)60000);
    public static final int REDIRECT_LIMIT = SystemProperties.getIntProperty((String)"idea.redirect.limit", (int)10);
    public boolean PROXY_TYPE_IS_SOCKS;
    public boolean USE_HTTP_PROXY;
    public boolean USE_PROXY_PAC;
    public volatile transient boolean AUTHENTICATION_CANCELLED;
    public String PROXY_HOST;
    public int PROXY_PORT = 80;
    public volatile boolean PROXY_AUTHENTICATION;
    public boolean KEEP_PROXY_PASSWORD;
    public transient String LAST_ERROR;
    private final THashMap<CommonProxy.HostInfo, ProxyInfo> myGenericPasswords = new THashMap();
    private final Set<CommonProxy.HostInfo> myGenericCancelled = new THashSet();
    public String PROXY_EXCEPTIONS;
    public boolean USE_PAC_URL;
    public String PAC_URL;
    private transient IdeaWideProxySelector mySelector;
    private final transient Object myLock = new Object();
    private final transient PropertiesEncryptionSupport myEncryptionSupport = new PropertiesEncryptionSupport(new SecretKeySpec(new byte[]{80, 114, 111, 120, 121, 32, 67, 111, 110, 102, 105, 103, 32, 83, 101, 99}, "AES"));
    private final transient NotNullLazyValue<Properties> myProxyCredentials = NotNullLazyValue.createValue(() -> {
        try {
            return this.myEncryptionSupport.load(PROXY_CREDENTIALS_FILE);
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (Throwable th) {
            LOG.info(th);
        }
        return new Properties();
    });
    public transient Getter<PasswordAuthentication> myTestAuthRunnable = new StaticGetter(null);
    public transient Getter<PasswordAuthentication> myTestGenericAuthRunnable = new StaticGetter(null);

    public static HttpConfigurable getInstance() {
        return ApplicationManager.getApplication().getComponent(HttpConfigurable.class);
    }

    public static boolean editConfigurable(@Nullable JComponent parent) {
        return ShowSettingsUtil.getInstance().editConfigurable(parent, (Configurable)new HttpProxyConfigurable());
    }

    @Override
    public HttpConfigurable getState() {
        CommonProxy.isInstalledAssertion();
        HttpConfigurable state = new HttpConfigurable();
        XmlSerializerUtil.copyBean((Object)this, (Object)state);
        if (!this.KEEP_PROXY_PASSWORD) {
            this.removeSecure("proxy.password");
        }
        this.correctPasswords(state);
        return state;
    }

    @Override
    public void initComponent() {
        SharedProxyConfig.ProxyParameters cfg;
        Element serialized;
        HttpConfigurable currentState = this.getState();
        if (currentState != null && (serialized = XmlSerializer.serializeIfNotDefault((Object)currentState, (SerializationFilter)new SkipDefaultsSerializationFilter())) == null && (cfg = SharedProxyConfig.load()) != null) {
            SharedProxyConfig.clear();
            if (cfg.host != null) {
                this.USE_HTTP_PROXY = true;
                this.PROXY_HOST = cfg.host;
                this.PROXY_PORT = cfg.port;
                if (cfg.login != null) {
                    this.setPlainProxyPassword(new String(cfg.password));
                    this.storeSecure("proxy.login", cfg.login);
                    this.PROXY_AUTHENTICATION = true;
                    this.KEEP_PROXY_PASSWORD = true;
                }
            }
        }
        this.mySelector = new IdeaWideProxySelector(this);
        String name = this.getClass().getName();
        CommonProxy.getInstance().setCustom(name, this.mySelector);
        CommonProxy.getInstance().setCustomAuth(name, new IdeaWideAuthenticator(this));
    }

    @NotNull
    public ProxySelector getOnlyBySettingsSelector() {
        IdeaWideProxySelector ideaWideProxySelector = this.mySelector;
        if (ideaWideProxySelector == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/net/HttpConfigurable", "getOnlyBySettingsSelector"));
        }
        return ideaWideProxySelector;
    }

    public void dispose() {
        String name = this.getClass().getName();
        CommonProxy.getInstance().removeCustom(name);
        CommonProxy.getInstance().removeCustomAuth(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void correctPasswords(@NotNull HttpConfigurable to) {
        if (to == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "to", "com/intellij/util/net/HttpConfigurable", "correctPasswords"));
        }
        Object object = this.myLock;
        synchronized (object) {
            to.myGenericPasswords.retainEntries((TObjectObjectProcedure)new TObjectObjectProcedure<CommonProxy.HostInfo, ProxyInfo>(){

                public boolean execute(CommonProxy.HostInfo hostInfo, ProxyInfo proxyInfo) {
                    return proxyInfo.isStore();
                }
            });
        }
    }

    @Override
    public void loadState(@NotNull HttpConfigurable state) {
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/util/net/HttpConfigurable", "loadState"));
        }
        XmlSerializerUtil.copyBean((Object)state, (Object)this);
        if (!this.KEEP_PROXY_PASSWORD) {
            this.removeSecure("proxy.password");
        }
        this.correctPasswords(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isGenericPasswordCanceled(@NotNull String host, int port) {
        if (host == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "host", "com/intellij/util/net/HttpConfigurable", "isGenericPasswordCanceled"));
        }
        Object object = this.myLock;
        synchronized (object) {
            return this.myGenericCancelled.contains(new CommonProxy.HostInfo(null, host, port));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setGenericPasswordCanceled(String host, int port) {
        Object object = this.myLock;
        synchronized (object) {
            this.myGenericCancelled.add(new CommonProxy.HostInfo(null, host, port));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PasswordAuthentication getGenericPassword(@NotNull String host, int port) {
        ProxyInfo proxyInfo;
        if (host == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "host", "com/intellij/util/net/HttpConfigurable", "getGenericPassword"));
        }
        Object object = this.myLock;
        synchronized (object) {
            proxyInfo = (ProxyInfo)this.myGenericPasswords.get((Object)new CommonProxy.HostInfo(null, host, port));
        }
        if (proxyInfo == null) {
            return null;
        }
        return new PasswordAuthentication(proxyInfo.getUsername(), HttpConfigurable.decode(String.valueOf(proxyInfo.getPasswordCrypt())).toCharArray());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putGenericPassword(String host, int port, @NotNull PasswordAuthentication authentication, boolean remember) {
        if (authentication == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "authentication", "com/intellij/util/net/HttpConfigurable", "putGenericPassword"));
        }
        PasswordAuthentication coded = new PasswordAuthentication(authentication.getUserName(), HttpConfigurable.encode(String.valueOf(authentication.getPassword())).toCharArray());
        Object object = this.myLock;
        synchronized (object) {
            this.myGenericPasswords.put((Object)new CommonProxy.HostInfo(null, host, port), (Object)new ProxyInfo(remember, coded.getUserName(), String.valueOf(coded.getPassword())));
        }
    }

    @Transient
    @Nullable
    public String getProxyLogin() {
        return this.getSecure("proxy.login");
    }

    @Transient
    public void setProxyLogin(String login) {
        this.storeSecure("proxy.login", login);
    }

    @Transient
    @Nullable
    public String getPlainProxyPassword() {
        return this.getSecure("proxy.password");
    }

    @Transient
    public void setPlainProxyPassword(String password) {
        this.storeSecure("proxy.password", password);
    }

    private static String decode(String value) {
        return new String(Base64.getDecoder().decode(value), StandardCharsets.UTF_8);
    }

    private static String encode(String password) {
        return Base64.getEncoder().encodeToString(password.getBytes(StandardCharsets.UTF_8));
    }

    public PasswordAuthentication getGenericPromptedAuthentication(String prefix, String host, String prompt, int port, boolean remember) {
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return (PasswordAuthentication)this.myTestGenericAuthRunnable.get();
        }
        Ref value = Ref.create();
        HttpConfigurable.runAboveAll(() -> {
            if (this.isGenericPasswordCanceled(host, port)) {
                return;
            }
            PasswordAuthentication password = this.getGenericPassword(host, port);
            if (password != null) {
                value.set((Object)password);
                return;
            }
            AuthenticationDialog dialog = new AuthenticationDialog(PopupUtil.getActiveComponent(), prefix + host, "Please enter credentials for: " + prompt, "", "", remember);
            dialog.show();
            if (dialog.getExitCode() == 0) {
                AuthenticationPanel panel = dialog.getPanel();
                PasswordAuthentication passwordAuthentication = new PasswordAuthentication(panel.getLogin(), panel.getPassword());
                this.putGenericPassword(host, port, passwordAuthentication, remember && panel.isRememberPassword());
                value.set((Object)passwordAuthentication);
            } else {
                this.setGenericPasswordCanceled(host, port);
            }
        });
        return (PasswordAuthentication)value.get();
    }

    public PasswordAuthentication getPromptedAuthentication(String host, String prompt) {
        String login;
        if (this.AUTHENTICATION_CANCELLED) {
            return null;
        }
        String password = this.getPlainProxyPassword();
        if (this.PROXY_AUTHENTICATION && !StringUtil.isEmptyOrSpaces((String)(login = this.getSecure("proxy.login"))) && !StringUtil.isEmptyOrSpaces((String)password)) {
            return new PasswordAuthentication(login, password.toCharArray());
        }
        if (ApplicationManager.getApplication() == null || ApplicationManager.getApplication().isDisposeInProgress() || ApplicationManager.getApplication().isDisposed()) {
            return null;
        }
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return (PasswordAuthentication)this.myTestGenericAuthRunnable.get();
        }
        PasswordAuthentication[] value = new PasswordAuthentication[1];
        HttpConfigurable.runAboveAll(() -> {
            String login;
            if (this.AUTHENTICATION_CANCELLED) {
                return;
            }
            String password1 = this.getPlainProxyPassword();
            if (this.PROXY_AUTHENTICATION && !StringUtil.isEmptyOrSpaces((String)(login = this.getSecure("proxy.login"))) && !StringUtil.isEmptyOrSpaces((String)password1)) {
                value[0] = new PasswordAuthentication(login, password1.toCharArray());
                return;
            }
            AuthenticationDialog dialog = new AuthenticationDialog(PopupUtil.getActiveComponent(), "Proxy authentication: " + host, "Please enter credentials for: " + prompt, this.getSecure("proxy.login"), "", this.KEEP_PROXY_PASSWORD);
            dialog.show();
            if (dialog.getExitCode() == 0) {
                boolean keepPass;
                this.PROXY_AUTHENTICATION = true;
                AuthenticationPanel panel = dialog.getPanel();
                this.KEEP_PROXY_PASSWORD = keepPass = panel.isRememberPassword();
                this.storeSecure("proxy.login", StringUtil.nullize((String)panel.getLogin()));
                if (keepPass) {
                    this.setPlainProxyPassword(String.valueOf(panel.getPassword()));
                } else {
                    this.removeSecure("proxy.password");
                }
                value[0] = new PasswordAuthentication(panel.getLogin(), panel.getPassword());
            } else {
                this.AUTHENTICATION_CANCELLED = true;
            }
        });
        return value[0];
    }

    private static void runAboveAll(@NotNull Runnable runnable) {
        if (runnable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runnable", "com/intellij/util/net/HttpConfigurable", "runAboveAll"));
        }
        ProgressIndicator progressIndicator = ProgressManager.getInstance().getProgressIndicator();
        if (progressIndicator != null && progressIndicator.isModal()) {
            WaitForProgressToShow.runOrInvokeAndWaitAboveProgress(runnable);
        } else {
            Application app = ApplicationManager.getApplication();
            app.invokeAndWait(runnable, ModalityState.any());
        }
    }

    @Deprecated
    public void readExternal(Element element) throws InvalidDataException {
        this.loadState((HttpConfigurable)XmlSerializer.deserialize((Element)element, HttpConfigurable.class));
    }

    @Deprecated
    public void writeExternal(Element element) throws WriteExternalException {
        XmlSerializer.serializeInto((Object)this.getState(), (Element)element);
        if (this.USE_PROXY_PAC && this.USE_HTTP_PROXY && !ApplicationManager.getApplication().isDisposed()) {
            ApplicationManager.getApplication().invokeLater(() -> {
                IdeFrame frame = IdeFocusManager.findInstance().getLastFocusedFrame();
                if (frame != null) {
                    this.USE_PROXY_PAC = false;
                    Messages.showMessageDialog(frame.getComponent(), "Proxy: both 'use proxy' and 'autodetect proxy' settings were set.\nOnly one of these options should be selected.\nPlease re-configure.", "Proxy Setup", Messages.getWarningIcon());
                    HttpConfigurable.editConfigurable(frame.getComponent());
                }
            }, ModalityState.NON_MODAL);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void prepareURL(@NotNull String url) throws IOException {
        if (url == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "url", "com/intellij/util/net/HttpConfigurable", "prepareURL"));
        }
        URLConnection connection = this.openConnection(url);
        try {
            connection.connect();
            connection.getInputStream();
        }
        catch (IOException e) {
            throw e;
        }
        catch (Throwable throwable) {
        }
        finally {
            if (connection instanceof HttpURLConnection) {
                ((HttpURLConnection)connection).disconnect();
            }
        }
    }

    @NotNull
    public URLConnection openConnection(@NotNull String location) throws IOException {
        if (location == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "location", "com/intellij/util/net/HttpConfigurable", "openConnection"));
        }
        URL url = new URL(location);
        URLConnection urlConnection = null;
        List<Proxy> proxies = CommonProxy.getInstance().select(url);
        if (ContainerUtil.isEmpty(proxies)) {
            urlConnection = url.openConnection();
        } else {
            IOException exception = null;
            for (Proxy proxy : proxies) {
                try {
                    urlConnection = url.openConnection(proxy);
                }
                catch (IOException e) {
                    exception = e;
                }
            }
            if (urlConnection == null && exception != null) {
                throw exception;
            }
        }
        assert (urlConnection != null);
        urlConnection.setReadTimeout(READ_TIMEOUT);
        urlConnection.setConnectTimeout(CONNECTION_TIMEOUT);
        URLConnection uRLConnection = urlConnection;
        if (uRLConnection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/net/HttpConfigurable", "openConnection"));
        }
        return uRLConnection;
    }

    @NotNull
    public HttpURLConnection openHttpConnection(@NotNull String location) throws IOException {
        if (location == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "location", "com/intellij/util/net/HttpConfigurable", "openHttpConnection"));
        }
        URLConnection urlConnection = this.openConnection(location);
        if (urlConnection instanceof HttpURLConnection) {
            HttpURLConnection httpURLConnection = (HttpURLConnection)urlConnection;
            if (httpURLConnection == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/net/HttpConfigurable", "openHttpConnection"));
            }
            return httpURLConnection;
        }
        throw new IOException("Expected " + HttpURLConnection.class + ", but got " + urlConnection.getClass());
    }

    public boolean isHttpProxyEnabledForUrl(@Nullable String url) {
        if (!this.USE_HTTP_PROXY) {
            return false;
        }
        URI uri = url != null ? VfsUtil.toUri(url) : null;
        return uri == null || !this.mySelector.isProxyException(uri.getHost());
    }

    public static List<KeyValue<String, String>> getJvmPropertiesList(boolean withAutodetection, @Nullable URI uri) {
        List<Pair<String, String>> properties = HttpConfigurable.getInstance().getJvmProperties(withAutodetection, uri);
        return properties.stream().map(p -> KeyValue.create((Object)p.first, (Object)p.second)).collect(Collectors.toList());
    }

    @NotNull
    public List<Pair<String, String>> getJvmProperties(boolean withAutodetection, @Nullable URI uri) {
        ArrayList<Pair<String, String>> result;
        block9: {
            List<Proxy> proxies;
            block7: {
                boolean putCredentials;
                block8: {
                    if (!this.USE_HTTP_PROXY && !this.USE_PROXY_PAC) {
                        List<Pair<String, String>> list = Collections.emptyList();
                        if (list == null) {
                            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/net/HttpConfigurable", "getJvmProperties"));
                        }
                        return list;
                    }
                    result = new ArrayList<Pair<String, String>>();
                    if (!this.USE_HTTP_PROXY) break block7;
                    boolean bl = putCredentials = this.KEEP_PROXY_PASSWORD && StringUtil.isNotEmpty((String)this.getProxyLogin());
                    if (!this.PROXY_TYPE_IS_SOCKS) break block8;
                    result.add((Pair<String, String>)Pair.pair((Object)"socksProxyHost", (Object)this.PROXY_HOST));
                    result.add((Pair<String, String>)Pair.pair((Object)"socksProxyPort", (Object)String.valueOf(this.PROXY_PORT)));
                    if (putCredentials) {
                        result.add((Pair<String, String>)Pair.pair((Object)"java.net.socks.username", (Object)this.getProxyLogin()));
                        result.add((Pair<String, String>)Pair.pair((Object)"java.net.socks.password", (Object)this.getPlainProxyPassword()));
                    }
                    break block9;
                }
                result.add((Pair<String, String>)Pair.pair((Object)"http.proxyHost", (Object)this.PROXY_HOST));
                result.add((Pair<String, String>)Pair.pair((Object)"http.proxyPort", (Object)String.valueOf(this.PROXY_PORT)));
                result.add((Pair<String, String>)Pair.pair((Object)"https.proxyHost", (Object)this.PROXY_HOST));
                result.add((Pair<String, String>)Pair.pair((Object)"https.proxyPort", (Object)String.valueOf(this.PROXY_PORT)));
                if (!putCredentials) break block9;
                result.add((Pair<String, String>)Pair.pair((Object)"proxy.authentication.username", (Object)this.getProxyLogin()));
                result.add((Pair<String, String>)Pair.pair((Object)"proxy.authentication.password", (Object)this.getPlainProxyPassword()));
                break block9;
            }
            if (this.USE_PROXY_PAC && withAutodetection && uri != null && (proxies = CommonProxy.getInstance().select(uri)) != null && !proxies.isEmpty()) {
                for (Proxy proxy : proxies) {
                    SocketAddress address;
                    if (!HttpConfigurable.isRealProxy(proxy) || !((address = proxy.address()) instanceof InetSocketAddress)) continue;
                    InetSocketAddress inetSocketAddress = (InetSocketAddress)address;
                    if (Proxy.Type.SOCKS.equals((Object)proxy.type())) {
                        result.add((Pair<String, String>)Pair.pair((Object)"socksProxyHost", (Object)inetSocketAddress.getHostName()));
                        result.add((Pair<String, String>)Pair.pair((Object)"socksProxyPort", (Object)String.valueOf(inetSocketAddress.getPort())));
                        continue;
                    }
                    result.add((Pair<String, String>)Pair.pair((Object)"http.proxyHost", (Object)inetSocketAddress.getHostName()));
                    result.add((Pair<String, String>)Pair.pair((Object)"http.proxyPort", (Object)String.valueOf(inetSocketAddress.getPort())));
                    result.add((Pair<String, String>)Pair.pair((Object)"https.proxyHost", (Object)inetSocketAddress.getHostName()));
                    result.add((Pair<String, String>)Pair.pair((Object)"https.proxyPort", (Object)String.valueOf(inetSocketAddress.getPort())));
                }
            }
        }
        ArrayList<Pair<String, String>> arrayList = result;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/net/HttpConfigurable", "getJvmProperties"));
        }
        return arrayList;
    }

    public static boolean isRealProxy(@NotNull Proxy proxy) {
        if (proxy == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "proxy", "com/intellij/util/net/HttpConfigurable", "isRealProxy"));
        }
        return !Proxy.NO_PROXY.equals(proxy) && !Proxy.Type.DIRECT.equals((Object)proxy.type());
    }

    @NotNull
    public static List<String> convertArguments(@NotNull List<KeyValue<String, String>> list) {
        if (list == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "com/intellij/util/net/HttpConfigurable", "convertArguments"));
        }
        if (list.isEmpty()) {
            List<String> list2 = Collections.emptyList();
            if (list2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/net/HttpConfigurable", "convertArguments"));
            }
            return list2;
        }
        ArrayList<String> result = new ArrayList<String>(list.size());
        for (KeyValue<String, String> value : list) {
            result.add("-D" + (String)value.getKey() + "=" + (String)value.getValue());
        }
        ArrayList<String> arrayList = result;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/net/HttpConfigurable", "convertArguments"));
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearGenericPasswords() {
        Object object = this.myLock;
        synchronized (object) {
            this.myGenericPasswords.clear();
            this.myGenericCancelled.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeGeneric(@NotNull CommonProxy.HostInfo info) {
        if (info == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "info", "com/intellij/util/net/HttpConfigurable", "removeGeneric"));
        }
        Object object = this.myLock;
        synchronized (object) {
            this.myGenericPasswords.remove((Object)info);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getSecure(String key) {
        try {
            NotNullLazyValue<Properties> notNullLazyValue = this.myProxyCredentials;
            synchronized (notNullLazyValue) {
                Properties props = (Properties)this.myProxyCredentials.getValue();
                return props.getProperty(key, null);
            }
        }
        catch (Exception e) {
            LOG.info((Throwable)e);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void storeSecure(String key, @Nullable String value) {
        if (value == null) {
            this.removeSecure(key);
            return;
        }
        try {
            NotNullLazyValue<Properties> notNullLazyValue = this.myProxyCredentials;
            synchronized (notNullLazyValue) {
                Properties props = (Properties)this.myProxyCredentials.getValue();
                props.setProperty(key, value);
                this.myEncryptionSupport.store(props, "Proxy Credentials", PROXY_CREDENTIALS_FILE);
            }
        }
        catch (Exception e) {
            LOG.info((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeSecure(String key) {
        try {
            NotNullLazyValue<Properties> notNullLazyValue = this.myProxyCredentials;
            synchronized (notNullLazyValue) {
                Properties props = (Properties)this.myProxyCredentials.getValue();
                props.remove(key);
                this.myEncryptionSupport.store(props, "Proxy Credentials", PROXY_CREDENTIALS_FILE);
            }
        }
        catch (Exception e) {
            LOG.info((Throwable)e);
        }
    }

    public static class ProxyInfo {
        public boolean myStore;
        public String myUsername;
        public String myPasswordCrypt;

        public ProxyInfo() {
        }

        public ProxyInfo(boolean store, String username, String passwordCrypt) {
            this.myStore = store;
            this.myUsername = username;
            this.myPasswordCrypt = passwordCrypt;
        }

        public boolean isStore() {
            return this.myStore;
        }

        public void setStore(boolean store) {
            this.myStore = store;
        }

        public String getUsername() {
            return this.myUsername;
        }

        public void setUsername(String username) {
            this.myUsername = username;
        }

        public String getPasswordCrypt() {
            return this.myPasswordCrypt;
        }

        public void setPasswordCrypt(String passwordCrypt) {
            this.myPasswordCrypt = passwordCrypt;
        }
    }
}

