/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.webcore.libraries;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.GlobalSearchScopesCore;
import com.intellij.webcore.libraries.ScriptingLibraryMappings;
import gnu.trove.THashSet;
import java.util.Collection;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ScriptingLibraryUtil {
    private static final Key<ScriptingLibraryMappings> MAPPINGS_KEY = Key.create((String)ScriptingLibraryMappings.class.getSimpleName());

    private ScriptingLibraryUtil() {
    }

    public static void registerJSLibraryMappings(@NotNull Project project, @NotNull ScriptingLibraryMappings mappings) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/webcore/libraries/ScriptingLibraryUtil", "registerJSLibraryMappings"));
        }
        if (mappings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mappings", "com/intellij/webcore/libraries/ScriptingLibraryUtil", "registerJSLibraryMappings"));
        }
        MAPPINGS_KEY.set((UserDataHolder)project, (Object)mappings);
    }

    @NotNull
    public static GlobalSearchScope getJSLibraryScopeForFile(@NotNull Project project, @Nullable VirtualFile file) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/webcore/libraries/ScriptingLibraryUtil", "getJSLibraryScopeForFile"));
        }
        if (file == null) {
            GlobalSearchScope globalSearchScope = GlobalSearchScope.EMPTY_SCOPE;
            if (globalSearchScope == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/webcore/libraries/ScriptingLibraryUtil", "getJSLibraryScopeForFile"));
            }
            return globalSearchScope;
        }
        ScriptingLibraryMappings mappings = (ScriptingLibraryMappings)MAPPINGS_KEY.get((UserDataHolder)project);
        GlobalSearchScope globalSearchScope = mappings != null ? mappings.getLibraryScopeForFile(file) : GlobalSearchScope.EMPTY_SCOPE;
        if (globalSearchScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/webcore/libraries/ScriptingLibraryUtil", "getJSLibraryScopeForFile"));
        }
        return globalSearchScope;
    }

    @NotNull
    public static GlobalSearchScope getFilesAndDirectoriesScope(@NotNull Project project, @NotNull Set<VirtualFile> filesAndDirectories) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/webcore/libraries/ScriptingLibraryUtil", "getFilesAndDirectoriesScope"));
        }
        if (filesAndDirectories == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filesAndDirectories", "com/intellij/webcore/libraries/ScriptingLibraryUtil", "getFilesAndDirectoriesScope"));
        }
        THashSet libraryFiles = new THashSet();
        GlobalSearchScope scope = GlobalSearchScope.EMPTY_SCOPE;
        for (VirtualFile file : filesAndDirectories) {
            if (file.isDirectory()) {
                GlobalSearchScope directoryScope = GlobalSearchScopesCore.directoryScope(project, file, true);
                scope = scope.uniteWith(directoryScope);
                continue;
            }
            libraryFiles.add(file);
        }
        if (libraryFiles.size() > 0) {
            scope = scope.uniteWith(GlobalSearchScope.filesScope(project, (Collection<VirtualFile>)libraryFiles));
        }
        GlobalSearchScope globalSearchScope = scope;
        if (globalSearchScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/webcore/libraries/ScriptingLibraryUtil", "getFilesAndDirectoriesScope"));
        }
        return globalSearchScope;
    }
}

