/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.model.converters.fixes.bean;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.intention.HighPriorityAction;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.ide.DataManager;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.UndoConfirmationPolicy;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.ui.popup.ListPopupStep;
import com.intellij.openapi.ui.popup.PopupStep;
import com.intellij.openapi.ui.popup.util.BaseListPopupStep;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.xml.XmlFile;
import com.intellij.spring.model.converters.fixes.bean.SpringBeanResolveQuickFixProvider;
import com.intellij.spring.model.xml.BeanProviderRegistry;
import com.intellij.spring.model.xml.BeanType;
import com.intellij.spring.model.xml.BeanTypeProvider;
import com.intellij.spring.model.xml.DomSpringBean;
import com.intellij.spring.model.xml.beans.Beans;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xml.ConvertContext;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomFileDescription;
import com.intellij.util.xml.DomReflectionUtil;
import com.intellij.util.xml.DomUtil;
import com.intellij.util.xml.GenericDomValue;
import com.intellij.util.xml.converters.values.ClassValueConverter;
import com.intellij.util.xml.reflect.DomCollectionChildDescription;
import com.intellij.xml.XmlNamespaceHelper;
import com.intellij.xml.util.XmlUtil;
import icons.SpringApiIcons;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class CustomNamespaceSpringBeanResolveQuickFixProvider
implements SpringBeanResolveQuickFixProvider {
    private static final Condition<QuickFixInfo> DEFINED_NAMESPACE_CONDITION = info -> ((QuickFixInfo)info).namespaceResult == QuickFixInfo.NamespaceResult.DEFINED;

    CustomNamespaceSpringBeanResolveQuickFixProvider() {
    }

    private static QuickFixInfo getQuickFixInfo(XmlFile contextFile, DomCollectionChildDescription description, DomFileDescription<DomElement> domFileDescription) {
        String namespaceKey = description.getXmlName().getNamespaceKey();
        List namespaces = namespaceKey == null ? Collections.emptyList() : domFileDescription.getAllowedNamespaces(namespaceKey, contextFile);
        String elementName = description.getXmlElementName();
        if (namespaces.isEmpty()) {
            return new QuickFixInfo(description, "<" + elementName + ">", QuickFixInfo.NamespaceResult.NOT_FOUND, null);
        }
        for (String namespace : namespaces) {
            String prefixByURI = XmlUtil.findNamespacePrefixByURI((XmlFile)contextFile, (String)namespace);
            if (prefixByURI == null) continue;
            String namespacePrefixDisplay = prefixByURI.length() != 0 ? prefixByURI + ":" : "";
            return new QuickFixInfo(description, "<" + namespacePrefixDisplay + elementName + ">", QuickFixInfo.NamespaceResult.DEFINED, null);
        }
        String namespaceURI = (String)ContainerUtil.getFirstItem((List)namespaces);
        return new QuickFixInfo(description, "<" + elementName + "> (" + namespaceURI + ")", QuickFixInfo.NamespaceResult.UNDEFINED, namespaceURI);
    }

    private static void createCustomNamespaceBean(QuickFixInfo info, Beans beans, String beanId) {
        if (!FileModificationService.getInstance().preparePsiElementForWrite((PsiElement)beans.getXmlElement())) {
            return;
        }
        if (info.namespaceResult == QuickFixInfo.NamespaceResult.UNDEFINED) {
            PsiFile file = beans.getXmlTag().getContainingFile();
            XmlNamespaceHelper extension = XmlNamespaceHelper.getHelper((PsiFile)file);
            extension.insertNamespaceDeclaration((XmlFile)file, null, Collections.singleton(info.namespaceURI), null, null);
        }
        DomSpringBean domSpringBean = (DomSpringBean)info.description.addValue((DomElement)beans);
        domSpringBean.getId().ensureXmlElementExists();
        domSpringBean.setName(beanId);
    }

    @Override
    @NotNull
    public List<LocalQuickFix> getQuickFixes(ConvertContext context, @NotNull Beans beans, @Nullable String beanId, List<PsiClassType> requiredClasses) {
        String stringValue;
        if (beans == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "beans", "com/intellij/spring/model/converters/fixes/bean/CustomNamespaceSpringBeanResolveQuickFixProvider", "getQuickFixes"));
        }
        if (requiredClasses.isEmpty()) {
            List<LocalQuickFix> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/converters/fixes/bean/CustomNamespaceSpringBeanResolveQuickFixProvider", "getQuickFixes"));
            }
            return list;
        }
        GenericDomValue value = (GenericDomValue)context.getInvocationElement();
        String string = stringValue = beanId != null ? beanId : value.getStringValue();
        if (stringValue == null) {
            List<LocalQuickFix> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/converters/fixes/bean/CustomNamespaceSpringBeanResolveQuickFixProvider", "getQuickFixes"));
            }
            return list;
        }
        String id = stringValue.trim();
        if (StringUtil.isEmptyOrSpaces((String)id)) {
            List<LocalQuickFix> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/converters/fixes/bean/CustomNamespaceSpringBeanResolveQuickFixProvider", "getQuickFixes"));
            }
            return list;
        }
        Module module = context.getModule();
        if (module == null || module.isDisposed()) {
            List<LocalQuickFix> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/converters/fixes/bean/CustomNamespaceSpringBeanResolveQuickFixProvider", "getQuickFixes"));
            }
            return list;
        }
        DomFileDescription domFileDescription = DomUtil.getFileElement((DomElement)beans).getFileDescription();
        XmlFile contextFile = context.getFile();
        Map<DomCollectionChildDescription, PsiClass> mappings = CustomNamespaceSpringBeanResolveQuickFixProvider.getAvailableDomToPsiClassMappings(beans, module, contextFile);
        List resolvedRequiredClasses = ContainerUtil.mapNotNull(requiredClasses, type -> {
            PsiClass resolve = type.resolve();
            if (resolve == null || "java.lang.Object".equals(resolve.getQualifiedName())) {
                return null;
            }
            return resolve;
        });
        SmartList quickFixInfos = new SmartList();
        block0: for (Map.Entry<DomCollectionChildDescription, PsiClass> mapping : mappings.entrySet()) {
            for (PsiClass required : resolvedRequiredClasses) {
                if (!InheritanceUtil.isInheritorOrSelf((PsiClass)mapping.getValue(), (PsiClass)required, (boolean)true)) continue;
                QuickFixInfo quickFixInfo = CustomNamespaceSpringBeanResolveQuickFixProvider.getQuickFixInfo(contextFile, mapping.getKey(), (DomFileDescription<DomElement>)domFileDescription);
                quickFixInfos.add(quickFixInfo);
                continue block0;
            }
        }
        List defined = ContainerUtil.filter((Collection)quickFixInfos, DEFINED_NAMESPACE_CONDITION);
        SmartList quickFixes = new SmartList();
        for (QuickFixInfo info : defined) {
            quickFixes.add(new CreateDefinedQuickFix(info, beans, id));
        }
        quickFixInfos.removeAll(defined);
        if (!quickFixInfos.isEmpty()) {
            quickFixes.add(new CreateFromUndefinedNamespaceQuickFix((List)quickFixInfos, beans, id));
        }
        SmartList smartList = quickFixes;
        if (smartList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/converters/fixes/bean/CustomNamespaceSpringBeanResolveQuickFixProvider", "getQuickFixes"));
        }
        return smartList;
    }

    private static Map<DomCollectionChildDescription, PsiClass> getAvailableDomToPsiClassMappings(Beans beans, Module module, XmlFile contextFile) {
        return (Map)CachedValuesManager.getCachedValue((PsiElement)contextFile, () -> {
            if (module.isDisposed()) {
                return CachedValueProvider.Result.create(Collections.emptyMap(), (Object[])new Object[]{contextFile});
            }
            Project project = module.getProject();
            GlobalSearchScope searchScope = ClassValueConverter.getScope((Project)project, (Module)module, (PsiFile)contextFile);
            JavaPsiFacade javaPsiFacade = JavaPsiFacade.getInstance((Project)project);
            LinkedHashMap<DomCollectionChildDescription, PsiClass> result = new LinkedHashMap<DomCollectionChildDescription, PsiClass>();
            List descriptions = beans.getGenericInfo().getCollectionChildrenDescriptions();
            for (DomCollectionChildDescription description : descriptions) {
                Class clazz;
                BeanType beanType;
                Type childDescriptionType = description.getType();
                Class type = ReflectionUtil.getRawType((Type)childDescriptionType);
                if (!DomSpringBean.class.isAssignableFrom(type) || (beanType = (BeanType)DomReflectionUtil.findAnnotationDFS((Class)(clazz = (Class)childDescriptionType), BeanType.class)) == null) continue;
                PsiClass beanClass = null;
                if (!beanType.value().isEmpty()) {
                    String staticBeanClass = beanType.value();
                    beanClass = javaPsiFacade.findClass(staticBeanClass, searchScope);
                } else {
                    String candidateFqn;
                    BeanTypeProvider provider1 = BeanProviderRegistry.getInstance().getBeanTypeProvider(beanType.provider());
                    String[] stringArray = provider1.getBeanTypeCandidates();
                    int n = stringArray.length;
                    for (int i = 0; i < n && (beanClass = javaPsiFacade.findClass(candidateFqn = stringArray[i], searchScope)) == null; ++i) {
                    }
                }
                if (beanClass == null) continue;
                result.put(description, beanClass);
            }
            return CachedValueProvider.Result.create(result, (Object[])new Object[]{contextFile});
        });
    }

    private static class CreateDefinedQuickFix
    implements LocalQuickFix,
    HighPriorityAction {
        private final QuickFixInfo myQuickFixInfo;
        private final Beans myBeans;
        private final String myId;

        private CreateDefinedQuickFix(QuickFixInfo quickFixInfo, Beans beans, String id) {
            this.myQuickFixInfo = quickFixInfo;
            this.myBeans = beans;
            this.myId = id;
        }

        @NotNull
        public String getName() {
            String string = "Create " + this.myQuickFixInfo.displayName;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/converters/fixes/bean/CustomNamespaceSpringBeanResolveQuickFixProvider$CreateDefinedQuickFix", "getName"));
            }
            return string;
        }

        @NotNull
        public String getFamilyName() {
            if ("Create custom namespace bean" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/converters/fixes/bean/CustomNamespaceSpringBeanResolveQuickFixProvider$CreateDefinedQuickFix", "getFamilyName"));
            }
            return "Create custom namespace bean";
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/spring/model/converters/fixes/bean/CustomNamespaceSpringBeanResolveQuickFixProvider$CreateDefinedQuickFix", "applyFix"));
            }
            if (descriptor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/spring/model/converters/fixes/bean/CustomNamespaceSpringBeanResolveQuickFixProvider$CreateDefinedQuickFix", "applyFix"));
            }
            CustomNamespaceSpringBeanResolveQuickFixProvider.createCustomNamespaceBean(this.myQuickFixInfo, this.myBeans, this.myId);
        }
    }

    private static class CreateFromUndefinedNamespaceQuickFix
    implements LocalQuickFix {
        private final List<QuickFixInfo> myQuickFixInfos;
        private final Beans myBeans;
        private final String myId;

        private CreateFromUndefinedNamespaceQuickFix(List<QuickFixInfo> infos, Beans beans, String id) {
            this.myQuickFixInfos = infos;
            this.myBeans = beans;
            this.myId = id;
        }

        @NotNull
        public String getName() {
            String string = "Create custom namespace bean (" + this.myQuickFixInfos.size() + " variants)...";
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/converters/fixes/bean/CustomNamespaceSpringBeanResolveQuickFixProvider$CreateFromUndefinedNamespaceQuickFix", "getName"));
            }
            return string;
        }

        @NotNull
        public String getFamilyName() {
            if ("Create custom namespace bean" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/converters/fixes/bean/CustomNamespaceSpringBeanResolveQuickFixProvider$CreateFromUndefinedNamespaceQuickFix", "getFamilyName"));
            }
            return "Create custom namespace bean";
        }

        public void applyFix(final @NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/spring/model/converters/fixes/bean/CustomNamespaceSpringBeanResolveQuickFixProvider$CreateFromUndefinedNamespaceQuickFix", "applyFix"));
            }
            if (descriptor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/spring/model/converters/fixes/bean/CustomNamespaceSpringBeanResolveQuickFixProvider$CreateFromUndefinedNamespaceQuickFix", "applyFix"));
            }
            if (ApplicationManager.getApplication().isUnitTestMode()) {
                this.doApplyFix((QuickFixInfo)ContainerUtil.getFirstItem(this.myQuickFixInfos), project);
                return;
            }
            BaseListPopupStep<QuickFixInfo> step = new BaseListPopupStep<QuickFixInfo>("Create Custom Namespace Bean", this.myQuickFixInfos, SpringApiIcons.SpringBean){

                @NotNull
                public String getTextFor(QuickFixInfo value) {
                    String string = value.displayName;
                    if (string == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/converters/fixes/bean/CustomNamespaceSpringBeanResolveQuickFixProvider$CreateFromUndefinedNamespaceQuickFix$1", "getTextFor"));
                    }
                    return string;
                }

                public boolean isSpeedSearchEnabled() {
                    return true;
                }

                public PopupStep onChosen(QuickFixInfo selectedValue, boolean finalChoice) {
                    if (selectedValue != null) {
                        this.doApplyFix(selectedValue, project);
                    }
                    return FINAL_CHOICE;
                }
            };
            ListPopup popup = JBPopupFactory.getInstance().createListPopup((ListPopupStep)step);
            popup.setAdText("Start typing to filter elements", 2);
            DataManager.getInstance().getDataContextFromFocus().doWhenDone(dataContext -> popup.showInBestPositionFor(dataContext));
        }

        private void doApplyFix(final QuickFixInfo selectedValue, Project project) {
            new WriteCommandAction.Simple(project, "Create custom namespace bean " + this.myId, new PsiFile[0]){

                protected void run() throws Throwable {
                    CustomNamespaceSpringBeanResolveQuickFixProvider.createCustomNamespaceBean(selectedValue, myBeans, myId);
                }

                protected UndoConfirmationPolicy getUndoConfirmationPolicy() {
                    return UndoConfirmationPolicy.REQUEST_CONFIRMATION;
                }
            }.execute();
        }
    }

    private static class QuickFixInfo {
        private final DomCollectionChildDescription description;
        private final String displayName;
        private final NamespaceResult namespaceResult;
        private final String namespaceURI;

        private QuickFixInfo(DomCollectionChildDescription domCollectionChildDescription, String name, NamespaceResult result, String uri) {
            this.description = domCollectionChildDescription;
            this.displayName = name;
            this.namespaceResult = result;
            this.namespaceURI = uri;
        }

        static enum NamespaceResult {
            NOT_FOUND,
            UNDEFINED,
            DEFINED;

        }
    }
}

