/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.model.highlighting;

import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlFile;
import com.intellij.spring.SpringManager;
import com.intellij.spring.contexts.model.SpringModel;
import com.intellij.spring.model.xml.DomSpringBean;
import com.intellij.spring.model.xml.beans.Beans;
import com.intellij.util.Consumer;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomFileElement;
import com.intellij.util.xml.DomUtil;
import com.intellij.util.xml.GenericDomValue;
import com.intellij.util.xml.highlighting.DomElementAnnotationHolder;
import com.intellij.util.xml.highlighting.DomElementsInspection;

public abstract class DomSpringBeanInspectionBase
extends DomElementsInspection<Beans> {
    public DomSpringBeanInspectionBase() {
        super(Beans.class, new Class[0]);
    }

    public void checkFileElement(DomFileElement<Beans> domFileElement, final DomElementAnnotationHolder holder) {
        XmlFile xmlFile = domFileElement.getFile();
        final Beans beans = (Beans)domFileElement.getRootElement();
        final SpringModel model = SpringManager.getInstance((Project)xmlFile.getProject()).getSpringModelByFile((PsiFile)xmlFile);
        Consumer<DomElement> consumer = new Consumer<DomElement>(){

            public void consume(DomElement element) {
                if (element instanceof DomSpringBean) {
                    DomSpringBeanInspectionBase.this.checkBean((DomSpringBean)element, beans, holder, model);
                } else if (!(element instanceof GenericDomValue) && DomUtil.hasXml((DomElement)element)) {
                    DomSpringBeanInspectionBase.this.checkChildren(element, this);
                }
            }
        };
        consumer.consume((Object)domFileElement.getRootElement());
    }

    protected void checkBean(DomSpringBean springBean, Beans beans, DomElementAnnotationHolder holder, SpringModel springModel) {
    }
}

