/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.model.highlighting;

import com.intellij.spring.contexts.model.XmlSpringModel;
import com.intellij.spring.model.highlighting.dom.SpringBeanInspectionBase;
import com.intellij.spring.model.highlighting.dom.SpringDomInspectionUtils;
import com.intellij.spring.model.scope.SpringBeanScope;
import com.intellij.spring.model.xml.beans.Beans;
import com.intellij.spring.model.xml.beans.SpringBean;
import com.intellij.spring.model.xml.beans.SpringValueHolder;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.GenericAttributeValue;
import com.intellij.util.xml.highlighting.DomElementAnnotationHolder;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class SpringBeanAttributesInspection
extends SpringBeanInspectionBase {
    protected void checkBean(SpringBean springBean, Beans beans, DomElementAnnotationHolder holder, XmlSpringModel springModel) {
        SpringDomInspectionUtils utils = new SpringDomInspectionUtils(holder);
        if (!utils.onlyOneOf((DomElement)springBean, new GenericAttributeValue[]{springBean.getClazz(), springBean.getFactoryBean()})) {
            utils.ifExistsOtherRequired((DomElement)springBean, springBean.getFactoryBean(), springBean.getFactoryMethod());
        }
        utils.attributeWithDefaultSuperfluous(springBean.getAbstract(), (Object)Boolean.FALSE);
        utils.attributeWithDefaultSuperfluous(springBean.getSingleton(), (Object)Boolean.TRUE);
        utils.attributeWithDefaultSuperfluous(springBean.getScope(), (Object)SpringBeanScope.SINGLETON_SCOPE);
        if (springBean.getParent() instanceof SpringValueHolder) {
            utils.attributeSuperfluous(springBean.getId());
            utils.attributeSuperfluous(springBean.getName());
            utils.attributeSuperfluous(springBean.getScope());
        }
    }

    @NonNls
    @NotNull
    public String getShortName() {
        if ("SpringBeanAttributesInspection" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/highlighting/SpringBeanAttributesInspection", "getShortName"));
        }
        return "SpringBeanAttributesInspection";
    }
}

