/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.model.highlighting.jam;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.jam.JamService;
import com.intellij.jam.JamStringAttributeElement;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.spring.SpringBundle;
import com.intellij.spring.model.highlighting.jam.AbstractSpringJavaConfigInspection;
import com.intellij.spring.model.jam.JamPsiMemberSpringBean;
import com.intellij.spring.model.jam.javaConfig.ContextJavaBean;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ContextJavaBeanUnresolvedMethodsInspection
extends AbstractSpringJavaConfigInspection {
    protected void checkClass(PsiClass aClass, ProblemsHolder holder, @NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/spring/model/highlighting/jam/ContextJavaBeanUnresolvedMethodsInspection", "checkClass"));
        }
        for (PsiMethod psiMethod : aClass.getMethods()) {
            ContextJavaBeanUnresolvedMethodsInspection.checkMethod(psiMethod, holder, module);
        }
    }

    private static void checkMethod(@NotNull PsiMethod psiMethod, @NotNull ProblemsHolder holder, @NotNull Module module) {
        if (psiMethod == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiMethod", "com/intellij/spring/model/highlighting/jam/ContextJavaBeanUnresolvedMethodsInspection", "checkMethod"));
        }
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/spring/model/highlighting/jam/ContextJavaBeanUnresolvedMethodsInspection", "checkMethod"));
        }
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/spring/model/highlighting/jam/ContextJavaBeanUnresolvedMethodsInspection", "checkMethod"));
        }
        ContextJavaBean contextJavaBean = ContextJavaBeanUnresolvedMethodsInspection.getContextJavaBean(psiMethod, module);
        if (contextJavaBean != null) {
            ContextJavaBeanUnresolvedMethodsInspection.checkContextJavaBean(contextJavaBean, holder);
        }
    }

    private static void checkContextJavaBean(@NotNull ContextJavaBean contextJavaBean, @NotNull ProblemsHolder holder) {
        if (contextJavaBean == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "contextJavaBean", "com/intellij/spring/model/highlighting/jam/ContextJavaBeanUnresolvedMethodsInspection", "checkContextJavaBean"));
        }
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/spring/model/highlighting/jam/ContextJavaBeanUnresolvedMethodsInspection", "checkContextJavaBean"));
        }
        ContextJavaBeanUnresolvedMethodsInspection.checkMethodExists(contextJavaBean, holder, (JamStringAttributeElement<PsiMethod>)contextJavaBean.getInitMethodAttributeElement());
        ContextJavaBeanUnresolvedMethodsInspection.checkMethodExists(contextJavaBean, holder, (JamStringAttributeElement<PsiMethod>)contextJavaBean.getDestroyMethodAttributeElement());
    }

    private static void checkMethodExists(ContextJavaBean contextJavaBean, ProblemsHolder holder, JamStringAttributeElement<PsiMethod> methodAttributeElement) {
        if (methodAttributeElement.getStringValue() != null && methodAttributeElement.getValue() == null) {
            PsiAnnotationMemberValue memberValue = methodAttributeElement.getPsiElement();
            PsiAnnotationMemberValue psiElement = memberValue == null ? contextJavaBean.getPsiAnnotation() : memberValue;
            holder.registerProblem((PsiElement)psiElement, SpringBundle.message("ContextJavaBeanUnresolvedMethodsInspection.cannot.resolve.method", new Object[0]), new LocalQuickFix[0]);
        }
    }

    @Nullable
    private static ContextJavaBean getContextJavaBean(@NotNull PsiMethod psiMethod, @NotNull Module module) {
        if (psiMethod == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiMethod", "com/intellij/spring/model/highlighting/jam/ContextJavaBeanUnresolvedMethodsInspection", "getContextJavaBean"));
        }
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/spring/model/highlighting/jam/ContextJavaBeanUnresolvedMethodsInspection", "getContextJavaBean"));
        }
        JamPsiMemberSpringBean memberSpringBean = (JamPsiMemberSpringBean)JamService.getJamService((Project)module.getProject()).getJamElement(JamPsiMemberSpringBean.PSI_MEMBER_SPRING_BEAN_JAM_KEY, (PsiElement)psiMethod);
        return memberSpringBean instanceof ContextJavaBean ? (ContextJavaBean)memberSpringBean : null;
    }

    @NotNull
    public String getShortName() {
        if ("ContextJavaBeanUnresolvedMethodsInspection" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/highlighting/jam/ContextJavaBeanUnresolvedMethodsInspection", "getShortName"));
        }
        return "ContextJavaBeanUnresolvedMethodsInspection";
    }
}

