/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.model.values.converters.resources;

import com.intellij.lang.properties.PropertiesImplUtil;
import com.intellij.openapi.util.Condition;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.spring.model.values.converters.SpringValueConditionFactory;
import com.intellij.spring.model.values.converters.resources.SpringResourceTypeProvider;
import com.intellij.util.containers.hash.HashMap;
import com.intellij.util.xml.GenericDomValue;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SpringCustomResourceTypeProvider
implements SpringResourceTypeProvider {
    private final Map<Condition<GenericDomValue>, Condition<PsiFileSystemItem>> myFilterMap = new HashMap();

    public SpringCustomResourceTypeProvider() {
        Condition condition = psiFileSystemItem -> psiFileSystemItem instanceof PsiFile && PropertiesImplUtil.isPropertiesFile((PsiFile)((PsiFile)psiFileSystemItem));
        this.addResourceFilter("org.springframework.beans.factory.config.PropertiesFactoryBean", (Condition<PsiFileSystemItem>)condition, "location");
        this.addResourceFilter("org.springframework.beans.factory.config.PropertyPlaceholderConfigurer", (Condition<PsiFileSystemItem>)condition, "location", "locations");
    }

    private void addResourceFilter(@NotNull String beanClass, Condition<PsiFileSystemItem> condition, String ... propertyNames) {
        if (beanClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "beanClass", "com/intellij/spring/model/values/converters/resources/SpringCustomResourceTypeProvider", "addResourceFilter"));
        }
        if (propertyNames == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "propertyNames", "com/intellij/spring/model/values/converters/resources/SpringCustomResourceTypeProvider", "addResourceFilter"));
        }
        this.myFilterMap.put((Condition<GenericDomValue>)SpringValueConditionFactory.createBeanPropertyCondition((String)beanClass, (String[])propertyNames), condition);
    }

    @Nullable
    public Condition<PsiFileSystemItem> getResourceFilter(@NotNull GenericDomValue genericDomValue) {
        if (genericDomValue == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "genericDomValue", "com/intellij/spring/model/values/converters/resources/SpringCustomResourceTypeProvider", "getResourceFilter"));
        }
        for (Map.Entry<Condition<GenericDomValue>, Condition<PsiFileSystemItem>> entry : this.myFilterMap.entrySet()) {
            if (!entry.getKey().value((Object)genericDomValue)) continue;
            return entry.getValue();
        }
        return null;
    }
}

