/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.model.xml.impl;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.openapi.util.VolatileNotNullLazyValue;
import com.intellij.psi.PsiElement;
import com.intellij.psi.xml.XmlTag;
import com.intellij.spring.dom.SpringToolDomExtender;
import com.intellij.spring.model.xml.CustomBean;
import com.intellij.spring.model.xml.CustomBeanWrapper;
import com.intellij.spring.model.xml.DomSpringBeanImpl;
import com.intellij.spring.model.xml.custom.CustomBeanInfo;
import com.intellij.spring.model.xml.custom.CustomBeanRegistry;
import com.intellij.spring.model.xml.custom.CustomNamespaceSpringBean;
import com.intellij.xml.XmlElementDescriptor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class CustomBeanWrapperImpl
extends DomSpringBeanImpl
implements CustomBeanWrapper {
    private final NotNullLazyValue<List<CustomBean>> myBeans = new VolatileNotNullLazyValue<List<CustomBean>>(){

        @NotNull
        protected List<CustomBean> compute() {
            XmlTag tag = CustomBeanWrapperImpl.this.getXmlTag();
            if (tag == null) {
                LOG.warn("No XML tag found for " + CustomBeanWrapperImpl.this.getXmlElement());
                List<CustomBean> list = Collections.emptyList();
                if (list == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/xml/impl/CustomBeanWrapperImpl$1", "compute"));
                }
                return list;
            }
            List<CustomBeanInfo> infos = CustomBeanRegistry.getInstance(CustomBeanWrapperImpl.this.getPsiManager().getProject()).getParseResult(tag);
            if (infos == null || infos.isEmpty()) {
                CustomBean bean = CustomBeanWrapperImpl.this.getExportingBean(tag);
                List<Object> list = bean != null ? Collections.singletonList(bean) : Collections.emptyList();
                if (list == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/xml/impl/CustomBeanWrapperImpl$1", "compute"));
                }
                return list;
            }
            ArrayList<CustomBean> result = new ArrayList<CustomBean>(infos.size());
            Module module = CustomBeanWrapperImpl.this.getModule();
            for (CustomBeanInfo info : infos) {
                result.add(new CustomNamespaceSpringBean(info, module, CustomBeanWrapperImpl.this));
            }
            ArrayList<CustomBean> arrayList = result;
            if (arrayList == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/xml/impl/CustomBeanWrapperImpl$1", "compute"));
            }
            return arrayList;
        }
    };
    private static final Logger LOG = Logger.getInstance(CustomBeanWrapperImpl.class);

    @Nullable
    private CustomBean getExportingBean(XmlTag tag) {
        XmlElementDescriptor descriptor = tag.getDescriptor();
        if (descriptor == null) {
            return null;
        }
        PsiElement declaration = descriptor.getDeclaration();
        if (!(declaration instanceof XmlTag)) {
            return null;
        }
        XmlTag declTag = (XmlTag)declaration;
        XmlTag annotationTag = SpringToolDomExtender.getToolAnnotationTag((PsiElement)declTag, true);
        if (annotationTag == null && "element".equals(declTag.getLocalName())) {
            XmlTag[] type = declTag.findSubTags("simpleType", "http://www.w3.org/2001/XMLSchema");
            if (type.length > 0) {
                annotationTag = SpringToolDomExtender.getToolAnnotationTag((PsiElement)type[0], true);
            }
            if (annotationTag == null && (type = declTag.findSubTags("complexType", "http://www.w3.org/2001/XMLSchema")).length > 0) {
                annotationTag = SpringToolDomExtender.getToolAnnotationTag((PsiElement)type[0], true);
            }
        }
        if (annotationTag == null) {
            return null;
        }
        XmlTag[] exports = annotationTag.findSubTags("exports", "http://www.springframework.org/schema/tool");
        if (exports.length == 0) {
            return null;
        }
        CustomBeanInfo info = new CustomBeanInfo();
        info.beanClassName = exports[0].getAttributeValue("type", "http://www.springframework.org/schema/tool");
        String idPtr = exports[0].getAttributeValue("identifier", "http://www.springframework.org/schema/tool");
        if (idPtr == null) {
            info.idAttribute = "id";
        } else if (idPtr.startsWith("@") && !idPtr.contains("/") && !idPtr.contains("[")) {
            info.idAttribute = idPtr.substring(1);
        }
        if (info.idAttribute != null) {
            info.beanName = tag.getAttributeValue(info.idAttribute);
        }
        return new CustomNamespaceSpringBean(info, this.getModule(), this);
    }

    @NotNull
    private List<CustomBean> getCachedValue() {
        List list = (List)this.myBeans.getValue();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/xml/impl/CustomBeanWrapperImpl", "getCachedValue"));
        }
        return list;
    }

    @Nullable
    public String getBeanName() {
        if (!this.isParsed()) {
            return super.getBeanName();
        }
        return null;
    }

    @NotNull
    public List<CustomBean> getCustomBeans() {
        List<CustomBean> list = this.getCachedValue();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/xml/impl/CustomBeanWrapperImpl", "getCustomBeans"));
        }
        return list;
    }

    public boolean isDummy() {
        return this.getCachedValue().isEmpty();
    }

    public boolean isParsed() {
        List<CustomBean> customBeans = this.getCachedValue();
        return !customBeans.isEmpty() || customBeans != Collections.emptyList();
    }
}

