/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.spi;

import com.intellij.codeInspection.unsorted.AlphaUnsortedPropertiesFileInspectionSuppressor;
import com.intellij.icons.AllIcons;
import com.intellij.lang.Language;
import com.intellij.lang.properties.PropertiesFileType;
import com.intellij.lang.properties.PropertiesLanguage;
import com.intellij.lang.properties.psi.PropertiesFile;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeConsumer;
import com.intellij.openapi.fileTypes.FileTypeFactory;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.fileTypes.ex.FileTypeIdentifiableByVirtualFile;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.LayeredIcon;
import icons.SpringApiIcons;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SpringSpiFileProvider
extends FileTypeFactory
implements AlphaUnsortedPropertiesFileInspectionSuppressor {
    static final SpringFactoriesFileType FILE_TYPE = new SpringFactoriesFileType();
    static final String SPRING_FACTORIES_FILE_NAME = "spring.factories";
    static final Icon ICON = new LayeredIcon(new Icon[]{SpringApiIcons.Spring, AllIcons.Actions.New});

    public void createFileTypes(@NotNull FileTypeConsumer consumer) {
        if (consumer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "com/intellij/spring/spi/SpringSpiFileProvider", "createFileTypes"));
        }
        consumer.consume((FileType)FILE_TYPE);
    }

    public boolean suppressInspectionFor(PropertiesFile propertiesFile) {
        return SpringSpiFileProvider.isMyFile(propertiesFile);
    }

    static boolean isMyFile(PropertiesFile propertiesFile) {
        return propertiesFile.getVirtualFile().getFileType() == FILE_TYPE;
    }

    private static class SpringFactoriesFileType
    extends LanguageFileType
    implements FileTypeIdentifiableByVirtualFile {
        private SpringFactoriesFileType() {
            super((Language)PropertiesLanguage.INSTANCE);
        }

        public boolean isMyFileType(@NotNull VirtualFile file) {
            if (file == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/spring/spi/SpringSpiFileProvider$SpringFactoriesFileType", "isMyFileType"));
            }
            if (!Comparing.equal((CharSequence)SpringSpiFileProvider.SPRING_FACTORIES_FILE_NAME, (CharSequence)file.getNameSequence())) {
                return false;
            }
            VirtualFile parent = file.getParent();
            return parent != null && Comparing.equal((CharSequence)"META-INF", (CharSequence)parent.getNameSequence());
        }

        @NotNull
        public String getName() {
            if (SpringSpiFileProvider.SPRING_FACTORIES_FILE_NAME == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/spi/SpringSpiFileProvider$SpringFactoriesFileType", "getName"));
            }
            return SpringSpiFileProvider.SPRING_FACTORIES_FILE_NAME;
        }

        @NotNull
        public String getDescription() {
            if ("spring.factories file" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/spi/SpringSpiFileProvider$SpringFactoriesFileType", "getDescription"));
            }
            return "spring.factories file";
        }

        @NotNull
        public String getDefaultExtension() {
            if ("" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/spi/SpringSpiFileProvider$SpringFactoriesFileType", "getDefaultExtension"));
            }
            return "";
        }

        @Nullable
        public Icon getIcon() {
            return ICON;
        }

        public String getCharset(@NotNull VirtualFile file, @NotNull byte[] content) {
            if (file == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/spring/spi/SpringSpiFileProvider$SpringFactoriesFileType", "getCharset"));
            }
            if (content == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "content", "com/intellij/spring/spi/SpringSpiFileProvider$SpringFactoriesFileType", "getCharset"));
            }
            return PropertiesFileType.INSTANCE.getCharset(file, content);
        }
    }
}

