/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.struts2.dom.struts.impl;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiMethod;
import com.intellij.struts2.dom.struts.action.Action;
import com.intellij.struts2.dom.struts.impl.ActionUtil;
import com.intellij.struts2.dom.struts.strutspackage.DefaultClassRef;
import com.intellij.struts2.dom.struts.strutspackage.StrutsPackage;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomUtil;
import com.intellij.util.xml.GenericAttributeValue;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ActionImpl
implements Action {
    @Nullable
    private String getNameValue() {
        return this.getName().getRawText();
    }

    public boolean isWildcardMapping() {
        String name = this.getNameValue();
        return name != null && StringUtil.indexOf((CharSequence)name, (char)'*') != -1;
    }

    public boolean matchesPath(@NotNull String path) {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/struts2/dom/struts/impl/ActionImpl", "matchesPath"));
        }
        String myPath = this.getNameValue();
        if (myPath == null) {
            return false;
        }
        return ActionUtil.matchesPath(myPath, path);
    }

    @NotNull
    public StrutsPackage getStrutsPackage() {
        StrutsPackage strutsPackage = (StrutsPackage)DomUtil.getParentOfType((DomElement)this, StrutsPackage.class, (boolean)true);
        if (strutsPackage == null) {
            throw new IllegalStateException("could not resolve enclosing <package> for " + this + " (" + this.getNameValue() + ")");
        }
        StrutsPackage strutsPackage2 = strutsPackage;
        if (strutsPackage2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/struts2/dom/struts/impl/ActionImpl", "getStrutsPackage"));
        }
        return strutsPackage2;
    }

    @Nullable
    public PsiClass searchActionClass() {
        GenericAttributeValue actionClassAttribute = this.getActionClass();
        if (DomUtil.hasXml((DomElement)actionClassAttribute)) {
            return (PsiClass)actionClassAttribute.getValue();
        }
        DefaultClassRef ref = this.getStrutsPackage().searchDefaultClassRef();
        if (ref != null) {
            return (PsiClass)ref.getDefaultClass().getValue();
        }
        return null;
    }

    @Nullable
    public PsiMethod searchActionMethod() {
        GenericAttributeValue methodValue = this.getMethod();
        if (DomUtil.hasXml((DomElement)methodValue)) {
            return (PsiMethod)methodValue.getValue();
        }
        return this.findActionMethod("execute");
    }

    @NotNull
    public String getNamespace() {
        String string = this.getStrutsPackage().searchNamespace();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/struts2/dom/struts/impl/ActionImpl", "getNamespace"));
        }
        return string;
    }

    @NotNull
    public List<PsiMethod> getActionMethods() {
        PsiClass actionClass = this.searchActionClass();
        if (actionClass == null) {
            List<PsiMethod> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/struts2/dom/struts/impl/ActionImpl", "getActionMethods"));
            }
            return list;
        }
        List<PsiMethod> list = ActionUtil.findActionMethods(actionClass, null);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/struts2/dom/struts/impl/ActionImpl", "getActionMethods"));
        }
        return list;
    }

    public PsiMethod findActionMethod(String methodName) {
        if (methodName == null) {
            return null;
        }
        PsiClass actionClass = this.searchActionClass();
        if (actionClass == null) {
            return null;
        }
        List<PsiMethod> actionMethods = ActionUtil.findActionMethods(actionClass, methodName);
        return actionMethods.size() == 1 ? actionMethods.get(0) : null;
    }

    @Nullable
    public PsiClass getParamsClass() {
        return this.searchActionClass();
    }
}

