/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.struts2.reference.jsp;

import com.intellij.openapi.util.Comparing;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceProvider;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlTag;
import com.intellij.struts2.dom.struts.action.Action;
import com.intellij.struts2.dom.struts.model.StrutsManager;
import com.intellij.struts2.dom.struts.model.StrutsModel;
import com.intellij.struts2.reference.TaglibUtil;
import com.intellij.struts2.reference.common.BeanPropertyPathReference;
import com.intellij.struts2.reference.common.BeanPropertyPathReferenceSet;
import com.intellij.util.ProcessingContext;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ActionPropertyReferenceProvider
extends PsiReferenceProvider {
    private final boolean supportsReadOnlyProperties;
    @NonNls
    private static final String[] TAGS_WITH_ACTION_ATTRIBUTE = new String[]{"a", "action", "form", "reset", "submit", "url"};

    public ActionPropertyReferenceProvider(boolean supportsReadOnlyProperties) {
        this.supportsReadOnlyProperties = supportsReadOnlyProperties;
    }

    @NotNull
    public PsiReference[] getReferencesByElement(@NotNull PsiElement psiElement, @NotNull ProcessingContext processingContext) {
        String actionName;
        if (psiElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiElement", "com/intellij/struts2/reference/jsp/ActionPropertyReferenceProvider", "getReferencesByElement"));
        }
        if (processingContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processingContext", "com/intellij/struts2/reference/jsp/ActionPropertyReferenceProvider", "getReferencesByElement"));
        }
        if (TaglibUtil.isDynamicExpression(((XmlAttributeValue)psiElement).getValue())) {
            if (PsiReference.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/struts2/reference/jsp/ActionPropertyReferenceProvider", "getReferencesByElement"));
            }
            return PsiReference.EMPTY_ARRAY;
        }
        XmlTag tag = (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)psiElement, XmlTag.class);
        assert (tag != null);
        XmlTag actionTag = ActionPropertyReferenceProvider.findEnclosingTag(tag, tag.getNamespacePrefix());
        if (actionTag == null) {
            if (PsiReference.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/struts2/reference/jsp/ActionPropertyReferenceProvider", "getReferencesByElement"));
            }
            return PsiReference.EMPTY_ARRAY;
        }
        String string = actionName = Comparing.equal((String)actionTag.getLocalName(), (String)"action") ? actionTag.getAttributeValue("name") : actionTag.getAttributeValue("action");
        if (actionName == null || TaglibUtil.isDynamicExpression(actionName)) {
            if (PsiReference.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/struts2/reference/jsp/ActionPropertyReferenceProvider", "getReferencesByElement"));
            }
            return PsiReference.EMPTY_ARRAY;
        }
        StrutsManager strutsManager = StrutsManager.getInstance(psiElement.getProject());
        StrutsModel strutsModel = strutsManager.getCombinedModel(psiElement);
        if (strutsModel == null) {
            if (PsiReference.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/struts2/reference/jsp/ActionPropertyReferenceProvider", "getReferencesByElement"));
            }
            return PsiReference.EMPTY_ARRAY;
        }
        List<Action> actions = strutsModel.findActionsByName(actionName, actionTag.getAttributeValue("namespace"));
        if (actions.size() != 1) {
            if (PsiReference.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/struts2/reference/jsp/ActionPropertyReferenceProvider", "getReferencesByElement"));
            }
            return PsiReference.EMPTY_ARRAY;
        }
        Action action = actions.get(0);
        BeanPropertyPathReference[] beanPropertyPathReferenceArray = new BeanPropertyPathReferenceSet(psiElement, action.searchActionClass(), this.supportsReadOnlyProperties){

            public boolean isSoft() {
                return false;
            }
        }.getPsiReferences();
        if (beanPropertyPathReferenceArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/struts2/reference/jsp/ActionPropertyReferenceProvider", "getReferencesByElement"));
        }
        return beanPropertyPathReferenceArray;
    }

    @Nullable
    private static XmlTag findEnclosingTag(@NotNull XmlTag xmlTag, @NotNull String namespacePrefix) {
        if (xmlTag == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "xmlTag", "com/intellij/struts2/reference/jsp/ActionPropertyReferenceProvider", "findEnclosingTag"));
        }
        if (namespacePrefix == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "namespacePrefix", "com/intellij/struts2/reference/jsp/ActionPropertyReferenceProvider", "findEnclosingTag"));
        }
        XmlTag tag = (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)xmlTag, XmlTag.class);
        if (tag == null) {
            return null;
        }
        if (tag.getNamespacePrefix().equals(namespacePrefix) && Arrays.binarySearch(TAGS_WITH_ACTION_ATTRIBUTE, tag.getLocalName()) > -1) {
            return tag;
        }
        return ActionPropertyReferenceProvider.findEnclosingTag(tag, namespacePrefix);
    }
}

