/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.model.highlighting.dom;

import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlFile;
import com.intellij.spring.SpringManager;
import com.intellij.spring.contexts.model.SpringModel;
import com.intellij.spring.contexts.model.XmlSpringModel;
import com.intellij.spring.model.CommonSpringBean;
import com.intellij.spring.model.SpringModelVisitor;
import com.intellij.spring.model.xml.beans.Beans;
import com.intellij.spring.model.xml.beans.SpringBean;
import com.intellij.util.xml.DomFileElement;
import com.intellij.util.xml.highlighting.DomElementAnnotationHolder;
import com.intellij.util.xml.highlighting.DomElementsInspection;

public abstract class SpringBeanInspectionBase
extends DomElementsInspection<Beans> {
    public SpringBeanInspectionBase() {
        super(Beans.class, new Class[0]);
    }

    public void checkFileElement(DomFileElement<Beans> domFileElement, DomElementAnnotationHolder holder) {
        XmlFile xmlFile = domFileElement.getFile();
        Beans beans = (Beans)domFileElement.getRootElement();
        SpringModel model = SpringManager.getInstance(xmlFile.getProject()).getSpringModelByFile((PsiFile)xmlFile);
        if (model instanceof XmlSpringModel) {
            SpringModelVisitor visitor = this.createVisitor(holder, beans, (XmlSpringModel)model);
            SpringModelVisitor.visitBeans(visitor, beans);
        }
    }

    protected SpringModelVisitor createVisitor(final DomElementAnnotationHolder holder, final Beans beans, final XmlSpringModel model) {
        return new SpringModelVisitor(){

            @Override
            protected boolean visitBean(CommonSpringBean bean) {
                if (bean instanceof SpringBean) {
                    SpringBeanInspectionBase.this.checkBean((SpringBean)bean, beans, holder, model);
                }
                return true;
            }
        };
    }

    protected void checkBean(SpringBean springBean, Beans beans, DomElementAnnotationHolder holder, XmlSpringModel springModel) {
    }
}

