/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.model.jam.converters;

import com.intellij.jam.JamConverter;
import com.intellij.jam.JamStringAttributeElement;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.ElementManipulators;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiLiteral;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiReference;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.PatternPackageReferenceSet;
import com.intellij.spring.model.utils.SpringReferenceUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PackageJamConverter
extends JamConverter<PsiPackage> {
    public PsiPackage fromString(@Nullable String s, JamStringAttributeElement<PsiPackage> context) {
        if (StringUtil.isEmptyOrSpaces((String)s)) {
            return null;
        }
        return JavaPsiFacade.getInstance((Project)context.getPsiManager().getProject()).findPackage(s.trim());
    }

    @NotNull
    public PsiReference[] createReferences(JamStringAttributeElement<PsiPackage> context) {
        PsiLiteral psiLiteral = context.getPsiLiteral();
        if (psiLiteral == null) {
            if (PsiReference.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/jam/converters/PackageJamConverter", "createReferences"));
            }
            return PsiReference.EMPTY_ARRAY;
        }
        String value = context.getStringValue();
        if (value == null) {
            if (PsiReference.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/jam/converters/PackageJamConverter", "createReferences"));
            }
            return PsiReference.EMPTY_ARRAY;
        }
        PatternPackageReferenceSet set = new PatternPackageReferenceSet(value, (PsiElement)psiLiteral, ElementManipulators.getOffsetInElement((PsiElement)psiLiteral), SpringReferenceUtils.getResolveScope((PsiElement)psiLiteral));
        PsiReference[] psiReferenceArray = set.getPsiReferences();
        if (psiReferenceArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/jam/converters/PackageJamConverter", "createReferences"));
        }
        return psiReferenceArray;
    }
}

