/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.model.jam.testContexts.converters;

import com.intellij.jam.JamSimpleReferenceConverter;
import com.intellij.jam.JamStringAttributeElement;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.psi.ElementManipulators;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiLiteral;
import com.intellij.psi.PsiReference;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReference;
import com.intellij.spring.model.utils.resources.SpringResourcesBuilder;
import com.intellij.spring.model.utils.resources.SpringResourcesUtil;
import com.intellij.util.Function;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ResourcePathReferenceConverter<T>
extends JamSimpleReferenceConverter<List<T>> {
    public List<T> fromString(@Nullable String s, JamStringAttributeElement<List<T>> context) {
        return s == null ? null : this.getFiles(this.getReferences(s, context));
    }

    public List<T> getFiles(PsiReference[] references) {
        for (PsiReference reference : references) {
            FileReference lastFileReference;
            FileReference fileReference = FileReference.findFileReference((PsiReference)reference);
            if (fileReference == null || (lastFileReference = fileReference.getLastFileReference()) == null) continue;
            Object[] resolve = lastFileReference.multiResolve(false);
            return ContainerUtil.mapNotNull((Object[])resolve, this.getMapper());
        }
        return Collections.emptyList();
    }

    protected abstract Function<ResolveResult, T> getMapper();

    @NotNull
    public PsiReference[] createReferences(JamStringAttributeElement<List<T>> context) {
        PsiReference[] psiReferenceArray = this.getReferences(context);
        if (psiReferenceArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/jam/testContexts/converters/ResourcePathReferenceConverter", "createReferences"));
        }
        return psiReferenceArray;
    }

    protected PsiReference[] getReferences(@NotNull String s, JamStringAttributeElement<List<T>> context) {
        if (s == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "s", "com/intellij/spring/model/jam/testContexts/converters/ResourcePathReferenceConverter", "getReferences"));
        }
        PsiLiteral psiLiteral = context.getPsiLiteral();
        if (psiLiteral == null) {
            return ResourcePathReferenceConverter.getReferencesOnFakeElement((PsiElement)context.getPsiElement(), s, new Module[0]);
        }
        return ResourcePathReferenceConverter.getReferences(psiLiteral, s, new Module[0]);
    }

    private static PsiReference[] getReferences(PsiLiteral psiLiteral, String s, Module ... modules) {
        SpringResourcesBuilder resourcesBuilder = SpringResourcesBuilder.create((PsiElement)psiLiteral, s).fromRoot(s.startsWith("/")).soft(false).modules(modules);
        return SpringResourcesUtil.getInstance().getReferences(resourcesBuilder);
    }

    @NotNull
    protected static PsiReference[] getReferencesOnFakeElement(@Nullable PsiElement element, @NotNull String s, Module ... modules) {
        block7: {
            PsiReference[] psiReferenceArray;
            if (s == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "s", "com/intellij/spring/model/jam/testContexts/converters/ResourcePathReferenceConverter", "getReferencesOnFakeElement"));
            }
            if (element == null) {
                if (PsiReference.EMPTY_ARRAY == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/jam/testContexts/converters/ResourcePathReferenceConverter", "getReferencesOnFakeElement"));
                }
                return PsiReference.EMPTY_ARRAY;
            }
            try {
                PsiExpression psiExpression = JavaPsiFacade.getElementFactory((Project)element.getProject()).createExpressionFromText("\"" + s + "\"", element);
                if (!(psiExpression instanceof PsiLiteral)) break block7;
                psiReferenceArray = ResourcePathReferenceConverter.getReferences((PsiLiteral)psiExpression, s, modules);
            }
            catch (IncorrectOperationException incorrectOperationException) {
                // empty catch block
            }
            if (psiReferenceArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/jam/testContexts/converters/ResourcePathReferenceConverter", "getReferencesOnFakeElement"));
            }
            return psiReferenceArray;
        }
        if (PsiReference.EMPTY_ARRAY == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/jam/testContexts/converters/ResourcePathReferenceConverter", "getReferencesOnFakeElement"));
        }
        return PsiReference.EMPTY_ARRAY;
    }

    private PsiReference[] getReferences(JamStringAttributeElement<List<T>> jamAttribute) {
        PsiLiteral psiLiteral = jamAttribute.getPsiLiteral();
        if (psiLiteral == null) {
            return PsiReference.EMPTY_ARRAY;
        }
        String s = ElementManipulators.getValueText((PsiElement)psiLiteral);
        return ResourcePathReferenceConverter.getReferences(psiLiteral, s, new Module[0]);
    }
}

