/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.model.jam.testContexts.propertySources;

import com.intellij.jam.JamConverter;
import com.intellij.jam.JamService;
import com.intellij.jam.JamStringAttributeElement;
import com.intellij.jam.reflect.JamAnnotationMeta;
import com.intellij.jam.reflect.JamAttributeMeta;
import com.intellij.jam.reflect.JamMemberMeta;
import com.intellij.jam.reflect.JamStringAttributeMeta;
import com.intellij.lang.properties.psi.PropertiesFile;
import com.intellij.openapi.util.NullableLazyValue;
import com.intellij.psi.PsiAnchor;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementRef;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.ref.AnnotationChildLink;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.semantic.SemKey;
import com.intellij.spring.model.aliasFor.SpringAliasFor;
import com.intellij.spring.model.aliasFor.SpringAliasForUtils;
import com.intellij.spring.model.jam.converters.PropertiesFileConverter;
import com.intellij.spring.model.jam.stereotype.SpringPropertySource;
import com.intellij.spring.model.jam.testContexts.propertySources.SpringTestPropertySource;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CustomTestPropertySource
implements SpringPropertySource {
    public static final SemKey<JamAnnotationMeta> JAM_ANNO_META_KEY = JamService.ANNO_META_KEY.subKey("CustomTestPropertySource", new SemKey[0]);
    public static final SemKey<CustomTestPropertySource> JAM_KEY = SpringPropertySource.PROPERTY_SOURCE_JAM_KEY.subKey("CustomTestPropertySource", new SemKey[0]);
    public static final SemKey<JamMemberMeta<PsiClass, CustomTestPropertySource>> META_KEY = PROPERTY_SOURCE_META_KEY.subKey("CustomTestPropertySource", new SemKey[0]);
    String[] LOCATIONS_FILES_ATTRS;
    protected final PsiElementRef<PsiAnnotation> myPsiAnnotation;
    private final AnnotationChildLink myAnnotationChildLink;
    private final PsiAnchor myPsiClassAnchor;
    private final NullableLazyValue<SpringTestPropertySource> myDefiningMetaAnnotation;

    public CustomTestPropertySource(@NotNull String anno, @NotNull PsiClass psiClassAnchor) {
        if (anno == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "anno", "com/intellij/spring/model/jam/testContexts/propertySources/CustomTestPropertySource", "<init>"));
        }
        if (psiClassAnchor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiClassAnchor", "com/intellij/spring/model/jam/testContexts/propertySources/CustomTestPropertySource", "<init>"));
        }
        this.LOCATIONS_FILES_ATTRS = new String[]{"locations", "value"};
        this.myDefiningMetaAnnotation = new NullableLazyValue<SpringTestPropertySource>(){

            @Nullable
            protected SpringTestPropertySource compute() {
                PsiClass annotationType;
                PsiAnnotation definingMetaAnnotation = SpringAliasForUtils.findDefiningMetaAnnotation((PsiElement)CustomTestPropertySource.this.getPsiElement(), CustomTestPropertySource.this.myAnnotationChildLink.getAnnotationQualifiedName(), SpringTestPropertySource.ANNO_META.getAnnoName());
                if (definingMetaAnnotation != null && (annotationType = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)definingMetaAnnotation, PsiClass.class, (boolean)true)) != null) {
                    return (SpringTestPropertySource)SpringTestPropertySource.META.getJamElement((PsiModifierListOwner)annotationType);
                }
                return null;
            }
        };
        this.myAnnotationChildLink = new AnnotationChildLink(anno);
        this.myPsiClassAnchor = PsiAnchor.create((PsiElement)psiClassAnchor);
        this.myPsiAnnotation = this.myAnnotationChildLink.createChildRef((PsiElement)this.getPsiElement());
    }

    @Override
    public PsiClass getPsiElement() {
        return (PsiClass)this.myPsiClassAnchor.retrieve();
    }

    @Override
    @Nullable
    public PsiAnnotation getAnnotation() {
        return (PsiAnnotation)this.myPsiAnnotation.getPsiElement();
    }

    @Override
    public Set<PropertiesFile> getPropertiesFiles() {
        LinkedHashSet files = ContainerUtil.newLinkedHashSet();
        PropertiesFileConverter referenceConverter = new PropertiesFileConverter();
        for (String attrName : this.LOCATIONS_FILES_ATTRS) {
            SpringAliasFor aliasFor = this.getAliasAttribute(attrName);
            if (aliasFor == null) continue;
            JamStringAttributeMeta.Collection element = JamAttributeMeta.collectionString((String)aliasFor.getMethodName(), (JamConverter)referenceConverter);
            for (JamStringAttributeElement attributeElement : element.getJam(this.myPsiAnnotation)) {
                Set values = (Set)attributeElement.getValue();
                if (values == null) continue;
                files.addAll(values);
            }
            return files;
        }
        SpringTestPropertySource testPropertySource = this.getDefiningTestPropertySource();
        if (testPropertySource != null) {
            return testPropertySource.getPropertiesFiles();
        }
        return Collections.emptySet();
    }

    private SpringTestPropertySource getDefiningTestPropertySource() {
        return (SpringTestPropertySource)this.myDefiningMetaAnnotation.getValue();
    }

    private SpringAliasFor getAliasAttribute(@NotNull String attrName) {
        if (attrName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "attrName", "com/intellij/spring/model/jam/testContexts/propertySources/CustomTestPropertySource", "getAliasAttribute"));
        }
        return SpringAliasForUtils.findAliasFor((PsiElement)this.getPsiElement(), this.myAnnotationChildLink.getAnnotationQualifiedName(), SpringTestPropertySource.ANNO_META.getAnnoName(), attrName);
    }

    @Override
    public boolean isPsiValid() {
        return this.getPsiElement().isValid();
    }
}

