/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.gwt.clientBundle;

import com.intellij.gwt.clientBundle.jam.ClientBundleMethodJamElement;
import com.intellij.gwt.uiBinder.UiBinderUtil;
import com.intellij.gwt.uiBinder.declarations.UiStyleElement;
import com.intellij.gwt.uiBinder.declarations.UiXmlDeclarationsManager;
import com.intellij.gwt.uiBinder.declarations.UiXmlVariableDeclaration;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiType;
import com.intellij.psi.css.StylesheetFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.AnnotatedElementsSearch;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.xml.XmlFile;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ClientBundleUtil {
    @NonNls
    public static final String DEFAULT_EXTENSIONS_ANNOTATION = "com.google.gwt.resources.ext.DefaultExtensions";
    @NonNls
    public static final String CLIENT_BUNDLE_INTERFACE = "com.google.gwt.resources.client.ClientBundle";
    @NonNls
    public static final String SOURCE_ANNOTATION = "com.google.gwt.resources.client.ClientBundle.Source";
    @NonNls
    public static final String CSS_RESOURCE_INTERFACE = "com.google.gwt.resources.client.CssResource";
    @NonNls
    public static final String IMAGE_RESOURCE_INTERFACE = "com.google.gwt.resources.client.ImageResource";
    @NonNls
    public static final String CLASS_NAME_ANNOTATION = "com.google.gwt.resources.client.CssResource.ClassName";

    private ClientBundleUtil() {
    }

    public static Set<PsiClass> getCssInterfaces(@NotNull StylesheetFile stylesheetFile) {
        if (stylesheetFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stylesheetFile", "com/intellij/gwt/clientBundle/ClientBundleUtil", "getCssInterfaces"));
        }
        PsiClass sourceAnnotation = ClientBundleUtil.findSourceAnnotation((PsiElement)stylesheetFile);
        if (sourceAnnotation == null) {
            return Collections.emptySet();
        }
        HashSet<PsiClass> result = new HashSet<PsiClass>();
        AnnotatedElementsSearch.searchPsiMethods((PsiClass)sourceAnnotation, (SearchScope)stylesheetFile.getUseScope()).forEach(psiMethod -> {
            if (stylesheetFile == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stylesheetFile", "com/intellij/gwt/clientBundle/ClientBundleUtil", "lambda$getCssInterfaces$0"));
            }
            ClientBundleMethodJamElement element = ClientBundleMethodJamElement.getElement(psiMethod);
            if (element != null) {
                PsiType returnType = psiMethod.getReturnType();
                if (element.getSourceFiles(true).contains(stylesheetFile) && returnType instanceof PsiClassType) {
                    ContainerUtil.addIfNotNull((Collection)result, (Object)((PsiClassType)returnType).resolve());
                }
            }
            return true;
        });
        return result;
    }

    public static Set<StylesheetFile> getStylesheetFiles(@NotNull PsiClass cssResourceClass, boolean addLocalized, boolean processSubClasses) {
        if (cssResourceClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "cssResourceClass", "com/intellij/gwt/clientBundle/ClientBundleUtil", "getStylesheetFiles"));
        }
        HashSet<StylesheetFile> result = new HashSet<StylesheetFile>();
        SearchScope scope = cssResourceClass.getUseScope();
        if (!(scope instanceof GlobalSearchScope)) {
            scope = GlobalSearchScope.fileScope((PsiFile)cssResourceClass.getContainingFile());
        }
        ReferencesSearch.search((PsiElement)cssResourceClass, (SearchScope)scope.intersectWith((SearchScope)UiBinderUtil.UI_XML_FILES_SCOPE)).forEach(reference -> {
            if (cssResourceClass == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "cssResourceClass", "com/intellij/gwt/clientBundle/ClientBundleUtil", "lambda$getStylesheetFiles$1"));
            }
            PsiFile file = reference.getElement().getContainingFile();
            for (UiXmlVariableDeclaration element : UiXmlDeclarationsManager.getDeclarations((XmlFile)file)) {
                UiStyleElement styleElement;
                String type;
                if (!(element instanceof UiStyleElement) || (type = (styleElement = (UiStyleElement)element).getType()) == null || !type.equals(cssResourceClass.getQualifiedName())) continue;
                result.addAll(styleElement.getStylesheetFiles());
            }
        });
        PsiClass sourceAnnotation = ClientBundleUtil.findSourceAnnotation((PsiElement)cssResourceClass);
        if (sourceAnnotation == null) {
            return result;
        }
        AnnotatedElementsSearch.searchPsiMethods((PsiClass)sourceAnnotation, (SearchScope)scope).forEach(psiMethod -> {
            PsiClass psiClass;
            PsiType type;
            if (cssResourceClass == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "cssResourceClass", "com/intellij/gwt/clientBundle/ClientBundleUtil", "lambda$getStylesheetFiles$2"));
            }
            ClientBundleMethodJamElement element = ClientBundleMethodJamElement.getElement(psiMethod);
            if (element != null && (type = psiMethod.getReturnType()) instanceof PsiClassType && (psiClass = ((PsiClassType)type).resolve()) != null && (psiClass.getManager().areElementsEquivalent((PsiElement)psiClass, (PsiElement)cssResourceClass) || processSubClasses && psiClass.isInheritor(cssResourceClass, true))) {
                for (PsiFile psiFile : element.getSourceFiles(addLocalized)) {
                    if (!(psiFile instanceof StylesheetFile)) continue;
                    result.add((StylesheetFile)psiFile);
                }
            }
            return true;
        });
        return result;
    }

    @Nullable
    private static PsiClass findSourceAnnotation(@NotNull PsiElement context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/gwt/clientBundle/ClientBundleUtil", "findSourceAnnotation"));
        }
        return JavaPsiFacade.getInstance((Project)context.getProject()).findClass(SOURCE_ANNOTATION, context.getResolveScope());
    }

    public static boolean isImplementationProvidedByGwt(@NotNull PsiClass psiClass) {
        if (psiClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiClass", "com/intellij/gwt/clientBundle/ClientBundleUtil", "isImplementationProvidedByGwt"));
        }
        if (!psiClass.isInterface()) {
            return false;
        }
        return InheritanceUtil.isInheritor((PsiClass)psiClass, (String)"com.google.gwt.resources.client.ResourcePrototype") || InheritanceUtil.isInheritor((PsiClass)psiClass, (String)"com.google.gwt.i18n.shared.Localizable");
    }
}

