/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.gwt.i18n;

import com.intellij.gwt.codeInsight.GwtMethodGenerationUtil;
import com.intellij.gwt.sdk.GwtVersion;
import com.intellij.jam.model.util.JamCommonUtil;
import com.intellij.lang.properties.IProperty;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNameHelper;
import com.intellij.psi.PsiNameValuePair;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiType;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.javadoc.PsiDocComment;
import com.intellij.psi.javadoc.PsiDocTag;
import com.intellij.psi.javadoc.PsiDocTagValue;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.IncorrectOperationException;
import java.text.MessageFormat;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GwtI18nUtil {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.gwt.i18n.GwtI18nUtil");
    @NonNls
    public static final String CONSTANTS_INTERFACE_NAME = "com.google.gwt.i18n.client.Constants";
    @NonNls
    public static final String MESSAGES_INTERFACE_NAME = "com.google.gwt.i18n.client.Messages";
    @NonNls
    public static final String LOCALIZABLE_INTERFACE_NAME = "com.google.gwt.i18n.client.LocalizableResource";
    @NonNls
    private static final String GWT_PROPERTY_KEY_JAVADOC = "/**\n*@gwt.key {0}\n*/";
    @NonNls
    public static final String KEY_ANNOTATION_CLASS = "com.google.gwt.i18n.client.LocalizableResource.Key";
    @NonNls
    public static final String GWT_KEY_TAG = "gwt.key";

    private GwtI18nUtil() {
    }

    public static void navigateToProperty(@NotNull IProperty property) {
        if (property == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "property", "com/intellij/gwt/i18n/GwtI18nUtil", "navigateToProperty"));
        }
        property.navigate(true);
    }

    public static String suggestPropertyKey(@NotNull String value, PsiNameHelper nameHelper, LanguageLevel languageLevel) {
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/gwt/i18n/GwtI18nUtil", "suggestPropertyKey"));
        }
        List words = StringUtil.getWordsIn((String)value);
        StringBuilder key = new StringBuilder();
        for (String word : words) {
            word = key.length() > 0 ? StringUtil.capitalize((String)word) : StringUtil.decapitalize((String)word);
            key.append(word);
        }
        return GwtMethodGenerationUtil.addPrefixIfNeeded(key.toString(), "property", nameHelper, languageLevel);
    }

    public static String convertPropertyName2MethodName(String propertyName, PsiNameHelper nameHelper, LanguageLevel languageLevel) {
        return GwtMethodGenerationUtil.convertStringToMethodName(propertyName, nameHelper, languageLevel, "getProperty");
    }

    public static void addMethod(PsiClass aClass, String propertyName, @Nullable String propertyValue, GwtVersion gwtVersion) {
        try {
            PsiMethod method = GwtI18nUtil.addMethod(aClass, propertyName, gwtVersion);
            PsiElementFactory psiElementFactory = JavaPsiFacade.getInstance((Project)method.getProject()).getElementFactory();
            int parametersCount = GwtI18nUtil.getParametersCount(propertyValue);
            PsiClassType javaLangString = PsiType.getJavaLangString((PsiManager)method.getManager(), (GlobalSearchScope)GlobalSearchScope.allScope((Project)method.getProject()));
            for (int i = 0; i < parametersCount; ++i) {
                PsiParameter psiParameter = psiElementFactory.createParameter("p" + i, (PsiType)javaLangString);
                if (aClass.isInterface()) {
                    PsiUtil.setModifierProperty((PsiModifierListOwner)psiParameter, (String)"final", (boolean)false);
                }
                method.getParameterList().add((PsiElement)psiParameter);
            }
            CodeStyleManager.getInstance((Project)aClass.getProject()).reformat((PsiElement)method);
        }
        catch (IncorrectOperationException e) {
            LOG.error((Throwable)e);
        }
    }

    public static int getParametersCount(@Nullable String propertyValue) {
        int end;
        if (propertyValue == null) {
            return 0;
        }
        int maxParameter = -1;
        int i = propertyValue.indexOf(123);
        while (i != -1 && (end = propertyValue.indexOf(125, i)) != -1) {
            int comma = propertyValue.indexOf(44, i);
            if (comma != -1 && comma < end) {
                end = comma;
            }
            try {
                int parameter = Integer.parseInt(propertyValue.substring(i + 1, end));
                maxParameter = Math.max(maxParameter, parameter);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            i = propertyValue.indexOf(123, end);
        }
        return maxParameter + 1;
    }

    public static PsiMethod addMethod(PsiClass aClass, String propertyName, GwtVersion gwtVersion) throws IncorrectOperationException {
        String methodName = GwtI18nUtil.convertPropertyName2MethodName(propertyName, PsiNameHelper.getInstance((Project)aClass.getProject()), PsiUtil.getLanguageLevel((PsiElement)aClass));
        PsiMethod addedMethod = GwtMethodGenerationUtil.addStringMethod(aClass, methodName);
        if (!propertyName.equals(methodName)) {
            GwtI18nUtil.addKeyAnnotationOrJavaDoc(addedMethod, propertyName, gwtVersion, JavaPsiFacade.getInstance((Project)aClass.getProject()).getElementFactory());
        }
        return addedMethod;
    }

    public static void addKeyAnnotationOrJavaDoc(@NotNull PsiMethod method, @NotNull String propertyName, @NotNull GwtVersion gwtVersion, @NotNull PsiElementFactory elementFactory) {
        if (method == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/intellij/gwt/i18n/GwtI18nUtil", "addKeyAnnotationOrJavaDoc"));
        }
        if (propertyName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "propertyName", "com/intellij/gwt/i18n/GwtI18nUtil", "addKeyAnnotationOrJavaDoc"));
        }
        if (gwtVersion == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "gwtVersion", "com/intellij/gwt/i18n/GwtI18nUtil", "addKeyAnnotationOrJavaDoc"));
        }
        if (elementFactory == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elementFactory", "com/intellij/gwt/i18n/GwtI18nUtil", "addKeyAnnotationOrJavaDoc"));
        }
        if (gwtVersion.isGenericsSupported()) {
            GwtI18nUtil.addKeyAnnotation(propertyName, method, elementFactory);
        } else {
            String commentText = MessageFormat.format(GWT_PROPERTY_KEY_JAVADOC, propertyName);
            PsiComment comment = elementFactory.createCommentFromText(commentText, (PsiElement)method.getContainingClass());
            method.addBefore((PsiElement)comment, method.getFirstChild());
        }
    }

    public static void addKeyAnnotation(String propertyName, PsiMethod method, PsiElementFactory elementFactory) throws IncorrectOperationException {
        String annotationText = "@com.google.gwt.i18n.client.LocalizableResource.Key(\"" + propertyName + "\")";
        PsiAnnotation annotation = elementFactory.createAnnotationFromText(annotationText, (PsiElement)method);
        method.getModifierList().add((PsiElement)annotation);
    }

    public static String getPropertyName(PsiMethod method) {
        String text;
        PsiDocTagValue psiDocTagValue;
        PsiDocTag tag;
        String key;
        PsiNameValuePair[] attributes;
        PsiAnnotation annotation = method.getModifierList().findAnnotation(KEY_ANNOTATION_CLASS);
        if (annotation != null && (attributes = annotation.getParameterList().getAttributes()).length == 1 && (key = (String)JamCommonUtil.getObjectValue((PsiAnnotationMemberValue)attributes[0].getValue(), String.class)) != null) {
            return key;
        }
        PsiDocComment docComment = method.getDocComment();
        if (docComment != null && (tag = docComment.findTagByName(GWT_KEY_TAG)) != null && (psiDocTagValue = tag.getValueElement()) != null && (text = psiDocTagValue.getText()) != null) {
            return text;
        }
        return method.getName();
    }
}

