/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.gwt.inspections;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.gwt.GwtBundle;
import com.intellij.gwt.i18n.GwtI18nManager;
import com.intellij.gwt.i18n.GwtI18nUtil;
import com.intellij.gwt.inspections.BaseGwtInspection;
import com.intellij.gwt.inspections.BaseGwtLocalQuickFix;
import com.intellij.lang.properties.IProperty;
import com.intellij.lang.properties.psi.PropertiesFile;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiReferenceList;
import com.intellij.util.IncorrectOperationException;
import java.util.ArrayList;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GwtMethodWithParametersInConstantsInterfaceInspection
extends BaseGwtInspection {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.gwt.inspections.GwtMethodWithParametersInConstantsInterfaceInspection");

    @Nls
    @NotNull
    public String getDisplayName() {
        String string = GwtBundle.message("inspection.name.method.with.parameters.in.interface.extending.constants", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/gwt/inspections/GwtMethodWithParametersInConstantsInterfaceInspection", "getDisplayName"));
        }
        return string;
    }

    @NonNls
    @NotNull
    public String getShortName() {
        if ("GwtMethodWithParametersInConstantsInterface" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/gwt/inspections/GwtMethodWithParametersInConstantsInterfaceInspection", "getShortName"));
        }
        return "GwtMethodWithParametersInConstantsInterface";
    }

    @Nullable
    public ProblemDescriptor[] checkClass(@NotNull PsiClass aClass, @NotNull InspectionManager manager, boolean isOnTheFly) {
        if (aClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/intellij/gwt/inspections/GwtMethodWithParametersInConstantsInterfaceInspection", "checkClass"));
        }
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "com/intellij/gwt/inspections/GwtMethodWithParametersInConstantsInterfaceInspection", "checkClass"));
        }
        if (!GwtMethodWithParametersInConstantsInterfaceInspection.shouldCheck((PsiElement)aClass)) {
            return null;
        }
        GwtI18nManager i18nManager = GwtI18nManager.getInstance(manager.getProject());
        PropertiesFile[] files = i18nManager.getPropertiesFiles(aClass);
        if (files.length == 0 || !i18nManager.isConstantsInterface(aClass)) {
            return null;
        }
        PsiJavaCodeReferenceElement extendsConstantsElement = GwtMethodWithParametersInConstantsInterfaceInspection.findExtendsConstantsElement(aClass);
        ArrayList<ProblemDescriptor> problems = new ArrayList<ProblemDescriptor>();
        for (PsiMethod psiMethod : aClass.getMethods()) {
            if (psiMethod.getParameterList().getParametersCount() <= 0) continue;
            ReplaceConstantsByMessagesInExtendsListQuickFix quickFix = null;
            if (extendsConstantsElement != null) {
                quickFix = new ReplaceConstantsByMessagesInExtendsListQuickFix(aClass, extendsConstantsElement);
            }
            problems.add(manager.createProblemDescriptor(GwtMethodWithParametersInConstantsInterfaceInspection.getElementToHighlight(psiMethod), GwtBundle.message("problem.description.methods.with.parameters.are.not.allowed.in.an.interface.extending.constants", new Object[0]), (LocalQuickFix)quickFix, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, isOnTheFly));
        }
        return problems.toArray(new ProblemDescriptor[problems.size()]);
    }

    public ProblemDescriptor[] checkFile(@NotNull PsiFile file, @NotNull InspectionManager manager, boolean isOnTheFly) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/gwt/inspections/GwtMethodWithParametersInConstantsInterfaceInspection", "checkFile"));
        }
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "com/intellij/gwt/inspections/GwtMethodWithParametersInConstantsInterfaceInspection", "checkFile"));
        }
        if (!GwtMethodWithParametersInConstantsInterfaceInspection.shouldCheck((PsiElement)file) || !(file instanceof PropertiesFile)) {
            return null;
        }
        PropertiesFile propertiesFile = (PropertiesFile)file;
        GwtI18nManager i18nManager = GwtI18nManager.getInstance(manager.getProject());
        PsiClass propertiesInterface = i18nManager.getPropertiesInterface(propertiesFile);
        if (propertiesInterface == null || !i18nManager.isConstantsInterface(propertiesInterface)) {
            return null;
        }
        ArrayList<ProblemDescriptor> problems = new ArrayList<ProblemDescriptor>();
        PsiJavaCodeReferenceElement extendsConstantsElement = GwtMethodWithParametersInConstantsInterfaceInspection.findExtendsConstantsElement(propertiesInterface);
        for (IProperty property : propertiesFile.getProperties()) {
            if (GwtI18nUtil.getParametersCount(property.getValue()) <= 0) continue;
            ReplaceConstantsByMessagesInExtendsListQuickFix quickFix = null;
            if (extendsConstantsElement != null) {
                quickFix = new ReplaceConstantsByMessagesInExtendsListQuickFix(propertiesInterface, extendsConstantsElement);
            }
            String message = GwtBundle.message("problem.description.properties.with.parameters.are.not.allowed.if.the.associated.interface.extends.constants", new Object[0]);
            problems.add(manager.createProblemDescriptor(property.getPsiElement(), message, (LocalQuickFix)quickFix, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, isOnTheFly));
        }
        return problems.toArray(new ProblemDescriptor[problems.size()]);
    }

    @Nullable
    private static PsiJavaCodeReferenceElement findExtendsConstantsElement(PsiClass aClass) {
        PsiJavaCodeReferenceElement extendsConstantsElement = null;
        PsiReferenceList list = aClass.getExtendsList();
        if (list != null) {
            for (PsiJavaCodeReferenceElement element : list.getReferenceElements()) {
                PsiElement anInterface = element.resolve();
                if (!(anInterface instanceof PsiClass) || !"com.google.gwt.i18n.client.Constants".equals(((PsiClass)anInterface).getQualifiedName())) continue;
                extendsConstantsElement = element;
                break;
            }
        }
        return extendsConstantsElement;
    }

    private static class ReplaceConstantsByMessagesInExtendsListQuickFix
    extends BaseGwtLocalQuickFix {
        private static final String FAMILY_NAME = GwtBundle.message("quickfix.family.name.inherit.from.messages.instead.of.constants", new Object[0]);
        private final PsiClass myInterface;
        private final PsiJavaCodeReferenceElement myExtendsConstantsElement;

        private ReplaceConstantsByMessagesInExtendsListQuickFix(PsiClass anInterface, PsiJavaCodeReferenceElement extendsConstantsElement) {
            super(GwtBundle.message("quickfix.name.inherit.0.from.messages.instead.of.constants", anInterface.getName()));
            this.myInterface = anInterface;
            this.myExtendsConstantsElement = extendsConstantsElement;
        }

        @Override
        @Nls
        @NotNull
        public String getFamilyName() {
            String string = FAMILY_NAME;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/gwt/inspections/GwtMethodWithParametersInConstantsInterfaceInspection$ReplaceConstantsByMessagesInExtendsListQuickFix", "getFamilyName"));
            }
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/gwt/inspections/GwtMethodWithParametersInConstantsInterfaceInspection$ReplaceConstantsByMessagesInExtendsListQuickFix", "applyFix"));
            }
            if (descriptor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/gwt/inspections/GwtMethodWithParametersInConstantsInterfaceInspection$ReplaceConstantsByMessagesInExtendsListQuickFix", "applyFix"));
            }
            if (!FileModificationService.getInstance().preparePsiElementForWrite((PsiElement)this.myInterface.getContainingFile())) {
                return;
            }
            try {
                this.myExtendsConstantsElement.delete();
                PsiElementFactory factory = JavaPsiFacade.getInstance((Project)this.myInterface.getProject()).getElementFactory();
                PsiClassType messagesType = factory.createTypeByFQClassName("com.google.gwt.i18n.client.Messages", this.myInterface.getResolveScope());
                PsiReferenceList extendsList = this.myInterface.getExtendsList();
                LOG.assertTrue(extendsList != null);
                extendsList.add((PsiElement)factory.createReferenceElementByType(messagesType));
            }
            catch (IncorrectOperationException e) {
                LOG.error((Throwable)e);
            }
        }
    }
}

