/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.gwt.references.search;

import com.intellij.gwt.facet.GwtFacet;
import com.intellij.lang.StdLanguages;
import com.intellij.openapi.application.QueryExecutorBase;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.Processor;
import org.jetbrains.annotations.NotNull;

public class GwtToHtmlTagIdReferencesSearcher
extends QueryExecutorBase<PsiReference, ReferencesSearch.SearchParameters> {
    public GwtToHtmlTagIdReferencesSearcher() {
        super(true);
    }

    public void processQuery(@NotNull ReferencesSearch.SearchParameters queryParameters, @NotNull Processor<PsiReference> consumer) {
        if (queryParameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "queryParameters", "com/intellij/gwt/references/search/GwtToHtmlTagIdReferencesSearcher", "processQuery"));
        }
        if (consumer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "com/intellij/gwt/references/search/GwtToHtmlTagIdReferencesSearcher", "processQuery"));
        }
        PsiElement element = queryParameters.getElementToSearch();
        if (!(element instanceof XmlAttributeValue)) {
            return;
        }
        PsiElement parent = element.getParent();
        if (!(parent instanceof XmlAttribute) || !"id".equals(((XmlAttribute)parent).getLocalName())) {
            return;
        }
        String id = ((XmlAttributeValue)element).getValue();
        if (StringUtil.isEmpty((String)id)) {
            return;
        }
        PsiElement tag = parent.getParent();
        if (!(tag instanceof XmlTag)) {
            return;
        }
        PsiFile file = parent.getContainingFile();
        if (!file.getLanguage().equals(StdLanguages.HTML) && !file.getLanguage().equals(StdLanguages.XHTML)) {
            return;
        }
        VirtualFile virtualFile = file.getVirtualFile();
        if (virtualFile == null) {
            return;
        }
        Module module = ModuleUtil.findModuleForPsiElement((PsiElement)file);
        if (module == null || GwtFacet.getInstance(module) == null) {
            return;
        }
        queryParameters.getOptimizer().searchWord(id, queryParameters.getEffectiveSearchScope(), (short)4, true, tag);
    }
}

