/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.gwt.uiBinder;

import com.intellij.codeInsight.intention.AbstractIntentionAction;
import com.intellij.gwt.facet.GwtFacet;
import com.intellij.gwt.uiBinder.UiBinderUtil;
import com.intellij.gwt.uiBinder.mapping.UiBinderMappingService;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNameHelper;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlFile;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.util.IncorrectOperationException;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class GwtUiXmlUiFieldIntentionBase
extends AbstractIntentionAction {
    public void invoke(@NotNull Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/gwt/uiBinder/GwtUiXmlUiFieldIntentionBase", "invoke"));
        }
        Pair<XmlAttributeValue, PsiClass> pair = this.findAttribute(file, editor);
        if (pair == null) {
            return;
        }
        PsiClass psiClass = (PsiClass)pair.getSecond();
        if (!CommonRefactoringUtil.checkReadOnlyStatus((Project)project, (PsiElement)psiClass)) {
            return;
        }
        this.invokeInternal(project, (XmlAttributeValue)pair.getFirst(), psiClass);
    }

    protected abstract void invokeInternal(Project var1, XmlAttributeValue var2, PsiClass var3);

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/gwt/uiBinder/GwtUiXmlUiFieldIntentionBase", "isAvailable"));
        }
        return this.findAttribute(file, editor) != null;
    }

    @Nullable
    protected final Pair<XmlAttributeValue, PsiClass> findAttribute(PsiFile file, Editor editor) {
        if (!(file instanceof XmlFile)) {
            return null;
        }
        GwtFacet gwtFacet = GwtFacet.findFacetByPsiElement((PsiElement)file);
        if (gwtFacet == null) {
            return null;
        }
        PsiElement element = file.findElementAt(editor.getCaretModel().getOffset());
        XmlAttributeValue attributeValue = (XmlAttributeValue)PsiTreeUtil.getParentOfType((PsiElement)element, XmlAttributeValue.class);
        if (attributeValue == null) {
            return null;
        }
        XmlAttribute attribute = (XmlAttribute)PsiTreeUtil.getParentOfType((PsiElement)attributeValue, XmlAttribute.class);
        if (attribute == null || !attribute.getLocalName().equals("field") || !UiBinderUtil.hasUiBinderNamespace(attribute)) {
            return null;
        }
        String fieldName = attributeValue.getValue();
        List<PsiClass> classes = UiBinderMappingService.getInstance(gwtFacet.getModule()).getBoundClasses(file);
        PsiClass psiClass = this.filterClass(classes, fieldName);
        if (psiClass != null && PsiNameHelper.getInstance((Project)attributeValue.getProject()).isIdentifier(fieldName, PsiUtil.getLanguageLevel((PsiElement)psiClass))) {
            return Pair.create((Object)attributeValue, (Object)psiClass);
        }
        return null;
    }

    protected abstract PsiClass filterClass(List<PsiClass> var1, String var2);
}

