/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.integration.model.xml.fake;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleServiceManager;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.spring.integration.model.xml.fake.SpringIntegrationHeader;
import com.intellij.util.containers.ContainerUtil;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class SpringIntegrationHeadersFactory
implements Disposable {
    private final Set<SpringIntegrationHeader> myHeaders = ContainerUtil.newConcurrentSet();
    private final Map<PsiFile, Long> myContributors = ContainerUtil.newConcurrentMap();
    private final PsiFile myDummyFile;

    public static SpringIntegrationHeadersFactory getInstance(Module module) {
        return (SpringIntegrationHeadersFactory)ModuleServiceManager.getService((Module)module, SpringIntegrationHeadersFactory.class);
    }

    public SpringIntegrationHeadersFactory(Module module) {
        this.myDummyFile = PsiFileFactory.getInstance((Project)module.getProject()).createFileFromText("dummy_headers.java", (FileType)StdFileTypes.JAVA, (CharSequence)"");
    }

    @NotNull
    public SpringIntegrationHeader getOrCreateHeader(String headerName, @NotNull PsiFile containingFile) {
        if (containingFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "containingFile", "com/intellij/spring/integration/model/xml/fake/SpringIntegrationHeadersFactory", "getOrCreateHeader"));
        }
        if (this.myContributors.containsKey(containingFile) && this.myContributors.get(containingFile).longValue() != containingFile.getModificationStamp()) {
            this.myHeaders.clear();
            this.myContributors.clear();
        }
        for (SpringIntegrationHeader header : this.myHeaders) {
            if (!headerName.equals(header.getName())) continue;
            SpringIntegrationHeader springIntegrationHeader = header;
            if (springIntegrationHeader == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/integration/model/xml/fake/SpringIntegrationHeadersFactory", "getOrCreateHeader"));
            }
            return springIntegrationHeader;
        }
        SpringIntegrationHeader header = new SpringIntegrationHeader(headerName, this.myDummyFile);
        this.myHeaders.add(header);
        this.myContributors.put(containingFile, containingFile.getModificationStamp());
        SpringIntegrationHeader springIntegrationHeader = header;
        if (springIntegrationHeader == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/integration/model/xml/fake/SpringIntegrationHeadersFactory", "getOrCreateHeader"));
        }
        return springIntegrationHeader;
    }

    @NotNull
    public Set<SpringIntegrationHeader> getHeaders() {
        Set<SpringIntegrationHeader> set = this.myHeaders;
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/integration/model/xml/fake/SpringIntegrationHeadersFactory", "getHeaders"));
        }
        return set;
    }

    public void dispose() {
        this.myHeaders.clear();
        this.myContributors.clear();
    }
}

