/*
 * Decompiled with CFR 0.152.
 */
package org.junit.jupiter.engine.discovery.predicates;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.util.function.Predicate;
import org.junit.platform.commons.meta.API;
import org.junit.platform.commons.util.AnnotationUtils;
import org.junit.platform.commons.util.ReflectionUtils;

@API(value=API.Usage.Internal)
class IsTestableMethod
implements Predicate<Method> {
    private final Class<? extends Annotation> annotationType;

    IsTestableMethod(Class<? extends Annotation> annotationType) {
        this.annotationType = annotationType;
    }

    @Override
    public boolean test(Method candidate) {
        if (ReflectionUtils.isStatic((Member)candidate)) {
            return false;
        }
        if (ReflectionUtils.isPrivate((Member)candidate)) {
            return false;
        }
        if (ReflectionUtils.isAbstract((Member)candidate)) {
            return false;
        }
        return AnnotationUtils.isAnnotated((AnnotatedElement)candidate, this.annotationType);
    }
}

