/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.css.impl;

import com.intellij.css.util.CssPsiUtil;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.css.CssBlock;
import com.intellij.psi.css.CssDeclaration;
import com.intellij.psi.css.CssElementFactory;
import com.intellij.psi.css.CssElementVisitor;
import com.intellij.psi.css.impl.CssElementTypes;
import com.intellij.psi.css.impl.util.CssUtil;
import com.intellij.psi.impl.source.tree.LazyParseablePsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashSet;
import gnu.trove.TObjectHashingStrategy;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class CssBlockImpl
extends LazyParseablePsiElement
implements CssBlock {
    private static final TObjectHashingStrategy<CssDeclaration> ourStrategy = new TObjectHashingStrategy<CssDeclaration>(){

        public int computeHashCode(CssDeclaration object) {
            return object.equalityHashCode();
        }

        public boolean equals(CssDeclaration o1, CssDeclaration o2) {
            return o1.isEqualTo((Object)o2);
        }
    };

    CssBlockImpl(CharSequence text) {
        this(text, (IElementType)CssElementTypes.CSS_DECLARATION_BLOCK);
    }

    CssBlockImpl(CharSequence text, IElementType type) {
        super(type, text);
    }

    @NotNull
    public CssDeclaration[] getDeclarations() {
        CssDeclaration[] cssDeclarationArray = (CssDeclaration[])this.getChildrenAsPsiElements((IElementType)CssElementTypes.CSS_DECLARATION, CssDeclaration.ARRAY_FACTORY);
        if (cssDeclarationArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/impl/CssBlockImpl", "getDeclarations"));
        }
        return cssDeclarationArray;
    }

    public boolean isEqualTo(Object object) {
        if (!(object instanceof CssBlockImpl)) {
            return false;
        }
        CssBlockImpl block = (CssBlockImpl)((Object)object);
        THashSet<CssDeclaration> set1 = CssBlockImpl.getDeclarationsHashSet(this);
        THashSet<CssDeclaration> set2 = CssBlockImpl.getDeclarationsHashSet(block);
        return set1.equals(set2);
    }

    @Nullable
    public PsiElement getLBrace() {
        ASTNode node;
        PsiElement firstChild = PsiTreeUtil.getDeepestFirst((PsiElement)this);
        if (firstChild instanceof PsiWhiteSpace) {
            firstChild = PsiTreeUtil.nextVisibleLeaf((PsiElement)firstChild);
        }
        if (firstChild != null && (node = firstChild.getNode()) != null && node.getElementType() == CssElementTypes.CSS_LBRACE) {
            return firstChild;
        }
        return null;
    }

    @Nullable
    public PsiElement getRBrace() {
        ASTNode node;
        PsiElement lastChild = PsiTreeUtil.getDeepestLast((PsiElement)this);
        if (lastChild instanceof PsiWhiteSpace) {
            lastChild = PsiTreeUtil.prevVisibleLeaf((PsiElement)lastChild);
        }
        if (lastChild != null && (node = lastChild.getNode()) != null && node.getElementType() == CssElementTypes.CSS_RBRACE) {
            return lastChild;
        }
        return null;
    }

    private static THashSet<CssDeclaration> getDeclarationsHashSet(CssBlockImpl block) {
        return new THashSet((Collection)ContainerUtil.newArrayList((Object[])block.getDeclarations()), ourStrategy);
    }

    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "com/intellij/psi/css/impl/CssBlockImpl", "accept"));
        }
        if (visitor instanceof CssElementVisitor) {
            ((CssElementVisitor)visitor).visitCssBlock((CssBlock)this);
        } else {
            visitor.visitElement((PsiElement)this);
        }
    }

    public CssDeclaration addDeclaration(@NotNull String name, @NotNull String value, @Nullable CssDeclaration declarationAnchor) throws IncorrectOperationException {
        IElementType type;
        ASTNode astNode;
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/psi/css/impl/CssBlockImpl", "addDeclaration"));
        }
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/psi/css/impl/CssBlockImpl", "addDeclaration"));
        }
        CssDeclaration anchor = declarationAnchor;
        assert (anchor == null || anchor.getParent() == this);
        Project project = this.getProject();
        CssElementFactory factory = CssElementFactory.getInstance((Project)project);
        CssDeclaration cssDeclaration = factory.createProperty(name, value, CssPsiUtil.getStylesheetLanguage((PsiElement)this));
        PsiElement semicolon = cssDeclaration.getNextSibling();
        if (semicolon != null && semicolon.getNode().getElementType() != CssElementTypes.CSS_SEMICOLON) {
            semicolon = null;
        }
        if (anchor != null) {
            anchor = CssUtil.appendStatementWithSemicolonIfNeeded(project, (PsiElement)anchor);
        }
        PsiElement nextSibling = anchor != null ? PsiTreeUtil.nextVisibleLeaf((PsiElement)anchor) : null;
        PsiElement _anchor = nextSibling == null ? this.getFirstVisibleChild() : nextSibling;
        ASTNode aSTNode = astNode = _anchor != null ? _anchor.getNode() : null;
        if (astNode != null && (type = astNode.getElementType()) != CssElementTypes.CSS_SEMICOLON && anchor != null) {
            _anchor = anchor;
        }
        if (anchor != null && _anchor != null) {
            nextSibling = PsiTreeUtil.nextLeaf((PsiElement)_anchor);
            boolean containsNewLine = false;
            while (nextSibling != null && !containsNewLine) {
                boolean isComment = nextSibling instanceof PsiComment;
                boolean isWhiteSpace = nextSibling instanceof PsiWhiteSpace;
                if (!isComment && !isWhiteSpace) break;
                containsNewLine = StringUtil.containsChar((String)nextSibling.getText(), (char)'\n');
                if (containsNewLine && !isComment) continue;
                _anchor = nextSibling;
                nextSibling = PsiTreeUtil.nextLeaf((PsiElement)nextSibling);
            }
        }
        return (CssDeclaration)(semicolon != null ? this.addRangeAfter((PsiElement)cssDeclaration, semicolon, _anchor) : this.addAfter((PsiElement)cssDeclaration, _anchor));
    }

    @Nullable
    private PsiElement getFirstVisibleChild() {
        PsiElement firstChild = this.getFirstChild();
        if (firstChild != null) {
            return StringUtil.isEmptyOrSpaces((String)firstChild.getText()) ? PsiTreeUtil.nextVisibleLeaf((PsiElement)firstChild) : firstChild;
        }
        return null;
    }

    public void removeDeclaration(@NotNull CssDeclaration declaration) throws IncorrectOperationException {
        if (declaration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "declaration", "com/intellij/psi/css/impl/CssBlockImpl", "removeDeclaration"));
        }
        PsiElement nextSibling = declaration.getNextSibling();
        if (nextSibling != null) {
            ASTNode astNode1;
            PsiElement nextNextSibling;
            ASTNode astNode = nextSibling.getNode();
            if (!(astNode == null || astNode.getElementType() != CssElementTypes.CSS_WHITE_SPACE && astNode.getElementType() != CssElementTypes.CSS_SEMICOLON || (nextNextSibling = nextSibling.getNextSibling()) == null || (astNode1 = nextNextSibling.getNode()) == null || CssElementTypes.CSS_SEMICOLON != astNode1.getElementType() && CssElementTypes.CSS_WHITE_SPACE != astNode1.getElementType())) {
                nextSibling = nextNextSibling;
            }
            if ((astNode = nextSibling.getNode()) != null && (astNode.getElementType() == CssElementTypes.CSS_SEMICOLON || astNode.getElementType() == CssElementTypes.CSS_WHITE_SPACE)) {
                this.deleteChildRange((PsiElement)declaration, nextSibling);
            } else {
                this.deleteChildRange((PsiElement)declaration, (PsiElement)declaration);
            }
        }
    }

    @Nullable
    public CssDeclaration findDeclaration(@NotNull String propertyName) {
        if (propertyName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "propertyName", "com/intellij/psi/css/impl/CssBlockImpl", "findDeclaration"));
        }
        return this.findDeclaration(propertyName, true);
    }

    @Nullable
    public CssDeclaration findDeclaration(@NotNull String propertyName, boolean searchInShorthand) {
        if (propertyName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "propertyName", "com/intellij/psi/css/impl/CssBlockImpl", "findDeclaration"));
        }
        return CssPsiUtil.findDeclaration((CssBlock)this, (String)propertyName, (boolean)searchInShorthand);
    }
}

