/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.css.impl.util.completion.provider;

import com.google.common.collect.Sets;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionProvider;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.css.util.CssPsiUtil;
import com.intellij.lang.Language;
import com.intellij.lang.html.HTMLLanguage;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.XmlElementFactory;
import com.intellij.psi.css.CssAttributeDescriptorsProvider;
import com.intellij.psi.css.CssRuleset;
import com.intellij.psi.css.CssSimpleSelector;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ProcessingContext;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.xml.XmlElementDescriptor;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class CssHtmlAttributeNameCompletionProvider
extends CompletionProvider<CompletionParameters> {
    protected void addCompletions(@NotNull CompletionParameters parameters, ProcessingContext context, @NotNull CompletionResultSet result) {
        if (parameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "com/intellij/psi/css/impl/util/completion/provider/CssHtmlAttributeNameCompletionProvider", "addCompletions"));
        }
        if (result == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/psi/css/impl/util/completion/provider/CssHtmlAttributeNameCompletionProvider", "addCompletions"));
        }
        PsiElement position = parameters.getPosition();
        Set allTagElements = null;
        Set<String> tagNames = CssHtmlAttributeNameCompletionProvider.getTagNames(position);
        for (String tagName : tagNames) {
            if (tagName.isEmpty()) continue;
            try {
                XmlElementFactory elementFactory = XmlElementFactory.getInstance((Project)position.getProject());
                XmlTag xmlTag = elementFactory.createTagFromText((CharSequence)("<!DOCTYPE html><" + tagName + ">"), (Language)HTMLLanguage.INSTANCE);
                xmlTag.putUserData(CssAttributeDescriptorsProvider.DO_NOT_PROVIDE_ATTRIBUTES_FROM_CSS, (Object)Boolean.TRUE);
                XmlElementDescriptor elementDescriptor = xmlTag.getDescriptor();
                if (elementDescriptor == null) continue;
                Object[] attributesDescriptors = elementDescriptor.getAttributesDescriptors(xmlTag);
                Set tagElements = ContainerUtil.map2Set((Object[])attributesDescriptors, descriptor -> LookupElementBuilder.create((String)descriptor.getName()));
                allTagElements = allTagElements == null ? tagElements : Sets.intersection((Set)allTagElements, (Set)tagElements);
            }
            catch (IncorrectOperationException incorrectOperationException) {}
        }
        if (allTagElements != null) {
            result.addAllElements(allTagElements);
        }
        result.addElement((LookupElement)LookupElementBuilder.create((String)"class"));
        result.addElement((LookupElement)LookupElementBuilder.create((String)"id"));
    }

    private static Set<String> getTagNames(PsiElement position) {
        CssSimpleSelector simpleSelectors = (CssSimpleSelector)PsiTreeUtil.getParentOfType((PsiElement)position, CssSimpleSelector.class);
        if (simpleSelectors != null) {
            String elementName = simpleSelectors.getElementName();
            if (!elementName.isEmpty()) {
                return ContainerUtil.immutableSet((Object[])new String[]{elementName});
            }
        } else {
            Set result;
            CssRuleset ruleset = (CssRuleset)PsiTreeUtil.getParentOfType((PsiElement)position, CssRuleset.class);
            if (ruleset != null && !(result = CssPsiUtil.getRulesetTags((CssRuleset)ruleset)).isEmpty()) {
                return result;
            }
        }
        return ContainerUtil.immutableSet((Object[])new String[]{"div"});
    }
}

