/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.css.inspections;

import com.intellij.codeInspection.LocalQuickFixBase;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.css.CssBundle;
import com.intellij.psi.css.impl.CssTokenImpl;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import org.jetbrains.annotations.NotNull;

class RoundPxValueQuickFix
extends LocalQuickFixBase {
    private static final String EMPTY_STRING = "";

    public RoundPxValueQuickFix() {
        super(CssBundle.message((String)"css.inspections.float.px.length.fix.message", (Object[])new Object[0]));
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/psi/css/inspections/RoundPxValueQuickFix", "applyFix"));
        }
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/psi/css/inspections/RoundPxValueQuickFix", "applyFix"));
        }
        PsiElement element = descriptor.getPsiElement();
        if (element instanceof CssTokenImpl) {
            String elementText = element.getText();
            try {
                double doubleValue = Double.parseDouble(elementText);
                ((CssTokenImpl)element).replaceWithText(String.valueOf(Math.round(doubleValue)));
            }
            catch (NumberFormatException e) {
                CommonRefactoringUtil.showErrorHint((Project)project, null, (String)CssBundle.message((String)"css.inspections.float.px.length.fix.error", (Object[])new Object[]{elementText}), (String)EMPTY_STRING, null);
            }
        }
    }
}

