/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.css.inspections.invalid;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiReference;
import com.intellij.psi.css.CssAtRule;
import com.intellij.psi.css.CssBundle;
import com.intellij.psi.css.CssElementVisitor;
import com.intellij.psi.css.impl.CssAtRuleImpl;
import com.intellij.psi.css.impl.CssElementTypes;
import com.intellij.psi.css.inspections.CssBaseInspection;
import com.intellij.psi.css.inspections.fixes.CssAddPrefixQuickFix;
import com.intellij.psi.css.resolve.CssCustomMixinReference;
import org.jetbrains.annotations.NotNull;

public class CssUnresolvedCustomPropertySetInspection
extends CssBaseInspection {
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/psi/css/inspections/invalid/CssUnresolvedCustomPropertySetInspection", "buildVisitor"));
        }
        CssElementVisitor cssElementVisitor = new CssElementVisitor(){

            public void visitAtRule(CssAtRule atRule) {
                if (!(atRule instanceof CssAtRuleImpl) || atRule.getFirstChild() == null) {
                    return;
                }
                if (atRule.getFirstChild().getNode().getElementType() != CssElementTypes.CSS_APPLY_SYM) {
                    return;
                }
                PsiElement identifier = ((CssAtRuleImpl)atRule).findPsiChildByType(CssElementTypes.CSS_IDENT);
                if (identifier == null) {
                    return;
                }
                String text = identifier.getText();
                if (text.equals("--")) {
                    holder.registerProblem(identifier, CssBundle.message((String)"css.inspections.unresolved.custom.property.empty.message", (Object[])new Object[0]), new LocalQuickFix[0]);
                } else if (!StringUtil.startsWith((CharSequence)text, (CharSequence)"--")) {
                    CssAddPrefixQuickFix quickFix = new CssAddPrefixQuickFix(CssBundle.message((String)"css.inspections.unresolved.custom.property.dashes.fix.message", (Object[])new Object[0]), "--", atRule.getClass());
                    String description = CssBundle.message((String)"css.inspections.unresolved.custom.property.dashes.message", (Object[])new Object[0]);
                    TextRange textRange = TextRange.from((int)identifier.getStartOffsetInParent(), (int)identifier.getTextLength());
                    ProblemDescriptor problemDescriptor = holder.getManager().createProblemDescriptor((PsiElement)atRule, textRange, description, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, true, new LocalQuickFix[]{quickFix});
                    holder.registerProblem(problemDescriptor);
                } else {
                    for (PsiReference ref : identifier.getReferences()) {
                        if (!(ref instanceof CssCustomMixinReference) || ((CssCustomMixinReference)ref).multiResolve(false).length != 0) continue;
                        holder.registerProblem(identifier, CssBundle.message((String)"css.inspections.unresolved.custom.property.set.message", (Object[])new Object[]{ref.getCanonicalText()}), new LocalQuickFix[0]);
                        return;
                    }
                }
            }
        };
        if (cssElementVisitor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/inspections/invalid/CssUnresolvedCustomPropertySetInspection", "buildVisitor"));
        }
        return cssElementVisitor;
    }
}

