/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.css.resolve;

import com.intellij.psi.css.CssDeclaration;
import com.intellij.psi.css.CssSelector;
import com.intellij.psi.css.Specificity;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class Match
implements Comparable {
    @Nullable
    private final String myPseudoClass;
    @Nullable
    private final CssSelector mySelector;
    @NotNull
    private final CssDeclaration myDeclaration;

    public Match(@Nullable CssSelector selector, @NotNull CssDeclaration declaration, @Nullable String pseudoClass) {
        if (declaration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "declaration", "com/intellij/psi/css/resolve/Match", "<init>"));
        }
        this.mySelector = selector;
        this.myDeclaration = declaration;
        this.myPseudoClass = pseudoClass;
    }

    @NotNull
    public CssDeclaration getDeclaration() {
        CssDeclaration cssDeclaration = this.myDeclaration;
        if (cssDeclaration == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/resolve/Match", "getDeclaration"));
        }
        return cssDeclaration;
    }

    @Nullable
    public String getPseudoClass() {
        return this.myPseudoClass;
    }

    public int compareTo(@NotNull Object o) {
        boolean important2;
        if (o == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "o", "com/intellij/psi/css/resolve/Match", "compareTo"));
        }
        Match match2 = (Match)o;
        boolean important1 = this.myDeclaration.isImportant();
        if (important1 ^ (important2 = match2.myDeclaration.isImportant())) {
            return important2 ? -1 : 1;
        }
        Specificity specificity1 = this.mySelector != null ? this.mySelector.getSpecificity() : Specificity.UNLIMITED;
        Specificity specificity2 = match2.mySelector != null ? match2.mySelector.getSpecificity() : Specificity.UNLIMITED;
        return specificity1.compareTo((Object)specificity2);
    }
}

