/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript;

import com.intellij.javascript.JavaScriptReferenceContributor;
import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.injection.MultiHostInjector;
import com.intellij.lang.injection.MultiHostRegistrar;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.JSTargetedInjector;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.index.JSSymbolUtil;
import com.intellij.lang.javascript.psi.JSArgumentList;
import com.intellij.lang.javascript.psi.JSBinaryExpression;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.lang.javascript.psi.JSParenthesizedExpression;
import com.intellij.lang.javascript.psi.JSQualifiedName;
import com.intellij.lang.javascript.psi.JSRecursiveWalkingElementVisitor;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.ecma6.JSStringTemplateExpression;
import com.intellij.lang.javascript.psi.impl.JSLiteralExpressionImpl;
import com.intellij.lang.javascript.psi.util.JSUtils;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.PsiQualifiedReference;
import com.intellij.psi.PsiRecursiveElementWalkingVisitor;
import com.intellij.psi.templateLanguages.OuterLanguageElement;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSInjectionController {
    public static final int MAX_LITERAL_PROCESSING_SIZE = 4096;
    public static final List<Class<? extends PsiElement>> ELEMENTS_TO_INJECT_IN = ContainerUtil.list((Object[])new Class[]{JSLiteralExpression.class});

    private JSInjectionController() {
    }

    public static boolean willInjectJs(@NotNull PsiElement host) {
        JSExpression[] args;
        JSQualifiedName name;
        if (host == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "host", "com/intellij/lang/javascript/JSInjectionController", "willInjectJs"));
        }
        PsiElement hostParent = host.getParent();
        JSReferenceExpression expression = JSUtils.getMethodNameIfInsideCall(hostParent);
        JSQualifiedName jSQualifiedName = name = expression != null ? JSSymbolUtil.getAccurateReferenceName((PsiQualifiedReference)expression) : null;
        return name != null && ("setInterval".equals(name.getName()) || "setTimeout".equals(name.getName())) && (name.getParent() == null || name.getParent().getParent() == null && "window".equals(name.getParent().getName())) && hostParent instanceof JSArgumentList && (args = ((JSArgumentList)hostParent).getArguments()).length > 0 && args[0] == host;
    }

    public static boolean willInjectSomething(@NotNull JSLiteralExpressionImpl host) {
        if (host == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "host", "com/intellij/lang/javascript/JSInjectionController", "willInjectSomething"));
        }
        return JSInjectionController.willInjectHtml((PsiElement)host) || JSInjectionController.willInjectJs((PsiElement)host) || JSInjectionController.willInjectCss((PsiElement)host);
    }

    public static boolean willInjectCss(@NotNull PsiElement topElement) {
        if (topElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "topElement", "com/intellij/lang/javascript/JSInjectionController", "willInjectCss"));
        }
        ASTNode node = topElement.getNode();
        if (node == null) {
            return false;
        }
        if (node.getTextLength() >= 4096) {
            return false;
        }
        if (JavaScriptReferenceContributor.isLiteralInCssContext(topElement, false)) {
            return JSInjectionController.checkValidAndNontrivialCss(JSInjectionController.getInjectionText(topElement));
        }
        return false;
    }

    private static boolean checkValidAndNontrivialCss(String text) {
        String textWithoutQuotes;
        if (StringUtil.containsChar((String)text, (char)'?')) {
            return false;
        }
        if (StringUtil.containsChar((String)text, (char)'%')) {
            return false;
        }
        if (text.contains("##")) {
            return false;
        }
        if (StringUtil.containsChar((String)text, (char)'#')) {
            int diesIndex = text.indexOf(35);
            while (diesIndex == 0 || diesIndex > 0 && (text.charAt(diesIndex - 1) == '\'' || text.charAt(diesIndex - 1) != '=')) {
                diesIndex = text.indexOf(35, diesIndex + 1);
            }
            if (diesIndex >= 0) {
                return false;
            }
        }
        if (text.contains("[]")) {
            return false;
        }
        int eqPos = text.indexOf(61);
        if (eqPos != -1) {
            int valuePos;
            for (valuePos = eqPos + 1; valuePos < text.length() && Character.isWhitespace(text.charAt(valuePos)); ++valuePos) {
            }
            if (valuePos < text.length() && Character.isDigit(text.charAt(valuePos))) {
                return false;
            }
        }
        if ((textWithoutQuotes = StringUtil.stripQuotesAroundValue((String)text)).startsWith(">")) {
            return false;
        }
        return !JavaScriptReferenceContributor.isSimpleCss(textWithoutQuotes);
    }

    public static boolean willInjectHtml(@NotNull PsiElement hostExpression) {
        if (hostExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "hostExpression", "com/intellij/lang/javascript/JSInjectionController", "willInjectHtml"));
        }
        if (!DialectDetector.isActionScript(hostExpression) && hostExpression.getTextLength() < 4096) {
            if (!hostExpression.textContains('<')) {
                return false;
            }
            String text = hostExpression instanceof JSStringTemplateExpression ? new JSQuotedLiteralInjector((JSLiteralExpression)((JSStringTemplateExpression)hostExpression)).getInjectedText() : hostExpression.getText();
            int length = text.length();
            int tagStart = text.indexOf(60);
            return tagStart >= 0 && (tagStart < length - 1 && Character.isLetter(text.charAt(tagStart + 1)) || tagStart < length - 2 && text.charAt(tagStart + 1) == '/' && Character.isLetter(text.charAt(tagStart + 2)) || tagStart < length - 3 && text.charAt(tagStart + 1) == '!' && text.charAt(tagStart + 2) == '-' && text.charAt(tagStart + 3) == '-') && text.indexOf(62, tagStart) > 0 && !JSInjectionController.hasOuterLanguage(hostExpression);
        }
        return false;
    }

    protected static boolean hasOuterLanguage(PsiElement host) {
        final Ref result = Ref.create((Object)false);
        host.accept((PsiElementVisitor)new PsiRecursiveElementWalkingVisitor(){

            public void visitElement(PsiElement element) {
                if (element instanceof OuterLanguageElement) {
                    result.set((Object)true);
                    this.stopWalking();
                    return;
                }
                super.visitElement(element);
            }
        });
        return (Boolean)result.get();
    }

    public static void getLanguagesToInjectStatic(@NotNull MultiHostRegistrar registrar, @NotNull PsiElement host) {
        if (registrar == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "registrar", "com/intellij/lang/javascript/JSInjectionController", "getLanguagesToInjectStatic"));
        }
        if (host == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "host", "com/intellij/lang/javascript/JSInjectionController", "getLanguagesToInjectStatic"));
        }
        for (MultiHostInjector injector : (MultiHostInjector[])Extensions.getExtensions((ExtensionPointName)MultiHostInjector.MULTIHOST_INJECTOR_EP_NAME, (AreaInstance)host.getProject())) {
            if (!(injector instanceof JSTargetedInjector)) continue;
            injector.getLanguagesToInject(registrar, host);
        }
    }

    @NotNull
    public static PsiElement getTopElement(@NotNull PsiLanguageInjectionHost host) {
        if (host == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "host", "com/intellij/lang/javascript/JSInjectionController", "getTopElement"));
        }
        PsiLanguageInjectionHost parent = host;
        while (parent.getParent() instanceof JSBinaryExpression && ((JSBinaryExpression)parent.getParent()).getOperationSign() == JSTokenTypes.PLUS || parent.getParent() instanceof JSParenthesizedExpression) {
            parent = parent.getParent();
        }
        PsiLanguageInjectionHost psiLanguageInjectionHost = parent;
        if (psiLanguageInjectionHost == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/JSInjectionController", "getTopElement"));
        }
        return psiLanguageInjectionHost;
    }

    public static List<JSLiteralExpression> getConcatenationParts(@NotNull PsiElement topElement) {
        if (topElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "topElement", "com/intellij/lang/javascript/JSInjectionController", "getConcatenationParts"));
        }
        final ArrayList results = ContainerUtil.newArrayList();
        topElement.accept((PsiElementVisitor)new JSRecursiveWalkingElementVisitor(){

            public void visitElement(PsiElement element) {
                if (element instanceof JSBinaryExpression && ((JSBinaryExpression)element).getOperationSign() == JSTokenTypes.PLUS || element instanceof JSParenthesizedExpression) {
                    super.visitElement(element);
                }
            }

            public void visitJSLiteralExpression(JSLiteralExpression node) {
                if (node.isQuotedLiteral()) {
                    results.add(node);
                }
            }
        });
        return results;
    }

    @NotNull
    public static String getInjectionText(@NotNull PsiElement topElement) {
        if (topElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "topElement", "com/intellij/lang/javascript/JSInjectionController", "getInjectionText"));
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (JSLiteralExpression literalExpression : JSInjectionController.getConcatenationParts(topElement)) {
            stringBuilder.append(new JSQuotedLiteralInjector(literalExpression).getInjectedText());
        }
        String string = stringBuilder.toString();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/JSInjectionController", "getInjectionText"));
        }
        return string;
    }

    @NotNull
    public static List<PlaceInfo> getPlaceInfos(@NotNull PsiElement topElement) {
        if (topElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "topElement", "com/intellij/lang/javascript/JSInjectionController", "getPlaceInfos"));
        }
        ArrayList result = ContainerUtil.newArrayList();
        for (JSLiteralExpression literalExpression : JSInjectionController.getConcatenationParts(topElement)) {
            result.addAll(new JSQuotedLiteralInjector(literalExpression).getPlaces());
        }
        ArrayList arrayList = result;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/JSInjectionController", "getPlaceInfos"));
        }
        return arrayList;
    }

    public static void injectInQuotedLiteral(@NotNull MultiHostRegistrar registrar, @NotNull Language language, @NotNull JSLiteralExpression literalExpression, @Nullable String prefix, @Nullable String suffix) {
        if (registrar == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "registrar", "com/intellij/lang/javascript/JSInjectionController", "injectInQuotedLiteral"));
        }
        if (language == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "language", "com/intellij/lang/javascript/JSInjectionController", "injectInQuotedLiteral"));
        }
        if (literalExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "literalExpression", "com/intellij/lang/javascript/JSInjectionController", "injectInQuotedLiteral"));
        }
        List<PlaceInfo> places = new JSQuotedLiteralInjector(literalExpression).getPlaces();
        if (places.isEmpty()) {
            return;
        }
        registrar.startInjecting(language);
        JSInjectionController.injectForPlaces(registrar, places, prefix, suffix);
        registrar.doneInjecting();
    }

    public static void concatenationAwareInject(@NotNull MultiHostRegistrar registrar, @NotNull Language language, @NotNull PsiElement topElement, @Nullable String prefix, @Nullable String suffix) {
        if (registrar == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "registrar", "com/intellij/lang/javascript/JSInjectionController", "concatenationAwareInject"));
        }
        if (language == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "language", "com/intellij/lang/javascript/JSInjectionController", "concatenationAwareInject"));
        }
        if (topElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "topElement", "com/intellij/lang/javascript/JSInjectionController", "concatenationAwareInject"));
        }
        List<PlaceInfo> places = JSInjectionController.getPlaceInfos(topElement);
        if (places.isEmpty()) {
            return;
        }
        registrar.startInjecting(language);
        JSInjectionController.injectForPlaces(registrar, places, prefix, suffix);
        registrar.doneInjecting();
    }

    private static void injectForPlaces(@NotNull MultiHostRegistrar registrar, @NotNull List<PlaceInfo> places, @Nullable String prefix, @Nullable String suffix) {
        if (registrar == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "registrar", "com/intellij/lang/javascript/JSInjectionController", "injectForPlaces"));
        }
        if (places == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "places", "com/intellij/lang/javascript/JSInjectionController", "injectForPlaces"));
        }
        boolean first = true;
        Iterator<PlaceInfo> iterator = places.iterator();
        while (iterator.hasNext()) {
            PlaceInfo place = iterator.next();
            String placePrefix = place.getPrefix();
            String placeSuffix = place.getSuffix();
            if (first && prefix != null) {
                placePrefix = placePrefix == null ? prefix : prefix + placePrefix;
            }
            first = false;
            if (!iterator.hasNext() && suffix != null) {
                placeSuffix = placeSuffix == null ? suffix : placeSuffix + suffix;
            }
            registrar.addPlace(placePrefix, placeSuffix, place.getHost(), place.getRange());
        }
    }

    private static class PlaceInfo {
        private final String myPrefix;
        private final TextRange myRange;
        private final String mySuffix;
        private final PsiLanguageInjectionHost myHost;

        public PlaceInfo(String prefix, TextRange range, String suffix, PsiLanguageInjectionHost host) {
            this.myPrefix = prefix;
            this.myRange = range;
            this.mySuffix = suffix;
            this.myHost = host;
        }

        public String getPrefix() {
            return this.myPrefix;
        }

        public String getSuffix() {
            return this.mySuffix;
        }

        public TextRange getRange() {
            return this.myRange;
        }

        public PsiLanguageInjectionHost getHost() {
            return this.myHost;
        }

        public static PlaceInfo create(String prefix, TextRange range, String suffix, PsiLanguageInjectionHost host) {
            return new PlaceInfo(prefix, range, suffix, host);
        }
    }

    static class JSQuotedLiteralInjector {
        private static final String EXTERNAL_FRAGMENT = "EXTERNAL_FRAGMENT";
        @NotNull
        private final JSLiteralExpression myQuotedLiteral;

        public JSQuotedLiteralInjector(@NotNull JSLiteralExpression quotedLiteral) {
            if (quotedLiteral == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "quotedLiteral", "com/intellij/lang/javascript/JSInjectionController$JSQuotedLiteralInjector", "<init>"));
            }
            this.myQuotedLiteral = quotedLiteral;
        }

        public String getInjectedText() {
            String text = this.myQuotedLiteral.getText();
            StringBuilder result = new StringBuilder();
            for (PlaceInfo place : this.getPlaces()) {
                if (place.getPrefix() != null) {
                    result.append(place.getPrefix());
                }
                result.append(text.substring(place.getRange().getStartOffset(), place.getRange().getEndOffset()));
                if (place.getSuffix() == null) continue;
                result.append(place.getSuffix());
            }
            return result.toString();
        }

        public List<PlaceInfo> getPlaces() {
            if (this.myQuotedLiteral instanceof JSStringTemplateExpression) {
                JSStringTemplateExpression templateExpression = (JSStringTemplateExpression)this.myQuotedLiteral;
                TextRange[] ranges = templateExpression.getStringRanges();
                if (ranges.length > 0) {
                    ArrayList<PlaceInfo> result = new ArrayList<PlaceInfo>(ranges.length);
                    ASTNode quotedLiteralNode = this.myQuotedLiteral.getNode();
                    ASTNode backquote = quotedLiteralNode.findChildByType(JSTokenTypes.BACKQUOTE);
                    int backquoteOffset = backquote != null ? backquote.getStartOffset() - quotedLiteralNode.getStartOffset() : -1;
                    for (int i = 0; i < ranges.length; ++i) {
                        TextRange range = ranges[i];
                        String prefix = i == 0 && range.getStartOffset() > backquoteOffset + 1 ? EXTERNAL_FRAGMENT : null;
                        String suffix = i < ranges.length - 1 || range.getEndOffset() < this.myQuotedLiteral.getTextLength() - 1 ? EXTERNAL_FRAGMENT : null;
                        result.add(PlaceInfo.create(prefix, range, suffix, (PsiLanguageInjectionHost)this.myQuotedLiteral));
                    }
                    return result;
                }
                if (!ArrayUtil.isEmpty((Object[])templateExpression.getArguments())) {
                    return ContainerUtil.emptyList();
                }
            }
            int endOffset = Math.max(this.myQuotedLiteral.getTextLength() - 1, 1);
            return Collections.singletonList(PlaceInfo.create(null, TextRange.create((int)1, (int)endOffset), null, (PsiLanguageInjectionHost)this.myQuotedLiteral));
        }
    }
}

