/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.bower;

import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreter;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreterRef;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BowerSettings {
    private final Project myProject;
    private final NodeJsInterpreterRef myInterpreterRef;
    private final String myBowerExecutablePath;
    private final String myBowerJsonPath;

    private BowerSettings(@NotNull Builder builder) {
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/lang/javascript/bower/BowerSettings", "<init>"));
        }
        this.myProject = builder.myProject;
        this.myInterpreterRef = builder.myInterpreterRef;
        this.myBowerExecutablePath = FileUtil.toSystemIndependentName((String)builder.myBowerExecutablePath);
        this.myBowerJsonPath = FileUtil.toSystemIndependentName((String)builder.myBowerJsonPath);
    }

    @Nullable
    public NodeJsInterpreter getInterpreter() {
        return this.myInterpreterRef.resolve(this.myProject);
    }

    @NotNull
    public NodeJsInterpreterRef getInterpreterRef() {
        NodeJsInterpreterRef nodeJsInterpreterRef = this.myInterpreterRef;
        if (nodeJsInterpreterRef == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/bower/BowerSettings", "getInterpreterRef"));
        }
        return nodeJsInterpreterRef;
    }

    @NotNull
    public String getBowerExecutablePath() {
        String string = this.myBowerExecutablePath;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/bower/BowerSettings", "getBowerExecutablePath"));
        }
        return string;
    }

    @NotNull
    public String getBowerJsonPath() {
        String string = this.myBowerJsonPath;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/bower/BowerSettings", "getBowerJsonPath"));
        }
        return string;
    }

    @NotNull
    public Builder createBuilder() {
        Builder builder = new Builder(this.myProject);
        builder.setInterpreterRef(this.myInterpreterRef);
        builder.setBowerExecutablePath(this.myBowerExecutablePath);
        builder.setBowerJsonPath(this.myBowerJsonPath);
        Builder builder2 = builder;
        if (builder2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/bower/BowerSettings", "createBuilder"));
        }
        return builder2;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BowerSettings settings = (BowerSettings)o;
        return this.myInterpreterRef.getReferenceName().equals(settings.getInterpreterRef().getReferenceName()) && this.myBowerExecutablePath.equals(settings.myBowerExecutablePath) && this.myBowerJsonPath.equals(settings.myBowerJsonPath);
    }

    public int hashCode() {
        int result = this.myInterpreterRef.getReferenceName().hashCode();
        result = 31 * result + this.myBowerExecutablePath.hashCode();
        result = 31 * result + this.myBowerJsonPath.hashCode();
        return result;
    }

    public String toString() {
        return "nodeInterpreter='" + this.myInterpreterRef.getReferenceName() + '\'' + ", bowerExecutable='" + this.myBowerExecutablePath + '\'' + ", bower.json='" + this.myBowerJsonPath + '\'';
    }

    public static class Builder {
        private final Project myProject;
        private NodeJsInterpreterRef myInterpreterRef;
        private String myBowerExecutablePath;
        private String myBowerJsonPath;

        public Builder(@NotNull Project project) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/bower/BowerSettings$Builder", "<init>"));
            }
            this.myInterpreterRef = NodeJsInterpreterRef.createProjectRef();
            this.myBowerExecutablePath = "";
            this.myBowerJsonPath = "";
            this.myProject = project;
        }

        @NotNull
        public Builder setInterpreterRef(@NotNull NodeJsInterpreterRef interpreterRef) {
            if (interpreterRef == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "interpreterRef", "com/intellij/lang/javascript/bower/BowerSettings$Builder", "setInterpreterRef"));
            }
            this.myInterpreterRef = interpreterRef;
            Builder builder = this;
            if (builder == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/bower/BowerSettings$Builder", "setInterpreterRef"));
            }
            return builder;
        }

        @NotNull
        public Builder setBowerExecutablePath(@NotNull String bowerExecutablePath) {
            if (bowerExecutablePath == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bowerExecutablePath", "com/intellij/lang/javascript/bower/BowerSettings$Builder", "setBowerExecutablePath"));
            }
            this.myBowerExecutablePath = bowerExecutablePath;
            Builder builder = this;
            if (builder == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/bower/BowerSettings$Builder", "setBowerExecutablePath"));
            }
            return builder;
        }

        @NotNull
        public Builder setBowerJsonPath(@NotNull String bowerJsonPath) {
            if (bowerJsonPath == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bowerJsonPath", "com/intellij/lang/javascript/bower/BowerSettings$Builder", "setBowerJsonPath"));
            }
            this.myBowerJsonPath = bowerJsonPath;
            Builder builder = this;
            if (builder == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/bower/BowerSettings$Builder", "setBowerJsonPath"));
            }
            return builder;
        }

        @NotNull
        public BowerSettings build() {
            BowerSettings bowerSettings = new BowerSettings(this);
            if (bowerSettings == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/bower/BowerSettings$Builder", "build"));
            }
            return bowerSettings;
        }
    }
}

