/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.completion;

import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.codeInsight.lookup.LookupElementPresentation;
import com.intellij.codeInsight.lookup.LookupItem;
import com.intellij.icons.AllIcons;
import com.intellij.javascript.JSParameterInfoHandler;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.completion.JSCompletionContributor;
import com.intellij.lang.javascript.completion.JSCompletionUtil;
import com.intellij.lang.javascript.completion.JSLookupPriority;
import com.intellij.lang.javascript.documentation.JSDocumentationUtils;
import com.intellij.lang.javascript.index.JSItemPresentation;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSElementBase;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSFunctionItem;
import com.intellij.lang.javascript.psi.JSParameterItem;
import com.intellij.lang.javascript.psi.JSQualifiedName;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.ecmal4.JSNamespaceDeclaration;
import com.intellij.lang.javascript.psi.ecmal4.JSPackageStatement;
import com.intellij.lang.javascript.psi.ecmal4.JSQualifiedNamedElement;
import com.intellij.lang.javascript.psi.ecmal4.XmlBackedJSClass;
import com.intellij.lang.javascript.psi.ecmal4.impl.JSIconProvider;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.psi.jsdoc.JSDocComment;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.types.JSCompositeTypeImpl;
import com.intellij.lang.javascript.psi.types.JSTypeSubstitutor;
import com.intellij.lang.javascript.psi.types.JSTypeofTypeImpl;
import com.intellij.lang.javascript.psi.types.primitives.JSVoidType;
import com.intellij.lang.javascript.psi.util.JSStubBasedPsiTreeUtil;
import com.intellij.navigation.ItemPresentation;
import com.intellij.navigation.NavigationItem;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.xml.XmlElement;
import com.intellij.ui.RowIcon;
import com.intellij.util.PlatformIcons;
import com.intellij.util.ui.EmptyIcon;
import java.util.Map;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSLookupUtilImpl {
    private static final JSLookupPriority MY_LAST_VALUE_WITHOUT_PRIORITY = JSLookupPriority.RELEVANT_SMARTNESS_PRIORITY;

    @NotNull
    public static Couple<String> getTypeAndTailTexts(@NotNull PsiElement element, @Nullable JSTypeSubstitutor typeSubstitutor) {
        String packageLocationString;
        String s;
        JSType type;
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/completion/JSLookupUtilImpl", "getTypeAndTailTexts"));
        }
        String typeText = null;
        String tailText = null;
        JSFunctionItem possibleFunction = JSPsiImplUtils.calculatePossibleFunction(element);
        if (possibleFunction != null) {
            JSType typeFromSetAccessor;
            type = possibleFunction.getReturnType();
            if (type instanceof JSVoidType && possibleFunction.isSetProperty() && (typeFromSetAccessor = JSResolveUtil.getTypeFromSetAccessor(possibleFunction)) != null) {
                type = typeFromSetAccessor;
            }
            if (JSLookupUtilImpl.isTypeAcceptableForHint(type)) {
                type = JSTypeUtils.applyGenericArguments(type, (Map<String, JSType>)typeSubstitutor);
                typeText = type.getTypeText(JSType.TypeTextFormat.PRESENTABLE);
            }
        } else if (element instanceof JSClass || element instanceof JSNamespaceDeclaration) {
            if (DialectDetector.isActionScript(element)) {
                typeText = JSItemPresentation.getFileName(element.getContainingFile());
            } else {
                tailText = JSLookupUtilImpl.getLocationStringFromPresentation((NavigationItem)element);
            }
        } else {
            type = JSTypeUtils.getTypeOfElement(element);
            if (JSLookupUtilImpl.isTypeAcceptableForHint(type)) {
                type = JSTypeUtils.applyGenericArguments(type, (Map<String, JSType>)typeSubstitutor);
                typeText = type.getTypeText(JSType.TypeTextFormat.PRESENTABLE);
            }
        }
        if (possibleFunction != null && (s = JSLookupUtilImpl.getFunctionTailText(possibleFunction, true, typeSubstitutor)) != null) {
            tailText = s;
        }
        if (element instanceof JSQualifiedNamedElement && tailText == null && (packageLocationString = JSLookupUtilImpl.getPackageLocationString((JSElementBase)((JSQualifiedNamedElement)element))) != null) {
            tailText = packageLocationString;
        }
        if (tailText == null) {
            tailText = JSLookupUtilImpl.getLocationStringFromPresentation((NavigationItem)element);
        }
        Couple couple = Couple.of((Object)typeText, (Object)tailText);
        if (couple == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/completion/JSLookupUtilImpl", "getTypeAndTailTexts"));
        }
        return couple;
    }

    private static boolean isTypeAcceptableForHint(@Nullable JSType type) {
        return type != null && !(type instanceof JSTypeofTypeImpl) && !(type instanceof JSCompositeTypeImpl);
    }

    private static boolean isPredefined(PsiElement element) {
        PsiFile containingFile = element != null ? element.getContainingFile() : null;
        return containingFile != null && JSResolveUtil.isFromPredefinedFile(containingFile);
    }

    @Nullable
    private static String getPackageLocationString(@NotNull JSElementBase elt) {
        JSQualifiedName namespace;
        PsiElement parent;
        if (elt == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elt", "com/intellij/lang/javascript/completion/JSLookupUtilImpl", "getPackageLocationString"));
        }
        PsiElement psiElement = parent = elt instanceof JSQualifiedNamedElement ? JSResolveUtil.findParent((PsiElement)((JSQualifiedNamedElement)elt)) : null;
        if ((parent instanceof JSPackageStatement || parent instanceof JSFile || elt instanceof XmlBackedJSClass || elt.isNamespaceExplicitlyDeclared()) && (namespace = elt.getNamespace()) != null) {
            return " (" + namespace.getQualifiedName() + ")";
        }
        if (parent instanceof JSFile) {
            return JSLookupUtilImpl.getLocationStringFromPresentation((NavigationItem)((JSQualifiedNamedElement)elt));
        }
        return null;
    }

    public static Icon getIcon(PsiElement element, boolean ecma) {
        Icon browserIcon;
        Icon originalIcon;
        Icon icon = element instanceof JSElement ? element.getIcon(1) : (originalIcon = element instanceof XmlElement ? JSIconProvider.HTML_TAG_ICON : JSLookupUtilImpl.getEmptyIcon());
        if (ecma) {
            return originalIcon;
        }
        if (!(originalIcon instanceof RowIcon)) {
            RowIcon newIcon = new RowIcon(2);
            newIcon.setIcon(originalIcon, 0);
            Icon browserIcon2 = JSLookupUtilImpl.getBrowserIcon(element);
            newIcon.setIcon(browserIcon2, 1);
            return newIcon;
        }
        RowIcon newIcon = (RowIcon)originalIcon;
        if (newIcon.getIconCount() > 1 && (browserIcon = JSLookupUtilImpl.getBrowserIcon(element)) != JSLookupUtilImpl.getEmptyIcon()) {
            newIcon.setIcon(browserIcon, 1);
        }
        return newIcon;
    }

    @NotNull
    public static Icon getBrowserIcon(PsiElement element) {
        JSDocComment docComment;
        if (JSLookupUtilImpl.isPredefined(element) && (docComment = JSStubBasedPsiTreeUtil.findDocComment(element)) != null) {
            JSDocComment.BrowserFamily browserFamily = docComment.getBrowserFamily();
            switch (browserFamily) {
                case GECKO: {
                    Icon icon = AllIcons.Xml.Browsers.Firefox16;
                    if (icon == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/completion/JSLookupUtilImpl", "getBrowserIcon"));
                    }
                    return icon;
                }
                case IE: {
                    Icon icon = AllIcons.Xml.Browsers.Explorer16;
                    if (icon == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/completion/JSLookupUtilImpl", "getBrowserIcon"));
                    }
                    return icon;
                }
                case OPERA: {
                    Icon icon = AllIcons.Xml.Browsers.Opera16;
                    if (icon == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/completion/JSLookupUtilImpl", "getBrowserIcon"));
                    }
                    return icon;
                }
            }
        }
        Icon icon = JSLookupUtilImpl.getEmptyIcon();
        if (icon == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/completion/JSLookupUtilImpl", "getBrowserIcon"));
        }
        return icon;
    }

    @Nullable
    public static String getFunctionTailText(JSFunctionItem function, boolean withLocation, @Nullable JSTypeSubstitutor typeSubstitutor) {
        if (!function.isGetProperty() && !function.isSetProperty()) {
            String packageLocationString;
            JSParameterItem[] parameters;
            StringBuilder result = new StringBuilder();
            result.append("(");
            for (JSParameterItem parameter : parameters = function.getParameters()) {
                if (result.length() > 1) {
                    result.append(", ");
                }
                result.append(JSParameterInfoHandler.getSignatureForParameter(parameter, typeSubstitutor));
            }
            result.append(")");
            if (withLocation && (packageLocationString = JSLookupUtilImpl.getPackageLocationString((JSElementBase)function)) != null) {
                result.append(packageLocationString);
            }
            return result.toString();
        }
        return null;
    }

    private static String getLocationStringFromPresentation(NavigationItem item) {
        String locationString;
        ItemPresentation presentation = item.getPresentation();
        if (presentation != null && (locationString = presentation.getLocationString()) != null) {
            return " " + locationString;
        }
        return "";
    }

    public static boolean willCreateLookupElement(@NotNull JSLookupPriority priority) {
        if (priority == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "priority", "com/intellij/lang/javascript/completion/JSLookupUtilImpl", "willCreateLookupElement"));
        }
        return priority.compareTo(MY_LAST_VALUE_WITHOUT_PRIORITY) > 0 || !JSCompletionContributor.getInstance().isDoingSmartCodeCompleteAction();
    }

    public static String getShortName(String qName) {
        JSResolveUtil.GenericSignature signature = JSResolveUtil.extractGenericSignature(qName);
        String textToRender = signature != null ? "Vector.<" + JSLookupUtilImpl.getShortName(signature.genericType) + ">" : (!StringUtil.containsAnyChar((String)qName, (String)"<[(={") ? qName.substring(qName.lastIndexOf(46) + 1) : qName);
        return textToRender;
    }

    @NotNull
    public static LookupElementBuilder createLookupElement(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/completion/JSLookupUtilImpl", "createLookupElement"));
        }
        Couple<String> typeAndTail = JSLookupUtilImpl.getTypeAndTailTexts(element, null);
        LookupElementBuilder lookupElementBuilder = LookupElementBuilder.create((PsiNamedElement)((PsiNamedElement)element)).withIcon(JSLookupUtilImpl.getIcon(element, false)).withTypeText((String)typeAndTail.first).withStrikeoutness(JSDocumentationUtils.isDeprecated(element)).withBoldness(true).withTailText((String)typeAndTail.second, false);
        if (lookupElementBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/completion/JSLookupUtilImpl", "createLookupElement"));
        }
        return lookupElementBuilder;
    }

    public static Icon getEmptyIcon() {
        return IconHolder.ourEmptyIcon;
    }

    @Nullable
    public static LookupItem<Object> createPrioritizedLookupItem(@Nullable PsiElement value, @NotNull String name, JSLookupPriority priority, boolean fromClass, boolean ecma) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/lang/javascript/completion/JSLookupUtilImpl", "createPrioritizedLookupItem"));
        }
        return JSLookupUtilImpl.createPrioritizedLookupItem(value, name, priority, fromClass, ecma, null);
    }

    @Nullable
    public static LookupItem<Object> createPrioritizedLookupItem(final @Nullable PsiElement value, @NotNull String name, final @NotNull JSLookupPriority priority, boolean fromClass, final boolean ecma, final @Nullable JSTypeSubstitutor typeSubstitutor) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/lang/javascript/completion/JSLookupUtilImpl", "createPrioritizedLookupItem"));
        }
        if (priority == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "priority", "com/intellij/lang/javascript/completion/JSLookupUtilImpl", "createPrioritizedLookupItem"));
        }
        if (JSLookupUtilImpl.willCreateLookupElement(priority)) {
            ProgressManager.checkCanceled();
            LookupItem<Object> item = new LookupItem<Object>(value != null ? value : name, name){

                public void renderElement(LookupElementPresentation presentation) {
                    presentation.setItemText(this.getPresentableText());
                    if (priority.compareTo(JSLookupPriority.MAX_PRIORITY) >= 0 || presentation.isReal()) {
                        presentation.setIcon(JSLookupUtilImpl.getIcon(value, ecma));
                        presentation.setStrikeout(JSDocumentationUtils.isDeprecated(value));
                        presentation.setItemTextBold(this.isBold());
                        if (value != null) {
                            Couple<String> typeAndTail = JSLookupUtilImpl.getTypeAndTailTexts(value, typeSubstitutor);
                            presentation.setTypeText((String)typeAndTail.first);
                            presentation.setTailText((String)typeAndTail.second, false);
                        }
                    }
                }

                public void handleInsert(InsertionContext context) {
                    Object object = super.getObject();
                    if (!(object instanceof PsiElement)) {
                        super.handleInsert(context);
                        return;
                    }
                    PsiElement element = (PsiElement)object;
                    String qName = element instanceof JSQualifiedNamedElement ? ((JSQualifiedNamedElement)element).getQualifiedName() : null;
                    PsiFile file = context.getFile();
                    boolean doQualify = false;
                    String packageName = null;
                    if (qName != null && (packageName = StringUtil.getPackageName((String)qName)).length() > 0 && this.getAttribute(FORCE_QUALIFY) != null) {
                        doQualify = true;
                    }
                    PsiDocumentManager.getInstance((Project)context.getProject()).commitAllDocuments();
                    super.handleInsert(context);
                    if (doQualify) {
                        Editor editor = context.getEditor();
                        PsiDocumentManager.getInstance((Project)context.getProject()).commitDocument(editor.getDocument());
                        PsiReference ref = file.findReferenceAt(editor.getCaretModel().getOffset() - 1);
                        if (ref != null) {
                            TextRange refRange = ref.getRangeInElement();
                            TextRange elementRange = ref.getElement().getTextRange();
                            editor.getDocument().insertString(elementRange.getStartOffset() + refRange.getStartOffset(), (CharSequence)(packageName + "."));
                        }
                    }
                }
            };
            item.setPresentableText(name);
            if (fromClass) {
                item.setBold();
            }
            JSCompletionUtil.setJSLookupPriority(item, priority);
            return item;
        }
        return null;
    }

    private static class IconHolder {
        private static final Icon ourEmptyIcon = EmptyIcon.create((Icon)PlatformIcons.CLASS_ICON);

        private IconHolder() {
        }
    }
}

