/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.flow.psi;

import com.intellij.lang.PsiBuilder;
import com.intellij.lang.ecmascript6.parsing.ES6FunctionParser;
import com.intellij.lang.ecmascript6.parsing.ES6Parser;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.JSKeywordSets;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.ecmascript6.parsing.TypeScriptPsiTypeParser;
import com.intellij.lang.javascript.flow.FlowJSElementTypes;
import com.intellij.lang.javascript.parsing.modifiers.JSModifiersStructure;
import com.intellij.lang.javascript.parsing.modifiers.JSModifiersStructureLeaf;
import com.intellij.lang.javascript.parsing.modifiers.JSOneOfModifiersStructure;
import com.intellij.lang.javascript.parsing.modifiers.JSOrderedModifiersStructure;
import com.intellij.lang.javascript.types.TypeScriptFunctionSignatureElementType;
import com.intellij.lang.typescript.TypeScriptElementTypes;
import com.intellij.openapi.util.Key;
import com.intellij.psi.tree.IElementType;
import org.jetbrains.annotations.NotNull;

public class FlowJSPsiTypeParser<T extends ES6Parser<?, ?, ?, ?>>
extends TypeScriptPsiTypeParser<T> {
    static final Key<Boolean> FORCED_TYPE_KEY = Key.create((String)"js.parser.forced.type");
    private static final JSModifiersStructure TYPE_MEMBER_MODIFIERS = new JSOrderedModifiersStructure(new JSModifiersStructureLeaf(JSTokenTypes.STATIC_KEYWORD), new JSOneOfModifiersStructure(JSTokenTypes.PLUS, JSTokenTypes.MINUS));

    public FlowJSPsiTypeParser(T parser) {
        super(parser);
    }

    @Override
    protected boolean parseUnionOrIntersectionComponent(boolean functionTypeAllowed) {
        return this.parseDistinctType(functionTypeAllowed);
    }

    @Override
    protected boolean parseDistinctType(boolean functionTypeAllowed) {
        IElementType firstToken = this.builder.getTokenType();
        if (firstToken == JSTokenTypes.QUEST) {
            PsiBuilder.Marker marker = this.builder.mark();
            this.builder.advanceLexer();
            this.parseDistinctType(true);
            marker.done(FlowJSElementTypes.MAYBE_TYPE);
            return true;
        }
        if (firstToken == JSTokenTypes.MULT) {
            PsiBuilder.Marker marker = this.builder.mark();
            this.builder.advanceLexer();
            marker.done(TypeScriptElementTypes.SINGLE_TYPE);
            return true;
        }
        if (firstToken == JSTokenTypes.FUNCTION_KEYWORD) {
            return this.parserSingleType();
        }
        if (firstToken == JSTokenTypes.LBRACE_OR) {
            return this.parseObjectType(JSTokenTypes.OR_RBRACE, "javascript.parser.message.missing.or_rbrace");
        }
        return super.parseDistinctType(true);
    }

    @Override
    public boolean parseTypeMember() {
        PsiBuilder.Marker marker = this.builder.mark();
        if (JSTokenTypes.GET_SET.contains(this.builder.getTokenType()) && JSKeywordSets.IDENTIFIER_NAMES.contains(this.builder.lookAhead(1))) {
            this.builder.advanceLexer();
        }
        ((ES6Parser)this.myJavaScriptParser).parseModifiers(TYPE_MEMBER_MODIFIERS, true, AFTER_TYPE_MEMBER_MODIFIERS_PREDICATE);
        return super.parseTypeMember(marker);
    }

    @Override
    public boolean isIndexSignatureProperty() {
        return this.builder.getTokenType() == JSTokenTypes.LBRACKET;
    }

    @Override
    public boolean parseIndexSignatureNoMarker(PsiBuilder.Marker marker, boolean checkSemicolon) {
        return FlowJSPsiTypeParser.parseIndexSignatureNoMarker(marker, this.builder, (ES6Parser)this.myJavaScriptParser, checkSemicolon, false);
    }

    @Override
    @NotNull
    protected IElementType getFunctionSignatureElementType() {
        TypeScriptFunctionSignatureElementType typeScriptFunctionSignatureElementType = FlowJSElementTypes.FUNCTION_SIGNATURE;
        if (typeScriptFunctionSignatureElementType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/flow/psi/FlowJSPsiTypeParser", "getFunctionSignatureElementType"));
        }
        return typeScriptFunctionSignatureElementType;
    }

    @Override
    public boolean tryParseType() {
        if (Boolean.TRUE.equals(this.builder.getUserData(FORCED_TYPE_KEY)) && this.builder.getTokenType() != JSTokenTypes.COLON) {
            this.builder.error(JSBundle.message((String)"javascript.parser.message.expected.colon", (Object[])new Object[0]));
        }
        return super.tryParseType();
    }

    @Override
    protected boolean parseTypeParameter() {
        PsiBuilder.Marker typeParameter = this.builder.mark();
        if (this.builder.getTokenType() == JSTokenTypes.PLUS || this.builder.getTokenType() == JSTokenTypes.MINUS) {
            this.builder.advanceLexer();
        }
        if (!this.isIdentifierToken(this.builder.getTokenType())) {
            this.builder.error(JSBundle.message((String)"javascript.parser.message.expected.identifier", (Object[])new Object[0]));
            typeParameter.drop();
            return false;
        }
        this.builder.advanceLexer();
        if (this.builder.getTokenType() == JSTokenTypes.EQ) {
            this.builder.advanceLexer();
            this.parseType();
        } else if (this.builder.getTokenType() == JSTokenTypes.COLON) {
            this.builder.advanceLexer();
            this.parseType();
            if (this.builder.getTokenType() == JSTokenTypes.EQ) {
                this.builder.advanceLexer();
                this.parseType();
            }
        }
        typeParameter.done(TypeScriptElementTypes.TYPE_PARAMETER);
        return true;
    }

    @Override
    protected boolean allowLastCommaInTupleType() {
        return true;
    }

    @Override
    protected boolean parseFunctionParameterList() {
        if (!this.tryParseTypeParameterList()) {
            return true;
        }
        if (this.builder.getTokenType() != JSTokenTypes.LPAR) {
            this.builder.error(JSBundle.message((String)"javascript.parser.message.expected.lparen", (Object[])new Object[0]));
            PsiBuilder.Marker parameterList = this.builder.mark();
            parameterList.done(((ES6FunctionParser)((ES6Parser)this.myJavaScriptParser).getFunctionParser()).getParameterListElementType());
            return true;
        }
        PsiBuilder.Marker parameterList = this.builder.mark();
        this.builder.advanceLexer();
        boolean result = true;
        boolean first = true;
        while (this.builder.getTokenType() != JSTokenTypes.RPAR) {
            if (first) {
                first = false;
            } else if (this.builder.getTokenType() == JSTokenTypes.COMMA) {
                this.builder.advanceLexer();
                if (this.builder.getTokenType() == JSTokenTypes.RPAR && ((ES6FunctionParser)((ES6Parser)this.myJavaScriptParser).getFunctionParser()).allowLastCommaInParameterAndArgumentList()) {
                    break;
                }
            } else {
                this.builder.error(JSBundle.message((String)"javascript.parser.message.expected.comma.or.rparen", (Object[])new Object[0]));
                result = false;
                break;
            }
            PsiBuilder.Marker parameter = this.builder.mark();
            if (this.builder.getTokenType() == JSTokenTypes.DOT_DOT_DOT) {
                this.builder.advanceLexer();
            }
            if (JSKeywordSets.IDENTIFIER_NAMES.contains(this.builder.getTokenType()) && this.builder.lookAhead(1) == JSTokenTypes.COLON) {
                this.builder.advanceLexer();
                this.builder.advanceLexer();
            }
            ((ES6FunctionParser)((ES6Parser)this.myJavaScriptParser).getFunctionParser()).parseParameterOptionalMark();
            result &= this.parseType();
            parameter.done(((ES6FunctionParser)((ES6Parser)this.myJavaScriptParser).getFunctionParser()).getParameterType());
        }
        if (this.builder.getTokenType() == JSTokenTypes.RPAR) {
            this.builder.advanceLexer();
        }
        parameterList.done(((ES6FunctionParser)((ES6Parser)this.myJavaScriptParser).getFunctionParser()).getParameterListElementType());
        return result;
    }
}

