/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.formatter.blocks.alignment;

import com.intellij.formatting.Alignment;
import com.intellij.lang.ASTNode;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.formatter.blocks.alignment.ASTNodeBasedAlignmentFactory;
import com.intellij.psi.PsiComment;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.webcore.formatter.comments.LineCommentLineDataBuilder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LineCommentAlignmentFactory
implements ASTNodeBasedAlignmentFactory {
    @Nullable
    private ASTNode myLastProcessed;
    private int myBlockIndent;
    @Nullable
    private Alignment myCurrAlignment;
    private CommonCodeStyleSettings mySettings;

    public LineCommentAlignmentFactory(@NotNull CommonCodeStyleSettings settings) {
        if (settings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "com/intellij/lang/javascript/formatter/blocks/alignment/LineCommentAlignmentFactory", "<init>"));
        }
        this.myBlockIndent = -1;
        this.mySettings = settings;
    }

    @Override
    public Alignment getAlignment(@NotNull ASTNode commentNode) {
        ASTNode prevNode;
        if (commentNode == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "commentNode", "com/intellij/lang/javascript/formatter/blocks/alignment/LineCommentAlignmentFactory", "getAlignment"));
        }
        assert (commentNode.getElementType() == JSTokenTypes.END_OF_LINE_COMMENT);
        LineCommentLineDataBuilder lineDataBuilder = new LineCommentLineDataBuilder((PsiComment)commentNode.getPsi(), JSTokenTypes.END_OF_LINE_COMMENT, this.mySettings, null);
        if (this.myLastProcessed != null && (prevNode = commentNode.getTreePrev()) != null && prevNode.getElementType() == JSTokenTypes.WHITE_SPACE && LineCommentLineDataBuilder.countLineBreaks((ASTNode)prevNode) == 1 && lineDataBuilder.calcBlockLineIndent(commentNode) == this.myBlockIndent && (prevNode = prevNode.getTreePrev()) == this.myLastProcessed) {
            this.myLastProcessed = commentNode;
            return this.myCurrAlignment;
        }
        this.myBlockIndent = lineDataBuilder.calcBlockLineIndent(commentNode);
        this.myCurrAlignment = lineDataBuilder.isAfterNonEmptyLine(commentNode) ? Alignment.createAlignment() : null;
        this.myLastProcessed = commentNode;
        return this.myCurrAlignment;
    }
}

