/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.frameworks.amd;

import com.intellij.ide.highlighter.HtmlFileType;
import com.intellij.lang.javascript.frameworks.amd.JSAmdBaseUrlIndex;
import com.intellij.lang.javascript.frameworks.amd.JSAmdPsiUtil;
import com.intellij.lang.javascript.frameworks.amd.JSAmdRequirePathIndex;
import com.intellij.lang.javascript.index.JSCustomSingleEntriesIndex;
import com.intellij.lang.javascript.psi.JSArgumentList;
import com.intellij.lang.javascript.psi.JSArrayLiteralExpression;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFunctionExpression;
import com.intellij.lang.javascript.psi.JSImplicitElementProvider;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.lang.javascript.psi.JSParameter;
import com.intellij.lang.javascript.psi.JSQualifiedName;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.ecmal4.JSQualifiedNamedElement;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.stubs.JSElementIndexingData;
import com.intellij.lang.javascript.psi.stubs.JSImplicitElement;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.FileIndexFacade;
import com.intellij.openapi.util.Getter;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.impl.include.FileIncludeManager;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.stubs.StubIndex;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.PathUtil;
import com.intellij.util.Processor;
import com.intellij.util.indexing.FileBasedIndex;
import gnu.trove.THashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSAmdUtil {
    public static final String REQUIRE_DATA_MAIN_KEY = "js.require.data.main";
    public static final String REQUIRE_BASE_URL_KEY = "jsRequireBaseUrl";
    public static final String REQUIRE_PATH_ALIASES = "jsRequirePathAliases";
    private static final Key<CachedValue<AmdLoaderCallOnPointers>> IS_INSIDE_AMD_DEFINE = Key.create((String)"Javascript.Modules.Amd.Inside.Define");

    @NotNull
    public static Collection<PsiDirectory> getBaseDirectories(@NotNull PsiElement context) {
        String componentName;
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/lang/javascript/frameworks/amd/JSAmdUtil", "getBaseDirectories"));
        }
        PsiFile psiFile = context.getContainingFile().getOriginalFile();
        ArrayList<PsiDirectory> results = new ArrayList<PsiDirectory>();
        final VirtualFile contextVirtualFile = psiFile.getVirtualFile();
        final PsiManager manager = psiFile.getManager();
        GlobalSearchScope scope = JSResolveUtil.getResolveScope((PsiElement)psiFile);
        if (contextVirtualFile == null) {
            List<PsiDirectory> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/frameworks/amd/JSAmdUtil", "getBaseDirectories"));
            }
            return list;
        }
        final Ref candidateBasePaths = Ref.create(new ArrayList());
        final Ref closestHtmlFileDir = Ref.create(null);
        FileBasedIndex.getInstance().processValues(JSCustomSingleEntriesIndex.INDEX_ID, (Object)REQUIRE_DATA_MAIN_KEY, null, (FileBasedIndex.ValueProcessor)new FileBasedIndex.ValueProcessor<String>(){

            public boolean process(VirtualFile file, String value) {
                VirtualFile closest = (VirtualFile)closestHtmlFileDir.get();
                boolean search = true;
                boolean overwriteIfFound = false;
                if (closest != null) {
                    int compare = JSAmdUtil.compareClosenessesToContext(file, closest, contextVirtualFile);
                    if (compare < 0) {
                        overwriteIfFound = true;
                    } else if (compare > 0) {
                        search = false;
                    }
                }
                if (search) {
                    PsiDirectory directory;
                    VirtualFile path;
                    if (!value.endsWith(".js")) {
                        value = value + ".js";
                    }
                    if ((path = file.getParent().findFileByRelativePath(value)) != null && (directory = manager.findDirectory(path.getParent())) != null) {
                        closestHtmlFileDir.set((Object)file);
                        if (overwriteIfFound) {
                            ((ArrayList)candidateBasePaths.get()).clear();
                        }
                        ((ArrayList)candidateBasePaths.get()).add(directory);
                    }
                }
                return true;
            }
        }, scope);
        THashMap baseUrls = new THashMap();
        StubIndex.getInstance().processElements(JSAmdBaseUrlIndex.KEY, (Object)REQUIRE_BASE_URL_KEY, context.getProject(), scope, JSImplicitElementProvider.class, arg_0 -> JSAmdUtil.lambda$getBaseDirectories$0((Map)baseUrls, arg_0));
        for (Map.Entry entry : baseUrls.entrySet()) {
            VirtualFile[] includingFiles;
            VirtualFile file = (VirtualFile)entry.getKey();
            String value = (String)entry.getValue();
            VirtualFile closest = (VirtualFile)closestHtmlFileDir.get();
            boolean overwriteIfFound = false;
            if (closest != null) {
                int compare = JSAmdUtil.compareClosenessesToContext(file, closest, contextVirtualFile);
                if (compare < 0) {
                    overwriteIfFound = true;
                } else if (compare > 0) continue;
            }
            for (VirtualFile includingFile : includingFiles = FileIncludeManager.getManager((Project)context.getProject()).getIncludingFiles(file, false)) {
                PsiDirectory directory;
                VirtualFile baseDir;
                if (includingFile.getFileType() != HtmlFileType.INSTANCE || (baseDir = includingFile.getParent().findFileByRelativePath(value)) == null || (directory = manager.findDirectory(baseDir)) == null) continue;
                closestHtmlFileDir.set((Object)baseDir);
                if (overwriteIfFound) {
                    ((ArrayList)candidateBasePaths.get()).clear();
                    overwriteIfFound = false;
                }
                ((ArrayList)candidateBasePaths.get()).add(directory);
            }
        }
        results.addAll((Collection)candidateBasePaths.get());
        if (context instanceof JSLiteralExpression && ((JSLiteralExpression)context).isQuotedLiteral() && PathUtil.isValidFileName((String)(componentName = StringUtil.unquoteString((String)context.getText())))) {
            FileIndexFacade facade = FileIndexFacade.getInstance((Project)psiFile.getProject());
            for (VirtualFile parentDir = contextVirtualFile.getParent(); parentDir != null && facade.isInContent(parentDir); parentDir = parentDir.getParent()) {
                PsiDirectory bowerDirectory;
                VirtualFile dir = parentDir.findChild("bower_components");
                if (dir == null || (dir = dir.findChild(componentName)) == null || (bowerDirectory = manager.findDirectory(dir)) == null) continue;
                results.add(bowerDirectory);
                break;
            }
        }
        ArrayList<PsiDirectory> arrayList = results;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/frameworks/amd/JSAmdUtil", "getBaseDirectories"));
        }
        return arrayList;
    }

    static int compareClosenessesToContext(@NotNull VirtualFile dir1, @NotNull VirtualFile dir2, @NotNull VirtualFile context) {
        if (dir1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dir1", "com/intellij/lang/javascript/frameworks/amd/JSAmdUtil", "compareClosenessesToContext"));
        }
        if (dir2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dir2", "com/intellij/lang/javascript/frameworks/amd/JSAmdUtil", "compareClosenessesToContext"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/lang/javascript/frameworks/amd/JSAmdUtil", "compareClosenessesToContext"));
        }
        VirtualFile ancestor1 = VfsUtilCore.getCommonAncestor((VirtualFile)dir1, (VirtualFile)context);
        VirtualFile ancestor2 = VfsUtilCore.getCommonAncestor((VirtualFile)dir2, (VirtualFile)context);
        if (ancestor1 == null) {
            return ancestor2 == null ? 0 : 1;
        }
        if (ancestor2 == null) {
            return -1;
        }
        return VfsUtilCore.isAncestor((VirtualFile)ancestor1, (VirtualFile)ancestor2, (boolean)true) ? 1 : (VfsUtilCore.isAncestor((VirtualFile)ancestor2, (VirtualFile)ancestor1, (boolean)true) ? -1 : 0);
    }

    public static String correctPathWithAliases(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/frameworks/amd/JSAmdUtil", "correctPathWithAliases"));
        }
        VirtualFile containingFile = element.getContainingFile().getVirtualFile();
        GlobalSearchScope scope = JSResolveUtil.getResolveScope(element);
        String[] exactAlias = new String[1];
        HashSet relativeVariants = new HashSet();
        StubIndex.getInstance().processElements(JSAmdRequirePathIndex.KEY, (Object)REQUIRE_PATH_ALIASES, element.getProject(), scope, JSImplicitElementProvider.class, provider -> {
            Collection elements;
            JSElementIndexingData data = provider.getIndexingData();
            Collection collection = elements = data != null ? data.getImplicitElements() : null;
            if (elements != null) {
                VirtualFile file = provider.getContainingFile().getVirtualFile();
                for (JSImplicitElement element1 : elements) {
                    if (!REQUIRE_PATH_ALIASES.equals(element1.getName()) || !"arp".equals(element1.getUserString())) continue;
                    String value = element1.getTypeString();
                    if (containingFile.equals(file)) {
                        exactAlias[0] = value;
                        return false;
                    }
                    String relative = VfsUtil.getRelativePath((VirtualFile)containingFile, (VirtualFile)file, (char)'/');
                    if (relative != null) {
                        if (".".equals(relative) || "/".equals(relative) || relative.isEmpty()) {
                            relativeVariants.add(value);
                        } else {
                            relativeVariants.add(value + "/" + relative);
                        }
                    }
                    return true;
                }
            }
            return true;
        });
        if (exactAlias[0] != null) {
            return exactAlias[0];
        }
        if (!relativeVariants.isEmpty()) {
            String variant = (String)relativeVariants.iterator().next();
            if (relativeVariants.size() > 1) {
                ArrayList list = new ArrayList(relativeVariants);
                Collections.sort(list, (o1, o2) -> new Integer(o1.split("/").length).compareTo(o2.split("/").length));
                variant = (String)list.get(0);
            }
            return variant;
        }
        return null;
    }

    @NotNull
    public static Pair<Boolean, String> isFromAmdModuleReturn(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/frameworks/amd/JSAmdUtil", "isFromAmdModuleReturn"));
        }
        if (!(element instanceof JSQualifiedNamedElement)) {
            Pair pair = Pair.create((Object)false, null);
            if (pair == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/frameworks/amd/JSAmdUtil", "isFromAmdModuleReturn"));
            }
            return pair;
        }
        JSCallExpression parentDefine = (JSCallExpression)PsiTreeUtil.findFirstContext((PsiElement)element, (boolean)false, element1 -> element1 instanceof JSCallExpression && ((JSCallExpression)element1).isDefineCall());
        JSQualifiedName namespace = ((JSQualifiedNamedElement)element).getNamespace();
        if (parentDefine != null && namespace != null) {
            String name = StringUtil.unquoteString((String)namespace.getName());
            if ("exports".equals(name)) {
                Pair pair = Pair.create((Object)true, null);
                if (pair == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/frameworks/amd/JSAmdUtil", "isFromAmdModuleReturn"));
                }
                return pair;
            }
            String moduleNamespace = JSAmdPsiUtil.getNamespaceFromExplicitModuleName(parentDefine);
            if (name.equals(moduleNamespace)) {
                Pair pair = Pair.create((Object)true, (Object)JSAmdPsiUtil.getExplicitModuleName(parentDefine));
                if (pair == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/frameworks/amd/JSAmdUtil", "isFromAmdModuleReturn"));
                }
                return pair;
            }
        }
        Pair pair = Pair.create((Object)true, null);
        if (pair == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/frameworks/amd/JSAmdUtil", "isFromAmdModuleReturn"));
        }
        return pair;
    }

    @Nullable
    public static AmdLoaderCall findWrappingDefineOrRequireCallback(@NotNull PsiElement element, boolean onlyDefine) {
        boolean isDefine;
        JSReferenceExpression methodExpression;
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/frameworks/amd/JSAmdUtil", "findWrappingDefineOrRequireCallback"));
        }
        PsiElement possibleCallback = PsiTreeUtil.findFirstParent((PsiElement)element, element1 -> element1 instanceof JSFunctionExpression);
        if (possibleCallback == null) {
            return null;
        }
        PsiElement parent = possibleCallback.getParent();
        Getter goUp = () -> {
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/frameworks/amd/JSAmdUtil", "lambda$findWrappingDefineOrRequireCallback$5"));
            }
            if (parent instanceof PsiFile || parent == null) {
                return null;
            }
            return JSAmdUtil.findWrappingDefineOrRequireCallback(possibleCallback == element ? parent : possibleCallback, false);
        };
        JSArgumentList argumentList = (JSArgumentList)ObjectUtils.tryCast((Object)parent, JSArgumentList.class);
        if (argumentList == null) {
            return (AmdLoaderCall)goUp.get();
        }
        JSExpression[] arguments = ((JSArgumentList)parent).getArguments();
        AmdLoaderCallParametersChecker checker = new AmdLoaderCallParametersChecker(arguments);
        if (!checker.isCorrect()) {
            return (AmdLoaderCall)goUp.get();
        }
        JSCallExpression possibleCall = (JSCallExpression)ObjectUtils.tryCast((Object)parent.getParent(), JSCallExpression.class);
        if (possibleCall != null && (methodExpression = (JSReferenceExpression)ObjectUtils.tryCast((Object)possibleCall.getMethodExpression(), JSReferenceExpression.class)) != null && methodExpression.getQualifier() == null && ((isDefine = "define".equals(methodExpression.getReferenceName())) || !onlyDefine && "require".equals(methodExpression.getReferenceName()))) {
            if (!(isDefine || checker.getArray() != null && checker.getRequireParameter() == null)) {
                return (AmdLoaderCall)goUp.get();
            }
            return new AmdLoaderCall(possibleCall, checker.getCallbackExpression(), isDefine, checker.getArray(), checker.getRequireParameter());
        }
        return (AmdLoaderCall)goUp.get();
    }

    public static AmdLoaderCallOnPointers getCachedWrappingAmdDefinition(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/frameworks/amd/JSAmdUtil", "getCachedWrappingAmdDefinition"));
        }
        CachedValueProvider provider = () -> {
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/frameworks/amd/JSAmdUtil", "lambda$getCachedWrappingAmdDefinition$6"));
            }
            AmdLoaderCall call = JSAmdUtil.findWrappingDefineOrRequireCallback(element, false);
            return new CachedValueProvider.Result((Object)(call == null ? null : call.wrapInPointers()), new Object[]{element.getContainingFile()});
        };
        return (AmdLoaderCallOnPointers)CachedValuesManager.getManager((Project)element.getProject()).getCachedValue((UserDataHolder)element, IS_INSIDE_AMD_DEFINE, provider, false);
    }

    private static /* synthetic */ boolean lambda$getBaseDirectories$0(Map baseUrls, JSImplicitElementProvider provider) {
        Collection elements;
        JSElementIndexingData data = provider.getIndexingData();
        Collection collection = elements = data != null ? data.getImplicitElements() : null;
        if (elements != null) {
            for (JSImplicitElement element : elements) {
                if (!REQUIRE_BASE_URL_KEY.equals(element.getName()) || !"abu".equals(element.getUserString())) continue;
                baseUrls.put(provider.getContainingFile().getVirtualFile(), element.getTypeString());
            }
        }
        return true;
    }

    public static interface AmdLoaderCallOnPointers {
        public AmdLoaderCall toCall();
    }

    public static class AmdLoaderCall {
        private final JSCallExpression myCallExpression;
        private final JSFunctionExpression myCallBackExpression;
        private final boolean myDefinesModule;
        @Nullable
        private final JSArrayLiteralExpression myModulesArray;
        @Nullable
        private final JSParameter myRequireSugaredParameter;

        public AmdLoaderCall(JSCallExpression expression, JSFunctionExpression backExpression, boolean definesModule, @Nullable JSArrayLiteralExpression modulesArray, @Nullable JSParameter requireSugaredParameter) {
            this.myCallExpression = expression;
            this.myCallBackExpression = backExpression;
            this.myDefinesModule = definesModule;
            this.myModulesArray = modulesArray;
            this.myRequireSugaredParameter = requireSugaredParameter;
        }

        public boolean isValid() {
            return this.myCallExpression != null && this.myCallBackExpression != null;
        }

        public JSCallExpression getCallExpression() {
            return this.myCallExpression;
        }

        public JSFunctionExpression getCallBackExpression() {
            return this.myCallBackExpression;
        }

        public boolean isDefinesModule() {
            return this.myDefinesModule;
        }

        @Nullable
        public JSArrayLiteralExpression getModulesArray() {
            return this.myModulesArray;
        }

        public JSParameter getRequireSugaredParameter() {
            return this.myRequireSugaredParameter;
        }

        public AmdLoaderCallOnPointers wrapInPointers() {
            SmartPointerManager instance = SmartPointerManager.getInstance((Project)this.myCallExpression.getProject());
            return new PointerVersion(instance.createSmartPsiElementPointer((PsiElement)this.myCallExpression), instance.createSmartPsiElementPointer((PsiElement)this.myCallBackExpression), this.myDefinesModule, this.myModulesArray == null ? null : instance.createSmartPsiElementPointer((PsiElement)this.myModulesArray), this.myRequireSugaredParameter == null ? null : instance.createSmartPsiElementPointer((PsiElement)this.myRequireSugaredParameter));
        }

        private static class PointerVersion
        implements AmdLoaderCallOnPointers {
            @NotNull
            private final SmartPsiElementPointer<JSCallExpression> myCallPointer;
            @NotNull
            private final SmartPsiElementPointer<JSFunctionExpression> myCallbackPointer;
            private final boolean myDefinesModule;
            @Nullable
            private final SmartPsiElementPointer<JSArrayLiteralExpression> myArrayPointer;
            @Nullable
            private final SmartPsiElementPointer<JSParameter> myRequireSugaredPointer;

            private PointerVersion(@NotNull SmartPsiElementPointer<JSCallExpression> pointer, @NotNull SmartPsiElementPointer<JSFunctionExpression> callbackPointer, boolean module, @Nullable SmartPsiElementPointer<JSArrayLiteralExpression> arrayPointer, @Nullable SmartPsiElementPointer<JSParameter> sugaredPointer) {
                if (pointer == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pointer", "com/intellij/lang/javascript/frameworks/amd/JSAmdUtil$AmdLoaderCall$PointerVersion", "<init>"));
                }
                if (callbackPointer == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callbackPointer", "com/intellij/lang/javascript/frameworks/amd/JSAmdUtil$AmdLoaderCall$PointerVersion", "<init>"));
                }
                this.myCallPointer = pointer;
                this.myCallbackPointer = callbackPointer;
                this.myDefinesModule = module;
                this.myArrayPointer = arrayPointer;
                this.myRequireSugaredPointer = sugaredPointer;
            }

            @Override
            public AmdLoaderCall toCall() {
                return new AmdLoaderCall((JSCallExpression)this.myCallPointer.getElement(), (JSFunctionExpression)this.myCallbackPointer.getElement(), this.myDefinesModule, this.myArrayPointer == null ? null : (JSArrayLiteralExpression)this.myArrayPointer.getElement(), this.myRequireSugaredPointer == null ? null : (JSParameter)this.myRequireSugaredPointer.getElement());
            }
        }
    }

    public static class AmdLoaderCallParametersChecker {
        private boolean myIsCorrect;
        private JSArrayLiteralExpression myArray;
        private JSParameter myRequireParameter;
        private JSFunctionExpression myCallbackExpression;

        public AmdLoaderCallParametersChecker(JSExpression[] arguments) {
            Processor callBackChecker = expression -> {
                this.myCallbackExpression = (JSFunctionExpression)ObjectUtils.tryCast((Object)expression, JSFunctionExpression.class);
                if (this.myCallbackExpression == null) {
                    return false;
                }
                JSParameter[] parameters = this.myCallbackExpression.getParameterVariables();
                if (parameters.length > 0) {
                    this.myRequireParameter = parameters[0];
                }
                return true;
            };
            Processor moduleIdProcessor = expression -> {
                JSLiteralExpression moduleId = (JSLiteralExpression)ObjectUtils.tryCast((Object)expression, JSLiteralExpression.class);
                if (moduleId == null) {
                    return false;
                }
                return moduleId.isQuotedLiteral();
            };
            Processor<JSExpression> modulesArrayProcessor = new Processor<JSExpression>(){

                public boolean process(JSExpression expression) {
                    myArray = (JSArrayLiteralExpression)ObjectUtils.tryCast((Object)expression, JSArrayLiteralExpression.class);
                    return myArray != null && this.checkNumberOfParameters();
                }

                private boolean checkNumberOfParameters() {
                    return myCallbackExpression.getAttributeList() == null || myArray.getExpressions().length >= myCallbackExpression.getAttributeList().getAttributes().length;
                }
            };
            if (arguments.length == 1) {
                callBackChecker.process((Object)arguments[0]);
                this.myIsCorrect = this.myCallbackExpression != null;
                return;
            }
            if (arguments.length == 2) {
                if (!callBackChecker.process((Object)arguments[1])) {
                    return;
                }
                if (arguments[0] instanceof JSLiteralExpression) {
                    if (moduleIdProcessor.process((Object)arguments[0])) {
                        this.myIsCorrect = true;
                    }
                } else if (arguments[0] instanceof JSArrayLiteralExpression) {
                    this.myRequireParameter = null;
                    this.myIsCorrect = modulesArrayProcessor.process((Object)arguments[0]);
                }
            } else if (arguments.length == 3) {
                if (!callBackChecker.process((Object)arguments[2])) {
                    return;
                }
                if (!modulesArrayProcessor.process((Object)arguments[1])) {
                    return;
                }
                if (!moduleIdProcessor.process((Object)arguments[0])) {
                    return;
                }
                this.myIsCorrect = this.myCallbackExpression != null;
                this.myRequireParameter = null;
            }
        }

        public boolean isCorrect() {
            return this.myIsCorrect;
        }

        public JSArrayLiteralExpression getArray() {
            return this.myArray;
        }

        public JSParameter getRequireParameter() {
            return this.myRequireParameter;
        }

        public JSFunctionExpression getCallbackExpression() {
            return this.myCallbackExpression;
        }
    }
}

