/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.frameworks.commonjs;

import com.intellij.lang.javascript.JSStubElementTypes;
import com.intellij.lang.javascript.psi.JSAssignmentExpression;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSDefinitionExpression;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSExpressionStatement;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.lang.javascript.psi.JSQualifiedName;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptExportAssignment;
import com.intellij.lang.javascript.psi.impl.JSFileImpl;
import com.intellij.lang.javascript.psi.impl.JSTextReference;
import com.intellij.lang.javascript.psi.resolve.JSModuleReferenceContributor;
import com.intellij.lang.javascript.psi.types.JSRequireCallExpressionType;
import com.intellij.lang.javascript.psi.types.JSTypeImpl;
import com.intellij.lang.typescript.psi.TypeScriptPsiUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.stubs.StubElement;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CommonJSUtil {
    public static boolean calculateIsRequireCall(@NotNull JSCallExpression callExpression) {
        if (callExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callExpression", "com/intellij/lang/javascript/frameworks/commonjs/CommonJSUtil", "calculateIsRequireCall"));
        }
        JSReferenceExpression methodExpression = (JSReferenceExpression)ObjectUtils.tryCast((Object)callExpression.getMethodExpression(), JSReferenceExpression.class);
        return methodExpression != null && callExpression.getArguments().length == 1 && methodExpression.getQualifier() == null && "require".equals(methodExpression.getReferenceName());
    }

    @Nullable
    public static String getRequireCallModulePath(@NotNull JSCallExpression call) {
        if (call == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "call", "com/intellij/lang/javascript/frameworks/commonjs/CommonJSUtil", "getRequireCallModulePath"));
        }
        assert (call.isRequireCall());
        JSExpression[] arguments = call.getArguments();
        assert (arguments.length == 1);
        JSExpression argument = arguments[0];
        if (!(argument instanceof JSLiteralExpression) || !((JSLiteralExpression)argument).isQuotedLiteral()) {
            return null;
        }
        return StringUtil.unquoteString((String)argument.getText());
    }

    @Nullable
    public static String getNodeJsRedirectPath(PsiFile mainModule) {
        if (!(mainModule instanceof JSFileImpl)) {
            return null;
        }
        StubElement stub = ((JSFileImpl)mainModule).getStub();
        JSAssignmentExpression candidate = null;
        if (stub != null) {
            PsiElement[] assignments = stub.getChildrenByType(JSStubElementTypes.ASSIGNMENT_EXPRESSION, PsiElement.ARRAY_FACTORY);
            if (assignments.length == 1 && assignments[0] instanceof JSAssignmentExpression) {
                candidate = (JSAssignmentExpression)assignments[0];
            }
        } else {
            JSExpression expression;
            JSExpressionStatement[] exprStatements = (JSExpressionStatement[])((JSFileImpl)mainModule).findChildrenByClass(JSExpressionStatement.class);
            if (exprStatements.length == 1 && (expression = exprStatements[0].getExpression()) instanceof JSAssignmentExpression) {
                candidate = (JSAssignmentExpression)expression;
            }
        }
        if (candidate == null) {
            return null;
        }
        JSDefinitionExpression definitionExpression = candidate.getDefinitionExpression();
        if (definitionExpression == null || !"module.exports".equals(definitionExpression.getQualifiedName())) {
            return null;
        }
        JSType exportsType = ((JSFileImpl)mainModule).getExportsInnerAlias();
        if (!(exportsType instanceof JSRequireCallExpressionType)) {
            return null;
        }
        return ((JSRequireCallExpressionType)exportsType).getReferencedModule();
    }

    public static boolean isModuleType(JSType type) {
        return type instanceof JSTypeImpl && type.getTypeText(JSType.TypeTextFormat.SIMPLE).startsWith("module:");
    }

    public static Collection<JSFile> resolveReferencedElements(@NotNull PsiElement context, @NotNull String path) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/lang/javascript/frameworks/commonjs/CommonJSUtil", "resolveReferencedElements"));
        }
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/lang/javascript/frameworks/commonjs/CommonJSUtil", "resolveReferencedElements"));
        }
        return JSModuleReferenceContributor.resolveModules(context, path, true).stream().filter(el -> el instanceof JSFile).map(el -> (JSFile)el).collect(Collectors.toList());
    }

    public static boolean isExportNamespace(@Nullable JSQualifiedName qName) {
        return qName != null && "exports".equals(qName.getName()) && (qName.getParent() == null || "module".equals(qName.getParent().getName()) && qName.getParent().getParent() == null);
    }

    @NotNull
    public static Collection<PsiElement> findReferencedModulesIfRequireCall(@NotNull JSCallExpression callExpression) {
        if (callExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callExpression", "com/intellij/lang/javascript/frameworks/commonjs/CommonJSUtil", "findReferencedModulesIfRequireCall"));
        }
        if (!callExpression.isRequireCall()) {
            List list = ContainerUtil.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/frameworks/commonjs/CommonJSUtil", "findReferencedModulesIfRequireCall"));
            }
            return list;
        }
        JSExpression[] arguments = callExpression.getArguments();
        if (arguments.length > 0 && arguments[0] instanceof JSLiteralExpression) {
            PsiReference[] references = arguments[arguments.length - 1].getReferences();
            ArrayList results = ContainerUtil.newArrayList();
            for (PsiReference reference : references) {
                if (reference instanceof JSTextReference.JSDeclarationModuleReference) {
                    Collection<PsiElement> declarationModuleResults = CommonJSUtil.getResultsForDeclarationModuleReference(reference);
                    if (declarationModuleResults.isEmpty()) continue;
                    Collection<PsiElement> collection = declarationModuleResults;
                    if (collection == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/frameworks/commonjs/CommonJSUtil", "findReferencedModulesIfRequireCall"));
                    }
                    return collection;
                }
                results.addAll(JSModuleReferenceContributor.resolveModuleReference(reference));
            }
            ArrayList arrayList = results;
            if (arrayList == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/frameworks/commonjs/CommonJSUtil", "findReferencedModulesIfRequireCall"));
            }
            return arrayList;
        }
        List list = ContainerUtil.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/frameworks/commonjs/CommonJSUtil", "findReferencedModulesIfRequireCall"));
        }
        return list;
    }

    @NotNull
    public static Collection<PsiElement> getResultsForDeclarationModuleReference(@NotNull PsiReference reference) {
        if (reference == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reference", "com/intellij/lang/javascript/frameworks/commonjs/CommonJSUtil", "getResultsForDeclarationModuleReference"));
        }
        Collection<PsiElement> elements = JSModuleReferenceContributor.resolveModuleReference(reference);
        ArrayList results = ContainerUtil.newArrayList();
        for (PsiElement element : elements) {
            if (!TypeScriptPsiUtil.isTopLevelContainer(element)) continue;
            TypeScriptExportAssignment assignment = TypeScriptPsiUtil.findExportAssignment(element);
            results.add(assignment != null ? assignment : element);
        }
        ArrayList arrayList = results;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/frameworks/commonjs/CommonJSUtil", "getResultsForDeclarationModuleReference"));
        }
        return arrayList;
    }

    @Nullable
    public static PsiElement findReferencedModuleIfRequireCall(@NotNull JSCallExpression callExpression) {
        if (callExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callExpression", "com/intellij/lang/javascript/frameworks/commonjs/CommonJSUtil", "findReferencedModuleIfRequireCall"));
        }
        return (PsiElement)ContainerUtil.getFirstItem(CommonJSUtil.findReferencedModulesIfRequireCall(callExpression));
    }
}

