/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.frameworks.dojo;

import com.intellij.lang.javascript.index.FrameworkIndexingHandler;
import com.intellij.lang.javascript.index.JSSymbolUtil;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.lang.javascript.psi.JSQualifiedName;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.literal.JSLiteralImplicitElementProvider;
import com.intellij.lang.javascript.psi.stubs.JSElementIndexingData;
import com.intellij.lang.javascript.psi.stubs.JSImplicitElement;
import com.intellij.lang.javascript.psi.stubs.impl.JSImplicitElementImpl;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class DojoFrameworkIndexingHandler
extends FrameworkIndexingHandler {
    @NonNls
    static final String DOJO_NAME = "dojo";
    private static final String[] INTERESTED_METHOD_NAMES = new String[]{"declare"};

    @Override
    @NotNull
    public String[] interestedMethodNames() {
        if (INTERESTED_METHOD_NAMES == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/frameworks/dojo/DojoFrameworkIndexingHandler", "interestedMethodNames"));
        }
        return INTERESTED_METHOD_NAMES;
    }

    @Override
    public JSLiteralImplicitElementProvider createLiteralImplicitElementProvider(@NotNull String calledMethodName) {
        if (calledMethodName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "calledMethodName", "com/intellij/lang/javascript/frameworks/dojo/DojoFrameworkIndexingHandler", "createLiteralImplicitElementProvider"));
        }
        if ("declare".equals(calledMethodName)) {
            return new JSLiteralImplicitElementProvider(){

                @Override
                public void fillIndexingData(@NotNull JSLiteralExpression argument, @NotNull JSCallExpression callExpression, @NotNull JSElementIndexingData outIndexingData) {
                    JSQualifiedName qualifiedName;
                    JSExpression[] jsExpressions;
                    if (argument == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "argument", "com/intellij/lang/javascript/frameworks/dojo/DojoFrameworkIndexingHandler$1", "fillIndexingData"));
                    }
                    if (callExpression == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callExpression", "com/intellij/lang/javascript/frameworks/dojo/DojoFrameworkIndexingHandler$1", "fillIndexingData"));
                    }
                    if (outIndexingData == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "outIndexingData", "com/intellij/lang/javascript/frameworks/dojo/DojoFrameworkIndexingHandler$1", "fillIndexingData"));
                    }
                    JSReferenceExpression referenceExpression = (JSReferenceExpression)callExpression.getMethodExpression();
                    JSExpression qualifier = referenceExpression.getQualifier();
                    if ("declare".equals(referenceExpression.getReferencedName()) && qualifier != null && DojoFrameworkIndexingHandler.DOJO_NAME.equals(qualifier.getText()) && (jsExpressions = callExpression.getArguments()).length > 1 && jsExpressions[0] == argument && (qualifiedName = JSSymbolUtil.getLiteralValueAsQualifiedName(argument)) != null) {
                        String text;
                        JSImplicitElementImpl.Builder builder = new JSImplicitElementImpl.Builder(qualifiedName, (PsiElement)argument).setType(JSImplicitElement.Type.Class);
                        outIndexingData.addImplicitElement((JSImplicitElement)new JSImplicitElementImpl(builder));
                        if (jsExpressions[1] instanceof JSLiteralExpression && StringUtil.isQuotedString((String)(text = jsExpressions[1].getText()))) {
                            outIndexingData.addBaseType(qualifiedName.getQualifiedName(), StringUtil.stripQuotesAroundValue((String)text));
                        }
                    }
                }
            };
        }
        return super.createLiteralImplicitElementProvider(calledMethodName);
    }
}

