/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.frameworks.react;

import com.intellij.ide.IdeBundle;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.lang.javascript.psi.impl.JSLiteralExpressionImpl;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.editor.ElementColorProvider;
import com.intellij.psi.ElementManipulators;
import com.intellij.psi.PsiElement;
import com.intellij.ui.ColorUtil;
import java.awt.Color;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSXColorProvider
implements ElementColorProvider {
    @Nullable
    public Color getColorFrom(@NotNull PsiElement element) {
        String value;
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/frameworks/react/JSXColorProvider", "getColorFrom"));
        }
        if (element instanceof JSLiteralExpression && ((JSLiteralExpression)element).isQuotedLiteral() && (value = (String)((JSLiteralExpression)element).getValue()) != null && value.startsWith("#")) {
            try {
                return ColorUtil.fromHex((String)value);
            }
            catch (Exception e) {
                return null;
            }
        }
        return null;
    }

    public void setColorTo(@NotNull PsiElement element, @NotNull Color color) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/frameworks/react/JSXColorProvider", "setColorTo"));
        }
        if (color == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "color", "com/intellij/lang/javascript/frameworks/react/JSXColorProvider", "setColorTo"));
        }
        CommandProcessor.getInstance().executeCommand(element.getProject(), () -> {
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/frameworks/react/JSXColorProvider", "lambda$setColorTo$0"));
            }
            if (color == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "color", "com/intellij/lang/javascript/frameworks/react/JSXColorProvider", "lambda$setColorTo$0"));
            }
            if (element instanceof JSLiteralExpressionImpl && ((JSLiteralExpression)element).isQuotedLiteral()) {
                ElementManipulators.getManipulator((PsiElement)element).handleContentChange(element, "#" + ColorUtil.toHex((Color)color));
            }
        }, IdeBundle.message((String)"change.color.command.text", (Object[])new Object[0]), null);
    }
}

