/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.library;

import com.intellij.lang.javascript.dialects.JSLanguageLevel;
import com.intellij.lang.javascript.index.predefined.Marker;
import com.intellij.lang.javascript.library.JSLibraryUtil;
import com.intellij.lang.javascript.library.JSPredefinedLibraryProvider;
import com.intellij.lang.javascript.settings.JSRootConfiguration;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.AtomicNotNullLazyValue;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.HashSet;
import com.intellij.webcore.libraries.ScriptingLibraryModel;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSCorePredefinedLibrariesProvider
extends JSPredefinedLibraryProvider {
    private static final Logger LOG = Logger.getInstance(JSCorePredefinedLibrariesProvider.class);
    private static final String ON = "On";
    private static final String OFF = "Off";
    public static final String LIB_HTML = "HTML";
    public static final String LIB_WEBGL = "WebGL";
    public static final String LIB_NASHORN = "Nashorn";
    public static final String ECMASCRIPT_JS = "EcmaScript.js";
    public static final String ECMASCRIPT5_JS = "EcmaScript5.js";
    private static final String[][] ourPredefinedLibraries = new String[][]{{"HTML", "On", "AJAX.js", "DHTML.js", "DOMCore.js", "DOMEvents.js", "DOMXPath.js", "DOMTraversalAndRange.js", "E4X.js", "HTML5.js"}, {"WebGL", "Off", "WebGL.js"}};
    private static final String[] ES5_LIB_FILES = new String[]{"EcmaScript5.js"};
    private static final String[] ES6_LIB_FILES = new String[]{"EcmaScript6.js", "ECMAScript7.js"};
    private static final String[] ourJavaScriptLibraries = new String[]{"EcmaScript.js"};
    private static final String[] ourActionScriptLibraries = new String[]{"ECMAScript.js2", "E4X.js2"};
    private static final String[] ourJSXLibraries = new String[]{"react.d.ts"};
    private static final AtomicNotNullLazyValue<Set<VirtualFile>> ourJSXPredefLibFiles = JSCorePredefinedLibrariesProvider.newAtomicNotNullLazyValue(ourJSXLibraries);
    private static final AtomicNotNullLazyValue<Set<VirtualFile>> ourJSCorePredefLibFiles = JSCorePredefinedLibrariesProvider.newAtomicNotNullLazyValue(ourJavaScriptLibraries);
    private static final AtomicNotNullLazyValue<Set<VirtualFile>> ourJSPredefLibFiles = new AtomicNotNullLazyValue<Set<VirtualFile>>(){

        @NotNull
        protected Set<VirtualFile> compute() {
            HashSet result = new HashSet();
            for (int i = 0; i <= 1; ++i) {
                String[] libDef = ourPredefinedLibraries[i];
                assert (libDef.length >= 3);
                result.addAll(JSCorePredefinedLibrariesProvider.getFiles(libDef));
            }
            for (String libDef : ourJavaScriptLibraries) {
                result.add(JSCorePredefinedLibrariesProvider.getPredefinedLibFile(libDef));
            }
            HashSet hashSet = result;
            if (hashSet == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/library/JSCorePredefinedLibrariesProvider$1", "compute"));
            }
            return hashSet;
        }
    };
    private static final AtomicNotNullLazyValue<Set<VirtualFile>> ourAllJSPredefLibFiles = new AtomicNotNullLazyValue<Set<VirtualFile>>(){

        @NotNull
        protected Set<VirtualFile> compute() {
            HashSet result = new HashSet(JSCorePredefinedLibrariesProvider.getJavaScriptPredefinedLibraryFiles());
            for (int i = 2; i < ourPredefinedLibraries.length; ++i) {
                String[] libDef = ourPredefinedLibraries[i];
                assert (libDef.length >= 3);
                result.addAll(JSCorePredefinedLibrariesProvider.getFiles(libDef));
            }
            result.addAll(JSCorePredefinedLibrariesProvider.toVirtualFileSet(ES6_LIB_FILES));
            HashSet hashSet = result;
            if (hashSet == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/library/JSCorePredefinedLibrariesProvider$2", "compute"));
            }
            return hashSet;
        }
    };
    private static final Map<String, Ref<VirtualFile>> ourLibFileCache = ContainerUtil.newConcurrentMap();

    @Override
    @NotNull
    public ScriptingLibraryModel[] getPredefinedLibraries(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/library/JSCorePredefinedLibrariesProvider", "getPredefinedLibraries"));
        }
        ArrayList<ScriptingLibraryModel> predefinedLibraries = new ArrayList<ScriptingLibraryModel>();
        for (String[] libDef : ourPredefinedLibraries) {
            assert (libDef.length >= 3);
            String libName = libDef[0];
            String defaultFlag = libDef[1];
            Set<VirtualFile> libFiles = JSCorePredefinedLibrariesProvider.getFiles(libDef);
            predefinedLibraries.add(ScriptingLibraryModel.createPredefinedLibrary((String)libName, (VirtualFile[])VfsUtilCore.toVirtualFileArray(libFiles), (boolean)ON.equals(defaultFlag)));
        }
        ScriptingLibraryModel[] scriptingLibraryModelArray = predefinedLibraries.toArray(new ScriptingLibraryModel[predefinedLibraries.size()]);
        if (scriptingLibraryModelArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/library/JSCorePredefinedLibrariesProvider", "getPredefinedLibraries"));
        }
        return scriptingLibraryModelArray;
    }

    @Override
    @NotNull
    public Set<VirtualFile> getRequiredLibraryFilesToIndex() {
        HashSet libFiles = new HashSet();
        libFiles.addAll(JSCorePredefinedLibrariesProvider.getJavaScriptCorePredefinedLibraryFiles());
        libFiles.addAll(JSCorePredefinedLibrariesProvider.getActionScriptPredefinedLibraryFiles());
        libFiles.addAll(JSCorePredefinedLibrariesProvider.getJSXPredefinedLibraryFiles());
        HashSet hashSet = libFiles;
        if (hashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/library/JSCorePredefinedLibrariesProvider", "getRequiredLibraryFilesToIndex"));
        }
        return hashSet;
    }

    @Override
    @NotNull
    public Set<VirtualFile> getRequiredLibraryFilesForResolve(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/library/JSCorePredefinedLibrariesProvider", "getRequiredLibraryFilesForResolve"));
        }
        HashSet files = new HashSet();
        files.addAll(JSCorePredefinedLibrariesProvider.getJavaScriptCorePredefinedLibraryFiles());
        JSLanguageLevel level = JSRootConfiguration.getInstance(project).getLanguageLevel();
        if (level.isES5Compatible()) {
            JSCorePredefinedLibrariesProvider.addFiles((Set<VirtualFile>)files, ES5_LIB_FILES);
        }
        if (level.isES6Compatible()) {
            JSCorePredefinedLibrariesProvider.addFiles((Set<VirtualFile>)files, ES6_LIB_FILES);
        }
        HashSet hashSet = files;
        if (hashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/library/JSCorePredefinedLibrariesProvider", "getRequiredLibraryFilesForResolve"));
        }
        return hashSet;
    }

    @Override
    @NotNull
    public Map<String, String> getPredefinedLibraryRenamingMap() {
        Map<String, String> map = Collections.emptyMap();
        if (map == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/library/JSCorePredefinedLibrariesProvider", "getPredefinedLibraryRenamingMap"));
        }
        return map;
    }

    @NotNull
    public static Set<VirtualFile> getActionScriptPredefinedLibraryFiles() {
        Set<VirtualFile> set = JSCorePredefinedLibrariesProvider.toVirtualFileSet(ourActionScriptLibraries);
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/library/JSCorePredefinedLibrariesProvider", "getActionScriptPredefinedLibraryFiles"));
        }
        return set;
    }

    @NotNull
    public static Set<VirtualFile> getJSXPredefinedLibraryFiles() {
        Set set = (Set)ourJSXPredefLibFiles.getValue();
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/library/JSCorePredefinedLibrariesProvider", "getJSXPredefinedLibraryFiles"));
        }
        return set;
    }

    @NotNull
    public static Set<VirtualFile> getJavaScriptCorePredefinedLibraryFiles() {
        Set set = (Set)ourJSCorePredefLibFiles.getValue();
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/library/JSCorePredefinedLibrariesProvider", "getJavaScriptCorePredefinedLibraryFiles"));
        }
        return set;
    }

    @NotNull
    public static Set<VirtualFile> getJavaScriptPredefinedLibraryFiles() {
        Set set = (Set)ourJSPredefLibFiles.getValue();
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/library/JSCorePredefinedLibrariesProvider", "getJavaScriptPredefinedLibraryFiles"));
        }
        return set;
    }

    @NotNull
    public static Set<VirtualFile> getAllJSPredefinedLibraryFiles() {
        Set set = (Set)ourAllJSPredefLibFiles.getValue();
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/library/JSCorePredefinedLibrariesProvider", "getAllJSPredefinedLibraryFiles"));
        }
        return set;
    }

    @NotNull
    private static Set<VirtualFile> getFiles(String[] libDef) {
        assert (libDef.length >= 3);
        HashSet libFiles = new HashSet();
        for (int i = 2; i < libDef.length; ++i) {
            VirtualFile file = JSCorePredefinedLibrariesProvider.getPredefinedLibFile(libDef[i]);
            if (file == null) continue;
            libFiles.add(file);
        }
        HashSet hashSet = libFiles;
        if (hashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/library/JSCorePredefinedLibrariesProvider", "getFiles"));
        }
        return hashSet;
    }

    @Nullable
    private static VirtualFile getPredefinedLibFile(@NotNull String libFileName) {
        if (libFileName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "libFileName", "com/intellij/lang/javascript/library/JSCorePredefinedLibrariesProvider", "getPredefinedLibFile"));
        }
        Ref<VirtualFile> fileRef = JSCorePredefinedLibrariesProvider.getCachedFileRef(libFileName);
        if (fileRef != null) {
            return (VirtualFile)fileRef.get();
        }
        VirtualFile file = JSCorePredefinedLibrariesProvider.findFileByURL(libFileName);
        return JSCorePredefinedLibrariesProvider.cacheFile(libFileName, file);
    }

    @Nullable
    public static VirtualFile findFileByURL(@NotNull String libFileName) {
        if (libFileName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "libFileName", "com/intellij/lang/javascript/library/JSCorePredefinedLibrariesProvider", "findFileByURL"));
        }
        URL libFileUrl = Marker.class.getResource(libFileName);
        if (libFileUrl == null) {
            LOG.error("Cannot find " + libFileName + ", the installation is possibly broken.");
            return null;
        }
        VirtualFile file = VfsUtil.findFileByURL((URL)libFileUrl);
        if (file != null && file.isValid()) {
            return file;
        }
        LOG.warn("Cannot find virtual file " + libFileName + " by url " + libFileUrl.toExternalForm());
        return null;
    }

    @Nullable
    private static Ref<VirtualFile> getCachedFileRef(@NotNull String fileName) {
        VirtualFile file;
        if (fileName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileName", "com/intellij/lang/javascript/library/JSCorePredefinedLibrariesProvider", "getCachedFileRef"));
        }
        Ref<VirtualFile> ref = ourLibFileCache.get(fileName);
        VirtualFile virtualFile = file = ref != null ? (VirtualFile)ref.get() : null;
        if (file != null && !file.isValid()) {
            ourLibFileCache.remove(fileName);
            ref = null;
        }
        return ref;
    }

    @Contract(value="_, null -> null")
    @Nullable
    private static VirtualFile cacheFile(@NotNull String libFileName, @Nullable VirtualFile file) {
        if (libFileName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "libFileName", "com/intellij/lang/javascript/library/JSCorePredefinedLibrariesProvider", "cacheFile"));
        }
        return JSLibraryUtil.cacheFile(libFileName, file, ourLibFileCache);
    }

    @NotNull
    private static Set<VirtualFile> toVirtualFileSet(@NotNull String[] predefinedFileNames) {
        if (predefinedFileNames == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "predefinedFileNames", "com/intellij/lang/javascript/library/JSCorePredefinedLibrariesProvider", "toVirtualFileSet"));
        }
        java.util.HashSet files = ContainerUtil.newHashSet((int)predefinedFileNames.length);
        JSCorePredefinedLibrariesProvider.addFiles(files, predefinedFileNames);
        java.util.HashSet hashSet = files;
        if (hashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/library/JSCorePredefinedLibrariesProvider", "toVirtualFileSet"));
        }
        return hashSet;
    }

    private static void addFiles(@NotNull Set<VirtualFile> files, @NotNull String[] predefinedFileNames) {
        if (files == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "files", "com/intellij/lang/javascript/library/JSCorePredefinedLibrariesProvider", "addFiles"));
        }
        if (predefinedFileNames == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "predefinedFileNames", "com/intellij/lang/javascript/library/JSCorePredefinedLibrariesProvider", "addFiles"));
        }
        for (String predefinedFileName : predefinedFileNames) {
            VirtualFile file = JSCorePredefinedLibrariesProvider.getPredefinedLibFile(predefinedFileName);
            if (file == null) continue;
            files.add(file);
        }
    }

    @NotNull
    private static AtomicNotNullLazyValue<Set<VirtualFile>> newAtomicNotNullLazyValue(final @NotNull String[] predefinedFileNames) {
        if (predefinedFileNames == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "predefinedFileNames", "com/intellij/lang/javascript/library/JSCorePredefinedLibrariesProvider", "newAtomicNotNullLazyValue"));
        }
        AtomicNotNullLazyValue<Set<VirtualFile>> atomicNotNullLazyValue = new AtomicNotNullLazyValue<Set<VirtualFile>>(){

            @NotNull
            protected Set<VirtualFile> compute() {
                Set set = JSCorePredefinedLibrariesProvider.toVirtualFileSet(predefinedFileNames);
                if (set == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/library/JSCorePredefinedLibrariesProvider$3", "compute"));
                }
                return set;
            }
        };
        if (atomicNotNullLazyValue == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/library/JSCorePredefinedLibrariesProvider", "newAtomicNotNullLazyValue"));
        }
        return atomicNotNullLazyValue;
    }
}

