/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.library.stat;

import com.intellij.internal.statistic.AbstractApplicationUsagesCollector;
import com.intellij.internal.statistic.beans.GroupDescriptor;
import com.intellij.internal.statistic.beans.UsageDescriptor;
import com.intellij.lang.javascript.library.JSLibraryManager;
import com.intellij.lang.javascript.library.JSLibraryMappings;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.project.Project;
import com.intellij.util.containers.HashSet;
import com.intellij.webcore.ScriptingFrameworkDescriptor;
import com.intellij.webcore.libraries.ScriptingLibraryManager;
import com.intellij.webcore.libraries.ScriptingLibraryModel;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class JSLibraryUsagesCollector
extends AbstractApplicationUsagesCollector {
    public static final String GROUP_ID = "javaScript Frameworks";

    @NotNull
    public Set<UsageDescriptor> getProjectUsages(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/library/stat/JSLibraryUsagesCollector", "getProjectUsages"));
        }
        HashSet libTypes = new HashSet();
        ScriptingLibraryManager libraryManager = (ScriptingLibraryManager)ServiceManager.getService((Project)project, JSLibraryManager.class);
        if (libraryManager != null) {
            ScriptingLibraryModel[] libModels = libraryManager.getAllLibraries();
            for (ScriptingLibraryModel libModel : libModels) {
                ScriptingFrameworkDescriptor frameworkDescriptor;
                if (libModel == null || (frameworkDescriptor = libModel.getFrameworkDescriptor()) == null || !JSLibraryUsagesCollector.isInProject(libModel, project)) continue;
                libTypes.add(frameworkDescriptor.toString());
            }
        }
        HashSet descriptors = new HashSet();
        for (String libType : libTypes) {
            descriptors.add(new UsageDescriptor(libType, 1));
        }
        HashSet hashSet = descriptors;
        if (hashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/library/stat/JSLibraryUsagesCollector", "getProjectUsages"));
        }
        return hashSet;
    }

    private static boolean isInProject(ScriptingLibraryModel libraryModel, Project project) {
        JSLibraryMappings mappings = (JSLibraryMappings)((Object)ServiceManager.getService((Project)project, JSLibraryMappings.class));
        return mappings != null && mappings.containsLibrary(libraryModel);
    }

    @NotNull
    public GroupDescriptor getGroupId() {
        GroupDescriptor groupDescriptor = GroupDescriptor.create((String)GROUP_ID);
        if (groupDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/library/stat/JSLibraryUsagesCollector", "getGroupId"));
        }
        return groupDescriptor;
    }
}

