/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.linter;

import com.intellij.lang.ASTNode;
import com.intellij.lang.javascript.highlighting.JSSpellcheckerProvider;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.util.JSDirectiveCommentUtil;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.tree.IElementType;
import com.intellij.spellchecker.tokenizer.SpellcheckingStrategy;
import com.intellij.spellchecker.tokenizer.Tokenizer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSDirectiveCommentSpellcheckerProvider
implements JSSpellcheckerProvider {
    @Override
    @Nullable
    public Tokenizer getTokenizer(@NotNull PsiElement element) {
        CharSequence commentChars;
        PsiComment comment;
        IElementType type;
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/linter/JSDirectiveCommentSpellcheckerProvider", "getTokenizer"));
        }
        PsiFile psiFile = element.getContainingFile();
        if (psiFile instanceof JSFile && element instanceof PsiComment && JSDirectiveCommentUtil.isDirectiveCommentTokenType(type = (comment = (PsiComment)element).getTokenType()) && JSDirectiveCommentUtil.isDirectiveComment(commentChars = JSDirectiveCommentSpellcheckerProvider.getCommentChars(comment))) {
            return SpellcheckingStrategy.EMPTY_TOKENIZER;
        }
        return null;
    }

    @NotNull
    private static CharSequence getCommentChars(@NotNull PsiComment comment) {
        if (comment == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "comment", "com/intellij/lang/javascript/linter/JSDirectiveCommentSpellcheckerProvider", "getCommentChars"));
        }
        ASTNode node = comment.getNode();
        if (node != null) {
            CharSequence charSequence = node.getChars();
            if (charSequence == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/linter/JSDirectiveCommentSpellcheckerProvider", "getCommentChars"));
            }
            return charSequence;
        }
        String string = comment.getText();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/linter/JSDirectiveCommentSpellcheckerProvider", "getCommentChars"));
        }
        return string;
    }
}

