/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.linter;

import com.intellij.lang.javascript.linter.ExtendedLinterState;
import com.intellij.lang.javascript.linter.JSLinterBaseView;
import com.intellij.lang.javascript.linter.JSLinterConfiguration;
import com.intellij.lang.javascript.linter.JSLinterState;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.SearchableConfigurable;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.options.ex.SingleConfigurableEditor;
import com.intellij.openapi.options.newEditor.SettingsDialog;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.util.ui.SwingHelper;
import com.intellij.util.ui.update.Activatable;
import com.intellij.util.ui.update.UiNotifyConnector;
import java.awt.Component;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class UntypedJSLinterConfigurable
implements SearchableConfigurable {
    protected final Project myProject;
    protected final boolean myFullModeDialog;
    @Nullable
    protected JSLinterBaseView myView;

    protected UntypedJSLinterConfigurable(@NotNull Project project, boolean fullModeDialog) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/linter/UntypedJSLinterConfigurable", "<init>"));
        }
        this.myProject = project;
        this.myFullModeDialog = fullModeDialog;
    }

    public String getHelpTopic() {
        return this.getId();
    }

    @Nullable
    public JComponent createComponent() {
        if (this.myView != null) {
            this.myView.disposeResources();
        }
        this.myView = this.createView();
        return this.myView.getComponent();
    }

    @NotNull
    protected abstract JSLinterBaseView createView();

    public boolean isModified() {
        return this.myView != null;
    }

    public void disposeUIResources() {
        if (this.myView != null) {
            this.myView.disposeResources();
            this.myView = null;
        }
    }

    public void showEditDialog() {
        ShowSettingsUtil.getInstance().editConfigurable(this.myProject, (Configurable)this);
    }

    protected void resizeDialogToFitPreferredSize(@NotNull JSLinterBaseView view) {
        if (view == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "view", "com/intellij/lang/javascript/linter/UntypedJSLinterConfigurable", "resizeDialogToFitPreferredSize"));
        }
        if (this.myFullModeDialog) {
            final JComponent component = view.getComponent();
            new UiNotifyConnector.Once((Component)component, (Activatable)new Activatable.Adapter(){

                public void showNotify() {
                    DialogWrapper dialogWrapper = DialogWrapper.findInstance((Component)component);
                    if (dialogWrapper instanceof SettingsDialog || dialogWrapper instanceof SingleConfigurableEditor) {
                        SwingUtilities.invokeLater(() -> SwingHelper.adjustDialogSizeToFitPreferredSize((DialogWrapper)dialogWrapper));
                    }
                }
            });
        }
    }

    @NotNull
    public final <TState extends JSLinterState> ExtendedLinterState<TState> getExtendedState(Class<? extends JSLinterConfiguration<TState>> configurationClass) {
        JSLinterConfiguration<TState> configuration = JSLinterConfiguration.getInstance(this.myProject, configurationClass);
        ExtendedLinterState<TState> extendedLinterState = configuration.getExtendedState(true);
        if (extendedLinterState == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/linter/UntypedJSLinterConfigurable", "getExtendedState"));
        }
        return extendedLinterState;
    }

    public final <TState extends JSLinterState> void setExtendedState(@NotNull ExtendedLinterState<TState> state, Class<? extends JSLinterConfiguration<TState>> configurationClass) {
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/lang/javascript/linter/UntypedJSLinterConfigurable", "setExtendedState"));
        }
        JSLinterConfiguration<TState> configuration = JSLinterConfiguration.getInstance(this.myProject, configurationClass);
        configuration.setExtendedState(state);
    }

    protected Project getProject() {
        return this.myProject;
    }

    protected boolean isFullModeDialog() {
        return this.myFullModeDialog;
    }
}

