/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.linter.eslint;

import com.intellij.javascript.nodejs.util.JSLinterPackage;
import com.intellij.lang.javascript.linter.JSLinterConfiguration;
import com.intellij.lang.javascript.linter.JSLinterInspection;
import com.intellij.lang.javascript.linter.eslint.EslintInspection;
import com.intellij.lang.javascript.linter.eslint.EslintState;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.JDOMExternalizerUtil;
import com.intellij.openapi.util.text.StringUtil;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@State(name="EslintConfiguration", storages={@Storage(value="jsLinters/eslint.xml")})
public class EslintConfiguration
extends JSLinterConfiguration<EslintState> {
    private static final String TAG_CUSTOM_CONFIGURATION_FILE = "custom-configuration-file";
    private static final String ATTR_CUSTOM_CONFIGURATION_FILE_USED = "used";
    private static final String ATTR_CUSTOM_CONFIGURATION_FILE_PATH = "path";
    private static final String TAG_ADDITIONAL_RULES_DIR = "additional-rules-dir";
    private static final String TAG_EXTRA_ESLINT_OPTIONS = "extra-options";
    private final JSLinterPackage myPackage;

    public EslintConfiguration(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/linter/eslint/EslintConfiguration", "<init>"));
        }
        super(project);
        this.myPackage = new JSLinterPackage(project, "eslint");
    }

    @NotNull
    public static EslintConfiguration getInstance(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/linter/eslint/EslintConfiguration", "getInstance"));
        }
        EslintConfiguration eslintConfiguration = JSLinterConfiguration.getInstance(project, EslintConfiguration.class);
        if (eslintConfiguration == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/linter/eslint/EslintConfiguration", "getInstance"));
        }
        return eslintConfiguration;
    }

    @Override
    @NotNull
    protected Class<? extends JSLinterInspection> getInspectionClass() {
        if (EslintInspection.class == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/linter/eslint/EslintConfiguration", "getInspectionClass"));
        }
        return EslintInspection.class;
    }

    @Override
    protected void savePrivateSettings(@NotNull EslintState state) {
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/lang/javascript/linter/eslint/EslintConfiguration", "savePrivateSettings"));
        }
        this.doSavePrivateSettings(state);
    }

    @Override
    @NotNull
    protected EslintState loadPrivateSettings(@NotNull EslintState state) {
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/lang/javascript/linter/eslint/EslintConfiguration", "loadPrivateSettings"));
        }
        EslintState.Builder builder = new EslintState.Builder(state);
        this.doLoadPrivateSettings(builder);
        EslintState eslintState = builder.build();
        if (eslintState == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/linter/eslint/EslintConfiguration", "loadPrivateSettings"));
        }
        return eslintState;
    }

    @Override
    @Nullable
    protected Element toXml(@NotNull EslintState state) {
        String extraOptions;
        String additionalRulesDirPath;
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/lang/javascript/linter/eslint/EslintConfiguration", "toXml"));
        }
        if (EslintConfiguration.isEmpty(state)) {
            return null;
        }
        Element parent = new Element("eslint");
        if (state.isCustomConfigFileUsed() || !state.getCustomConfigFilePath().isEmpty()) {
            Element customConfigurationFileElement = new Element(TAG_CUSTOM_CONFIGURATION_FILE);
            customConfigurationFileElement.setAttribute(ATTR_CUSTOM_CONFIGURATION_FILE_USED, Boolean.toString(state.isCustomConfigFileUsed()));
            customConfigurationFileElement.setAttribute(ATTR_CUSTOM_CONFIGURATION_FILE_PATH, state.getCustomConfigFilePath());
            parent.addContent(customConfigurationFileElement);
        }
        if (!(additionalRulesDirPath = state.getAdditionalRulesDirPath()).isEmpty()) {
            JDOMExternalizerUtil.addElementWithValueAttribute((Element)parent, (String)TAG_ADDITIONAL_RULES_DIR, (String)additionalRulesDirPath);
        }
        if (!StringUtil.isEmptyOrSpaces((String)(extraOptions = state.getExtraOptions()))) {
            JDOMExternalizerUtil.addElementWithValueAttribute((Element)parent, (String)TAG_EXTRA_ESLINT_OPTIONS, (String)extraOptions);
        }
        return parent;
    }

    @Override
    @NotNull
    protected EslintState fromXml(@NotNull Element element) {
        String extraOptions;
        String additionalRulesDirPath;
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/linter/eslint/EslintConfiguration", "fromXml"));
        }
        EslintState.Builder builder = new EslintState.Builder();
        Element customConfigurationFileElement = element.getChild(TAG_CUSTOM_CONFIGURATION_FILE);
        if (customConfigurationFileElement != null) {
            boolean used = Boolean.parseBoolean(customConfigurationFileElement.getAttributeValue(ATTR_CUSTOM_CONFIGURATION_FILE_USED));
            builder.setCustomConfigFileUsed(used);
            String customConfigFilePath = customConfigurationFileElement.getAttributeValue(ATTR_CUSTOM_CONFIGURATION_FILE_PATH);
            builder.setCustomConfigFilePath(StringUtil.notNullize((String)customConfigFilePath));
        }
        if ((additionalRulesDirPath = JDOMExternalizerUtil.getFirstChildValueAttribute((Element)element, (String)TAG_ADDITIONAL_RULES_DIR)) != null) {
            builder.setAdditionalRulesDirPath(additionalRulesDirPath);
        }
        if ((extraOptions = JDOMExternalizerUtil.getFirstChildValueAttribute((Element)element, (String)TAG_EXTRA_ESLINT_OPTIONS)) != null) {
            builder.setExtraOptions(extraOptions);
        }
        EslintState eslintState = builder.build();
        if (eslintState == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/linter/eslint/EslintConfiguration", "fromXml"));
        }
        return eslintState;
    }

    @Override
    @NotNull
    protected EslintState getDefaultState() {
        EslintState eslintState = EslintState.DEFAULT;
        if (eslintState == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/linter/eslint/EslintConfiguration", "getDefaultState"));
        }
        return eslintState;
    }

    private void doSavePrivateSettings(@NotNull EslintState state) {
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/lang/javascript/linter/eslint/EslintConfiguration", "doSavePrivateSettings"));
        }
        this.myPackage.force(state.getInterpreterRef(), state.getEslintPackagePath());
    }

    private void doLoadPrivateSettings(@NotNull EslintState.Builder builder) {
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/lang/javascript/linter/eslint/EslintConfiguration", "doLoadPrivateSettings"));
        }
        this.myPackage.readOrDetect();
        builder.setInterpreterRef(this.myPackage.getInterpreter());
        builder.setEslintPackagePath(this.myPackage.getPackagePath());
    }

    private static boolean isEmpty(@NotNull EslintState state) {
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/lang/javascript/linter/eslint/EslintConfiguration", "isEmpty"));
        }
        String additionalRulesDirPath = state.getAdditionalRulesDirPath();
        String extraOptions = state.getExtraOptions();
        return (!state.isCustomConfigFileUsed() || state.getCustomConfigFilePath().isEmpty()) && additionalRulesDirPath.isEmpty() && StringUtil.isEmptyOrSpaces((String)extraOptions);
    }
}

