/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.linter.jshint.config;

import com.intellij.json.psi.JsonProperty;
import com.intellij.lang.javascript.linter.JSLinterConfigFileUtil;
import com.intellij.lang.javascript.linter.jshint.config.JSHintConfigFileUtil;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.ManagingFS;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PlatformPatterns;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceContributor;
import com.intellij.psi.PsiReferenceProvider;
import com.intellij.psi.PsiReferenceRegistrar;
import com.intellij.psi.filters.ElementFilter;
import com.intellij.psi.filters.position.FilterPattern;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReference;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReferenceSet;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ProcessingContext;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class JSHintConfigReferenceContributor
extends PsiReferenceContributor {
    private static final ElementPattern<JSLiteralExpression> EXTENDS_VALUE_PLACE = PlatformPatterns.psiElement(JSLiteralExpression.class).and((ElementPattern)new FilterPattern(new ElementFilter(){

        public boolean isAcceptable(Object element, PsiElement context) {
            if (element instanceof JSLiteralExpression) {
                JSLiteralExpression literalExpression = (JSLiteralExpression)element;
                return literalExpression.isQuotedLiteral() && JSHintConfigFileUtil.isJSHintConfigFile((PsiElement)literalExpression);
            }
            return false;
        }

        public boolean isClassAcceptable(Class hintClass) {
            return true;
        }
    }));

    public void registerReferenceProviders(@NotNull PsiReferenceRegistrar psiReferenceRegistrar) {
        if (psiReferenceRegistrar == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiReferenceRegistrar", "com/intellij/lang/javascript/linter/jshint/config/JSHintConfigReferenceContributor", "registerReferenceProviders"));
        }
        psiReferenceRegistrar.registerReferenceProvider(EXTENDS_VALUE_PLACE, new PsiReferenceProvider(){

            @NotNull
            public PsiReference[] getReferencesByElement(@NotNull PsiElement psiElement, @NotNull ProcessingContext processingContext) {
                if (psiElement == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiElement", "com/intellij/lang/javascript/linter/jshint/config/JSHintConfigReferenceContributor$2", "getReferencesByElement"));
                }
                if (processingContext == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processingContext", "com/intellij/lang/javascript/linter/jshint/config/JSHintConfigReferenceContributor$2", "getReferencesByElement"));
                }
                JSLiteralExpression literalExpression = (JSLiteralExpression)ObjectUtils.tryCast((Object)psiElement, JSLiteralExpression.class);
                if (literalExpression != null) {
                    PsiReference[] psiReferenceArray = JSHintConfigReferenceContributor.getReferencesByLiteralExpression(literalExpression, this);
                    if (psiReferenceArray == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/linter/jshint/config/JSHintConfigReferenceContributor$2", "getReferencesByElement"));
                    }
                    return psiReferenceArray;
                }
                if (PsiReference.EMPTY_ARRAY == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/linter/jshint/config/JSHintConfigReferenceContributor$2", "getReferencesByElement"));
                }
                return PsiReference.EMPTY_ARRAY;
            }
        });
    }

    @NotNull
    private static PsiReference[] getReferencesByLiteralExpression(@NotNull JSLiteralExpression literalExpression, @NotNull PsiReferenceProvider psiReferenceProvider) {
        if (literalExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "literalExpression", "com/intellij/lang/javascript/linter/jshint/config/JSHintConfigReferenceContributor", "getReferencesByLiteralExpression"));
        }
        if (psiReferenceProvider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiReferenceProvider", "com/intellij/lang/javascript/linter/jshint/config/JSHintConfigReferenceContributor", "getReferencesByLiteralExpression"));
        }
        JsonProperty property = JSLinterConfigFileUtil.getProperty((PsiElement)literalExpression);
        if (property == null) {
            if (PsiReference.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/linter/jshint/config/JSHintConfigReferenceContributor", "getReferencesByLiteralExpression"));
            }
            return PsiReference.EMPTY_ARRAY;
        }
        PsiElement keyElement = JSLinterConfigFileUtil.getFirstChildAsStringLiteral(property);
        if (keyElement != null && literalExpression == property.getValue() && JSHintConfigFileUtil.isExtendsKey(keyElement)) {
            String path = StringUtil.stripQuotesAroundValue((String)literalExpression.getText());
            ExtendsFileReferenceSet fileReferenceSet = new ExtendsFileReferenceSet(path, literalExpression, psiReferenceProvider);
            FileReference[] fileReferenceArray = fileReferenceSet.getAllReferences();
            if (fileReferenceArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/linter/jshint/config/JSHintConfigReferenceContributor", "getReferencesByLiteralExpression"));
            }
            return fileReferenceArray;
        }
        if (PsiReference.EMPTY_ARRAY == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/linter/jshint/config/JSHintConfigReferenceContributor", "getReferencesByLiteralExpression"));
        }
        return PsiReference.EMPTY_ARRAY;
    }

    private static class ExtendsFileReferenceSet
    extends FileReferenceSet {
        public ExtendsFileReferenceSet(@NotNull String path, @NotNull JSLiteralExpression literalExpression, @NotNull PsiReferenceProvider psiReferenceProvider) {
            if (path == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/lang/javascript/linter/jshint/config/JSHintConfigReferenceContributor$ExtendsFileReferenceSet", "<init>"));
            }
            if (literalExpression == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "literalExpression", "com/intellij/lang/javascript/linter/jshint/config/JSHintConfigReferenceContributor$ExtendsFileReferenceSet", "<init>"));
            }
            if (psiReferenceProvider == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiReferenceProvider", "com/intellij/lang/javascript/linter/jshint/config/JSHintConfigReferenceContributor$ExtendsFileReferenceSet", "<init>"));
            }
            super(path, (PsiElement)literalExpression, 1, psiReferenceProvider, SystemInfo.isFileSystemCaseSensitive, false);
        }

        @NotNull
        public Collection<PsiFileSystemItem> computeDefaultContexts() {
            if (this.isAbsolutePathReference()) {
                Collection collection = this.toFileSystemItems(ManagingFS.getInstance().getLocalRoots());
                if (collection == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/linter/jshint/config/JSHintConfigReferenceContributor$ExtendsFileReferenceSet", "computeDefaultContexts"));
                }
                return collection;
            }
            Collection<PsiFileSystemItem> collection = this.findParentPsiDirectory();
            if (collection == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/linter/jshint/config/JSHintConfigReferenceContributor$ExtendsFileReferenceSet", "computeDefaultContexts"));
            }
            return collection;
        }

        @NotNull
        private Collection<PsiFileSystemItem> findParentPsiDirectory() {
            PsiDirectory directory;
            VirtualFile virtualFile;
            VirtualFile parent;
            PsiFile file = this.getContainingFile();
            if (file != null && (parent = (virtualFile = file.getOriginalFile().getVirtualFile()).getParent()) != null && (directory = file.getManager().findDirectory(parent)) != null) {
                Set<PsiDirectory> set = Collections.singleton(directory);
                if (set == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/linter/jshint/config/JSHintConfigReferenceContributor$ExtendsFileReferenceSet", "findParentPsiDirectory"));
                }
                return set;
            }
            List<PsiFileSystemItem> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/linter/jshint/config/JSHintConfigReferenceContributor$ExtendsFileReferenceSet", "findParentPsiDirectory"));
            }
            return list;
        }

        protected boolean isSoft() {
            return false;
        }
    }
}

