/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.nashorn;

import com.intellij.lang.ASTNode;
import com.intellij.lang.PsiBuilder;
import com.intellij.lang.PsiParser;
import com.intellij.lang.javascript.JSFlexAdapter;
import com.intellij.lang.javascript.JSStubElementTypes;
import com.intellij.lang.javascript.JavascriptParserDefinition;
import com.intellij.lang.javascript.nashorn.NashornJSLanguageDialect;
import com.intellij.lang.javascript.nashorn.parsing.NashornJSParser;
import com.intellij.lexer.Lexer;
import com.intellij.openapi.project.Project;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.IFileElementType;
import org.jetbrains.annotations.NotNull;

public class NashornJSParserDefinition
extends JavascriptParserDefinition {
    @Override
    @NotNull
    public Lexer createLexer(Project project) {
        JSFlexAdapter jSFlexAdapter = new JSFlexAdapter(NashornJSLanguageDialect.DIALECT_OPTION_HOLDER);
        if (jSFlexAdapter == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/nashorn/NashornJSParserDefinition", "createLexer"));
        }
        return jSFlexAdapter;
    }

    @Override
    public IFileElementType getFileNodeType() {
        return JSStubElementTypes.NASHORN_JS_FILE;
    }

    @Override
    @NotNull
    public PsiParser createParser(Project project) {
        PsiParser psiParser = new PsiParser(){

            @NotNull
            public ASTNode parse(IElementType root, PsiBuilder builder) {
                new NashornJSParser(builder).parseJS(root);
                ASTNode aSTNode = builder.getTreeBuilt();
                if (aSTNode == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/nashorn/NashornJSParserDefinition$1", "parse"));
                }
                return aSTNode;
            }
        };
        if (psiParser == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/nashorn/NashornJSParserDefinition", "createParser"));
        }
        return psiParser;
    }
}

