/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.navigation;

import com.intellij.codeInsight.navigation.actions.GotoDeclarationHandler;
import com.intellij.lang.ASTNode;
import com.intellij.lang.ecmascript6.psi.ES6ImportedBinding;
import com.intellij.lang.javascript.JSKeywordSets;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Editor;
import com.intellij.psi.PsiElement;
import java.util.Collection;
import org.jetbrains.annotations.Nullable;

public class JSGotoDeclarationHandler
implements GotoDeclarationHandler {
    @Nullable
    public PsiElement[] getGotoDeclarationTargets(@Nullable PsiElement sourceElement, int offset, Editor editor) {
        if (sourceElement == null) {
            return null;
        }
        ASTNode node = sourceElement.getNode();
        if (node == null || !JSKeywordSets.IDENTIFIER_NAMES.contains(node.getElementType())) {
            return null;
        }
        PsiElement parent = sourceElement.getParent();
        if (parent instanceof ES6ImportedBinding) {
            ES6ImportedBinding importedBinding = (ES6ImportedBinding)parent;
            if (importedBinding.isNamespaceImport()) {
                return null;
            }
            Collection elements = importedBinding.findReferencedElements();
            if (elements.size() > 0) {
                return elements.toArray(PsiElement.EMPTY_ARRAY);
            }
        }
        return null;
    }

    @Nullable
    public String getActionText(DataContext context) {
        return null;
    }
}

