/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.impl;

import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.JSElementTypes;
import com.intellij.lang.javascript.JSExtendedLanguagesTokenSetProvider;
import com.intellij.lang.javascript.JSLanguageDialect;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.JavascriptLanguage;
import com.intellij.lang.javascript.psi.JSBlockStatement;
import com.intellij.lang.javascript.psi.JSElementVisitor;
import com.intellij.lang.javascript.psi.JSSourceElement;
import com.intellij.lang.javascript.psi.JSStatement;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.psi.impl.JSChangeUtil;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.impl.source.tree.LazyParseablePsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;

public class JSBlockStatementImpl
extends LazyParseablePsiElement
implements JSBlockStatement {
    private Language myLanguage;

    public JSBlockStatementImpl(CharSequence buffer) {
        super((IElementType)JSElementTypes.BLOCK_STATEMENT, buffer);
    }

    @NotNull
    public JSStatement[] getStatements() {
        ASTNode[] nodes = this.getNode().getChildren(JSExtendedLanguagesTokenSetProvider.STATEMENTS);
        JSStatement[] statements = new JSStatement[nodes.length];
        for (int i = 0; i < statements.length; ++i) {
            statements[i] = (JSStatement)nodes[i].getPsi();
        }
        if (statements == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/impl/JSBlockStatementImpl", "getStatements"));
        }
        return statements;
    }

    public boolean isConditionalCompileBlock() {
        PsiElement firstChild = this.getFirstChild();
        if (firstChild instanceof JSAttributeList) {
            return ((JSAttributeList)firstChild).getConditionalCompileVariableReference() != null;
        }
        return false;
    }

    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "com/intellij/lang/javascript/psi/impl/JSBlockStatementImpl", "accept"));
        }
        if (visitor instanceof JSElementVisitor) {
            ((JSElementVisitor)visitor).visitJSBlock((JSBlockStatement)this);
        } else {
            visitor.visitElement((PsiElement)this);
        }
    }

    public PsiElement add(@NotNull PsiElement element) throws IncorrectOperationException {
        ASTNode node;
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/psi/impl/JSBlockStatementImpl", "add"));
        }
        if (element instanceof JSStatement && (node = this.getNode().findChildByType(JSTokenTypes.RBRACE)) != null) {
            PsiElement psiElement = super.addAfter(element, node.getTreePrev().getPsi());
            CodeStyleManager.getInstance((Project)this.getProject()).reformatNewlyAddedElement(this.getNode(), psiElement.getNode());
            return psiElement;
        }
        return super.add(element);
    }

    public JSStatement addStatementBefore(JSStatement toAdd) throws IncorrectOperationException {
        return JSChangeUtil.addSourceElement((JSSourceElement)this, toAdd, true);
    }

    public JSStatement addStatementAfter(JSStatement toAdd) throws IncorrectOperationException {
        return JSChangeUtil.addSourceElement((JSSourceElement)this, toAdd, false);
    }

    public JSStatement replace(JSStatement with) {
        return JSChangeUtil.replaceStatement((JSStatement)this, with);
    }

    @NotNull
    public Language getLanguage() {
        if (this.myLanguage == null) {
            Language language = DialectDetector.languageOfElement((PsiElement)this);
            this.myLanguage = language instanceof JSLanguageDialect ? language : JavascriptLanguage.INSTANCE;
        }
        Language language = this.myLanguage;
        if (language == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/impl/JSBlockStatementImpl", "getLanguage"));
        }
        return language;
    }

    public PsiElement addBefore(@NotNull PsiElement element, PsiElement anchor) throws IncorrectOperationException {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/psi/impl/JSBlockStatementImpl", "addBefore"));
        }
        return JSChangeUtil.doAddBefore((PsiElement)this, element, anchor);
    }

    public PsiElement addAfter(@NotNull PsiElement element, PsiElement anchor) throws IncorrectOperationException {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/psi/impl/JSBlockStatementImpl", "addAfter"));
        }
        return JSChangeUtil.doAddAfter((PsiElement)this, element, anchor);
    }

    public PsiElement replace(@NotNull PsiElement newElement) throws IncorrectOperationException {
        if (newElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newElement", "com/intellij/lang/javascript/psi/impl/JSBlockStatementImpl", "replace"));
        }
        ASTNode myNode = this.getNode();
        ASTNode result = newElement.getNode().copyElement();
        myNode.getTreeParent().replaceChild(myNode, result);
        return result.getPsi();
    }

    public String toString() {
        return "JSBlockStatement";
    }
}

