/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.impl;

import com.intellij.lang.ASTNode;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.psi.JSNamedElement;
import com.intellij.lang.javascript.psi.JSPsiNamedElementBase;
import com.intellij.lang.javascript.psi.impl.JSChangeUtil;
import com.intellij.lang.javascript.psi.impl.JSStubElementImpl;
import com.intellij.lang.javascript.psi.stubs.JSStubElement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.StubBasedPsiElement;
import com.intellij.psi.stubs.IStubElementType;
import com.intellij.psi.stubs.NamedStub;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSNamedElementImpl<T extends NamedStub<?> & JSStubElement<?>>
extends JSStubElementImpl<T>
implements JSPsiNamedElementBase,
JSNamedElement,
StubBasedPsiElement<T> {
    public JSNamedElementImpl(ASTNode node) {
        super(node);
    }

    public JSNamedElementImpl(T t, IStubElementType type) {
        super((JSStubElement)t, type);
    }

    @Nullable
    public ASTNode findNameIdentifier() {
        return this.getNode().findChildByType(JSTokenTypes.IDENTIFIER);
    }

    @Nullable
    public PsiElement getNameIdentifier() {
        ASTNode identifier = this.findNameIdentifier();
        return identifier != null ? identifier.getPsi() : null;
    }

    public PsiElement setName(@NonNls @NotNull String name) throws IncorrectOperationException {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/lang/javascript/psi/impl/JSNamedElementImpl", "setName"));
        }
        ASTNode nameNode = this.findNameIdentifier();
        if (nameNode == null || name.equals(nameNode.getText())) {
            return this;
        }
        ASTNode nameElement = JSChangeUtil.createNameIdentifier(this.getProject(), name, nameNode.getElementType());
        this.getNode().replaceChild(nameNode, nameElement);
        return this;
    }

    public String getName() {
        NamedStub stub = (NamedStub)this.getGreenStub();
        if (stub != null) {
            return stub.getName();
        }
        ASTNode identifierNode = this.getNode().findChildByType(JSTokenTypes.IDENTIFIER);
        return identifierNode != null ? identifierNode.getText() : null;
    }
}

