/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.jsdoc.impl;

import com.intellij.lang.ASTNode;
import com.intellij.lang.javascript.psi.JSElementVisitor;
import com.intellij.lang.javascript.psi.jsdoc.JSDocTagValue;
import com.intellij.lang.javascript.psi.jsdoc.impl.JSDocTagReferencesHolderImpl;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiReference;
import org.jetbrains.annotations.NotNull;

public class JSDocTagValueImpl
extends JSDocTagReferencesHolderImpl
implements JSDocTagValue {
    public JSDocTagValueImpl(ASTNode node) {
        super(node);
    }

    @Override
    @NotNull
    protected PsiReference[] createRefs() {
        String name = ((PsiNamedElement)this.getParent()).getName();
        PsiReference[] refs = PsiReference.EMPTY_ARRAY;
        if (name != null) {
            String text = this.getText();
            boolean soft = false;
            boolean event = false;
            boolean module = false;
            if ("class".equals(name)) {
                soft = text.indexOf(46) == -1;
            } else if ("see".equals(name)) {
                soft = true;
                if (!text.startsWith("http:")) {
                    if (text.indexOf(35) != -1) {
                        soft = false;
                    } else {
                        int dotPos = text.lastIndexOf(46);
                        if (dotPos != -1 && dotPos + 1 < text.length() && Character.isUpperCase(text.charAt(dotPos + 1))) {
                            soft = false;
                        }
                    }
                }
            } else if ("returns".equals(name) || "return".equals(name)) {
                soft = text.indexOf(123) == -1;
            } else if ("link".equals(name)) {
                soft = text.startsWith("http:");
            } else if ("throws".equals(name)) {
                soft = true;
            } else if ("module".equals(name)) {
                module = true;
                soft = true;
            } else if ("event".equals(name)) {
                soft = true;
                event = true;
            } else if ("fires".equals(name)) {
                event = true;
            }
            refs = this.createReferencesFromText(text, soft, event, module, module, false);
        }
        if (refs == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/jsdoc/impl/JSDocTagValueImpl", "createRefs"));
        }
        return refs;
    }

    @Override
    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "com/intellij/lang/javascript/psi/jsdoc/impl/JSDocTagValueImpl", "accept"));
        }
        if (visitor instanceof JSElementVisitor) {
            ((JSElementVisitor)visitor).visitJSDocTagValue((JSDocTagValue)this);
        } else {
            visitor.visitElement((PsiElement)this);
        }
    }
}

