/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.resolve;

import com.intellij.codeInsight.completion.CompletionUtilCoreImpl;
import com.intellij.lang.Language;
import com.intellij.lang.ecmascript6.psi.ES6ExportDefaultAssignment;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.JavaScriptSupportLoader;
import com.intellij.lang.javascript.frameworks.commonjs.CommonJSUtil;
import com.intellij.lang.javascript.index.FrameworkIndexingHandler;
import com.intellij.lang.javascript.index.JSTypeEvaluateManager;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSElementBase;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSFunctionExpression;
import com.intellij.lang.javascript.psi.JSIndexedPropertyAccessExpression;
import com.intellij.lang.javascript.psi.JSNamespace;
import com.intellij.lang.javascript.psi.JSNamespaceImpl;
import com.intellij.lang.javascript.psi.JSObjectLiteralExpression;
import com.intellij.lang.javascript.psi.JSParameter;
import com.intellij.lang.javascript.psi.JSProperty;
import com.intellij.lang.javascript.psi.JSPsiElementBase;
import com.intellij.lang.javascript.psi.JSQualifiedName;
import com.intellij.lang.javascript.psi.JSQualifiedNameImpl;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSSymbolNamespace;
import com.intellij.lang.javascript.psi.JSThisExpression;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.JSWithStatement;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptClass;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.ecmal4.JSSuperExpression;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.psi.jsdoc.JSDocComment;
import com.intellij.lang.javascript.psi.resolve.ActionScriptResolveUtil;
import com.intellij.lang.javascript.psi.resolve.JSContextLevel;
import com.intellij.lang.javascript.psi.resolve.JSEvaluateContext;
import com.intellij.lang.javascript.psi.resolve.JSEvaluationResultContext;
import com.intellij.lang.javascript.psi.resolve.JSHierarchyProcessor;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.resolve.JSTypeEvaluator;
import com.intellij.lang.javascript.psi.resolve.JSTypeInfo;
import com.intellij.lang.javascript.psi.resolve.JSTypeProcessor;
import com.intellij.lang.javascript.psi.resolve.WalkUpResolveProcessor;
import com.intellij.lang.javascript.psi.types.JSAnyType;
import com.intellij.lang.javascript.psi.types.JSContext;
import com.intellij.lang.javascript.psi.types.JSGenericParameterImpl;
import com.intellij.lang.javascript.psi.types.JSGenericTypeImpl;
import com.intellij.lang.javascript.psi.types.JSNamedType;
import com.intellij.lang.javascript.psi.types.JSTypeSource;
import com.intellij.lang.javascript.psi.types.JSTypeSourceFactory;
import com.intellij.lang.javascript.psi.types.primitives.JSObjectType;
import com.intellij.lang.javascript.refactoring.JSVisibilityUtil;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.QualifiedName;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class BaseJSSymbolProcessor
implements PsiScopeProcessor {
    public static final Set<String> GLOBAL_OBJECT_NAMES = ContainerUtil.immutableSet((Object[])new String[]{"window", "global", "GLOBAL"});
    public static final Set<String> GLOBAL_TYPE_NAMES = ContainerUtil.immutableSet((Object[])new String[]{"Window"});
    public static final String HTML_ELEMENT_TYPE_NAME = "HTMLElement";
    protected final boolean ecmal4;
    protected final boolean typescript;
    @NotNull
    protected final TypeInfo myTypeInfo;
    @NotNull
    protected final PsiElement myContext;
    @NotNull
    protected final PsiFile myTargetFile;
    @Nullable
    protected final VirtualFile myTargetVirtualFile;
    @NotNull
    private final NotNullLazyValue<String[]> myContextScopesCache;
    protected boolean myCheckFileLevelAccess;
    protected boolean myElementFromBestClass;
    @Nullable
    protected VirtualFile myCurrentFile;
    protected boolean myAddOnlyCompleteMatches;
    protected boolean myAddOnlyCompleteMatchesSet;

    public static boolean isNamedGlobalType(@NotNull String typeString, @NotNull JSContext context) {
        if (typeString == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeString", "com/intellij/lang/javascript/psi/resolve/BaseJSSymbolProcessor", "isNamedGlobalType"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/lang/javascript/psi/resolve/BaseJSSymbolProcessor", "isNamedGlobalType"));
        }
        return GLOBAL_TYPE_NAMES.contains(typeString) && context != JSContext.STATIC || GLOBAL_OBJECT_NAMES.contains(typeString);
    }

    @Nullable
    public static JSType namespaceAsType(@NotNull JSNamespace namespace, @Nullable PsiElement source) {
        if (namespace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "namespace", "com/intellij/lang/javascript/psi/resolve/BaseJSSymbolProcessor", "namespaceAsType"));
        }
        JSQualifiedName qualifiedName = namespace.getQualifiedName();
        if (qualifiedName != null) {
            JSTypeSource typeSource = source == JSTypeEvaluator.EXPLICIT_TYPE_MARKER_ELEMENT ? JSTypeSource.EXPLICITLY_DECLARED : JSTypeSourceFactory.createTypeSource(source, namespace.isExplicitlyDeclared());
            return JSNamedType.createType(qualifiedName.getQualifiedName(), typeSource, namespace.getJSContext());
        }
        return null;
    }

    protected BaseJSSymbolProcessor(@NotNull PsiFile targetFile, @NotNull PsiElement context) {
        if (targetFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "targetFile", "com/intellij/lang/javascript/psi/resolve/BaseJSSymbolProcessor", "<init>"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/lang/javascript/psi/resolve/BaseJSSymbolProcessor", "<init>"));
        }
        this.myTargetFile = targetFile;
        this.myTargetVirtualFile = targetFile.getVirtualFile();
        this.myContext = context;
        this.myTypeInfo = this.createTypeInfo();
        this.myContextScopesCache = NotNullLazyValue.createValue(() -> JSVisibilityUtil.calculateContextNames(this.getContext()));
        this.ecmal4 = this.myTargetFile.getLanguage() == JavaScriptSupportLoader.ECMA_SCRIPT_L4;
        this.typescript = this.myTargetFile.getLanguage().isKindOf((Language)JavaScriptSupportLoader.TYPESCRIPT);
        JSExpression contextRefQualifier = context instanceof JSReferenceExpression ? ((JSReferenceExpression)this.myContext).getQualifier() : null;
        this.myTypeInfo.setContextGlobalStatusHint(this.initGlobalStatusHint(context, (PsiElement)contextRefQualifier));
        for (FrameworkIndexingHandler handler : (FrameworkIndexingHandler[])FrameworkIndexingHandler.EP_NAME.getExtensions()) {
            handler.addContextType(this.myTypeInfo, context);
        }
    }

    protected TypeInfo createTypeInfo() {
        return new TypeInfo();
    }

    @NotNull
    protected JSTypeInfo.GlobalStatusHint initGlobalStatusHint(@Nullable PsiElement context, @Nullable PsiElement contextRefQualifier) {
        boolean withinWithStatement;
        if (contextRefQualifier instanceof JSCallExpression || contextRefQualifier instanceof JSIndexedPropertyAccessExpression || contextRefQualifier instanceof JSReferenceExpression || contextRefQualifier instanceof JSThisExpression || contextRefQualifier instanceof JSSuperExpression) {
            JSTypeInfo.GlobalStatusHint globalStatusHint = JSTypeInfo.GlobalStatusHint.NONGLOBAL;
            if (globalStatusHint == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/resolve/BaseJSSymbolProcessor", "initGlobalStatusHint"));
            }
            return globalStatusHint;
        }
        boolean bl = withinWithStatement = PsiTreeUtil.getParentOfType((PsiElement)this.myContext, JSWithStatement.class) != null;
        if (this.myContext instanceof JSReferenceExpression && contextRefQualifier == null && !withinWithStatement && JSResolveUtil.getRealRefExprQualifier((JSReferenceExpression)this.myContext) == null) {
            JSTypeInfo.GlobalStatusHint globalStatusHint = JSTypeInfo.GlobalStatusHint.GLOBAL;
            if (globalStatusHint == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/resolve/BaseJSSymbolProcessor", "initGlobalStatusHint"));
            }
            return globalStatusHint;
        }
        JSTypeInfo.GlobalStatusHint globalStatusHint = JSTypeInfo.GlobalStatusHint.UNKNOWN;
        if (globalStatusHint == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/resolve/BaseJSSymbolProcessor", "initGlobalStatusHint"));
        }
        return globalStatusHint;
    }

    public void addTypeHierarchy(@NotNull JSNamespace namespace, @Nullable PsiFile jsModule) {
        if (namespace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "namespace", "com/intellij/lang/javascript/psi/resolve/BaseJSSymbolProcessor", "addTypeHierarchy"));
        }
        this.myTypeInfo.addNamespace(namespace, true, jsModule);
        this.addSupers(namespace);
    }

    public void addSupers(@NotNull JSNamespace namespace) {
        if (namespace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "namespace", "com/intellij/lang/javascript/psi/resolve/BaseJSSymbolProcessor", "addSupers"));
        }
        JSQualifiedName name = namespace.getQualifiedName();
        if (name == null) {
            return;
        }
        JSContext staticOrInstance = namespace.getJSContext();
        final boolean isExplicitlyDeclared = namespace.isExplicitlyDeclared();
        SmartList parentClasses = new SmartList();
        JSHierarchyProcessor processor = new JSHierarchyProcessor((List)parentClasses, staticOrInstance){
            final /* synthetic */ List val$parentClasses;
            final /* synthetic */ JSContext val$staticOrInstance;
            {
                this.val$parentClasses = list;
                this.val$staticOrInstance = jSContext;
            }

            @Override
            public boolean processNamespace(String serializedType, VirtualFile file) {
                JSType type = JSTypeUtils.createType(serializedType, JSTypeSource.EMPTY);
                if (type instanceof JSObjectType || type == null) {
                    return true;
                }
                JSNamespace namespace = JSTypeUtils.getNamespaceMatchingType(type, false, isExplicitlyDeclared);
                if (namespace != null) {
                    this.val$parentClasses.add(namespace);
                }
                return true;
            }

            @Override
            public boolean processClass(JSClass clazz) {
                String name = clazz.getQualifiedName();
                if ("Object".equals(name)) {
                    return true;
                }
                if (name != null) {
                    JSNamespaceImpl namespace = new JSNamespaceImpl(JSQualifiedNameImpl.fromQualifiedName(name), this.val$staticOrInstance, true);
                    this.val$parentClasses.add(namespace);
                }
                return true;
            }

            @Override
            public boolean processObjectLiteral(JSObjectLiteralExpression objectLiteral) {
                return BaseJSSymbolProcessor.this.processObjectLiteral(objectLiteral);
            }
        };
        String typeString = name.getQualifiedName();
        if (staticOrInstance == JSContext.STATIC) {
            typeString = JSNamedType.appendStaticSuffix(typeString);
        }
        JSTypeEvaluateManager.iterateTypeHierarchy(typeString, processor, this.myContext);
        for (JSNamespace parentClass : parentClasses) {
            this.myTypeInfo.addNamespace(parentClass, false);
        }
        this.addGenericArguments(namespace, (List<JSNamespace>)parentClasses);
    }

    protected boolean processObjectLiteral(@NotNull JSObjectLiteralExpression objectLiteral) {
        if (objectLiteral == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "objectLiteral", "com/intellij/lang/javascript/psi/resolve/BaseJSSymbolProcessor", "processObjectLiteral"));
        }
        return true;
    }

    protected void addGenericArguments(@NotNull JSNamespace namespace, @NotNull List<JSNamespace> parentClasses) {
        if (namespace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "namespace", "com/intellij/lang/javascript/psi/resolve/BaseJSSymbolProcessor", "addGenericArguments"));
        }
        if (parentClasses == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentClasses", "com/intellij/lang/javascript/psi/resolve/BaseJSSymbolProcessor", "addGenericArguments"));
        }
    }

    public abstract String getRequiredName();

    public boolean addOnlyCompleteMatches() {
        return this.myAddOnlyCompleteMatches;
    }

    public void setAddOnlyCompleteMatches(boolean addOnlyCompleteMatches) {
        if (this.myAddOnlyCompleteMatchesSet) {
            return;
        }
        this.myAddOnlyCompleteMatchesSet = true;
        this.myAddOnlyCompleteMatches = addOnlyCompleteMatches;
    }

    protected void forceSetAddOnlyCompleteMatches() {
        this.myAddOnlyCompleteMatchesSet = true;
        this.myAddOnlyCompleteMatches = true;
    }

    protected final boolean isGlobalNS(@Nullable JSQualifiedName namespace, boolean includeGlobalObjects) {
        return BaseJSSymbolProcessor.isGlobalNS(namespace, this.typescript, includeGlobalObjects);
    }

    public static boolean isGlobalNS(@Nullable JSQualifiedName namespace, boolean isTypeScript, boolean includeGlobalObjects) {
        if (namespace == null) {
            return true;
        }
        if (isTypeScript) {
            return false;
        }
        String name = namespace.getName();
        return includeGlobalObjects && (GLOBAL_OBJECT_NAMES.contains(name) || GLOBAL_TYPE_NAMES.contains(name)) && namespace.getParent() == null;
    }

    public static boolean isGlobalNS(@Nullable JSQualifiedName namespace) {
        if (namespace == null) {
            return true;
        }
        String name = namespace.getName();
        if (name.isEmpty()) {
            return true;
        }
        return namespace.getParent() == null && (GLOBAL_OBJECT_NAMES.contains(name) || GLOBAL_TYPE_NAMES.contains(name));
    }

    public boolean acceptsFile(PsiFile file) {
        this.myCurrentFile = file.getViewProvider().getVirtualFile();
        boolean currentFileEcma = file.getLanguage() == JavaScriptSupportLoader.ECMA_SCRIPT_L4;
        return this.ecmal4 == currentFileEcma;
    }

    protected boolean isFromRelevantFileOrDirectory() {
        return Comparing.equal((Object)this.myTargetVirtualFile, (Object)this.myCurrentFile);
    }

    public boolean toCheckFileLevelAccess() {
        return this.myCheckFileLevelAccess;
    }

    protected final void initCheckFileLevelAccess() {
        if (!this.myTypeInfo.isNonGlobalStatusHint() && this.myTargetFile instanceof JSFile) {
            PsiElement resolve;
            JSExpression qualifier;
            this.myCheckFileLevelAccess = true;
            if (this.myContext instanceof JSReferenceExpression && (qualifier = ((JSReferenceExpression)this.myContext).getQualifier()) instanceof JSReferenceExpression && ((resolve = ((JSReferenceExpression)qualifier).resolve()) == null || resolve instanceof JSParameter || !resolve.getContainingFile().getOriginalFile().isEquivalentTo((PsiElement)this.myTargetFile))) {
                this.myCheckFileLevelAccess = false;
            }
        }
    }

    @Nullable
    public String isAcceptable(@NotNull JSPsiElementBase element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/psi/resolve/BaseJSSymbolProcessor", "isAcceptable"));
        }
        if (!this.toCheckFileLevelAccess()) {
            return null;
        }
        JSQualifiedName namespace = element.getJSNamespace().getQualifiedName();
        boolean isCommonJSExported = CommonJSUtil.isExportNamespace(namespace);
        if (namespace != null && !isCommonJSExported) {
            return null;
        }
        PsiFile file = element.getContainingFile();
        if (element.getContext() instanceof JSDocComment && file.equals(this.myContext.getContainingFile())) {
            return null;
        }
        if (!(file instanceof JSFile) || ((JSFile)file).getModuleStatus() == JSFile.ModuleStatus.NONE || ((JSFile)file).getModuleStatus() == JSFile.ModuleStatus.MAYBE_COMMONJS || !element.isNamespaceExplicitlyDeclared()) {
            return null;
        }
        if (this.myContext instanceof JSReferenceExpression && (DialectDetector.isES6((PsiElement)element) && element.isExported() || isCommonJSExported)) {
            if (((JSReferenceExpression)this.myContext).getQualifier() == null) {
                return "javascript.element.need.to.be.imported";
            }
            return null;
        }
        if (element.getContext() instanceof ES6ExportDefaultAssignment) {
            return null;
        }
        return "javascript.element.need.to.be.exported";
    }

    protected void tryAddFunctionType(@NotNull JSType type, @Nullable PsiElement source) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/lang/javascript/psi/resolve/BaseJSSymbolProcessor", "tryAddFunctionType"));
        }
        if (JSTypeUtils.hasFunctionType(type) || source instanceof TypeScriptClass && type instanceof JSNamedType && ((JSNamedType)type).isStaticOrInstance() == JSContext.STATIC) {
            this.myTypeInfo.addNamespace("Function", false, JSContext.INSTANCE, type.getSource().isExplicitlyDeclared());
        }
    }

    protected boolean isStrictTypingPossible(@Nullable PsiElement source, @NotNull JSType type) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/lang/javascript/psi/resolve/BaseJSSymbolProcessor", "isStrictTypingPossible"));
        }
        return source == JSTypeEvaluator.EXPLICIT_TYPE_MARKER_ELEMENT && !(type instanceof JSObjectType) && !(type instanceof JSAnyType) && !(type instanceof JSGenericParameterImpl) && (!(type instanceof JSGenericTypeImpl) || !(((JSGenericTypeImpl)type).getType() instanceof JSObjectType));
    }

    static boolean isValidType(String parameterType) {
        return parameterType != null && !parameterType.isEmpty();
    }

    protected void addPackageScope(@Nullable JSClass jsClass, @Nullable PsiElement expression) {
        String packageQualifier = JSResolveUtil.findPackageStatementQualifier(expression);
        if (packageQualifier != null) {
            this.myTypeInfo.buildIndexListFromQNameAndCorrectQName(packageQualifier);
        } else if (jsClass != null) {
            int index;
            String qName = jsClass.getQualifiedName();
            if (qName != null && !qName.equals(jsClass.getName()) && (index = qName.lastIndexOf(46)) > 0) {
                this.myTypeInfo.buildIndexListFromQNameAndCorrectQName(qName.substring(0, index));
            }
        } else {
            String s = ActionScriptResolveUtil.findPackageForMxml(expression);
            if (BaseJSSymbolProcessor.isValidType(s)) {
                this.myTypeInfo.buildIndexListFromQNameAndCorrectQName(s);
            }
        }
    }

    protected void addNamespace(@NotNull JSNamespace namespace, boolean isTopClassInHierarchy) {
        if (namespace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "namespace", "com/intellij/lang/javascript/psi/resolve/BaseJSSymbolProcessor", "addNamespace"));
        }
        this.myTypeInfo.addNamespace(namespace, isTopClassInHierarchy);
    }

    public static String addIndexListFromQName(@NotNull String type, List<String> list) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/lang/javascript/psi/resolve/BaseJSSymbolProcessor", "addIndexListFromQName"));
        }
        QualifiedName qName = StringUtil.isQuotedString((String)type) ? QualifiedName.fromComponents((String[])new String[]{type}) : QualifiedName.fromDottedString((String)type);
        list.addAll(qName.getComponents());
        return type;
    }

    public <T> T getHint(@NotNull Key<T> hintKey) {
        if (hintKey == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "hintKey", "com/intellij/lang/javascript/psi/resolve/BaseJSSymbolProcessor", "getHint"));
        }
        return null;
    }

    public void handleEvent(@NotNull PsiScopeProcessor.Event event, Object associated) {
        if (event == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/lang/javascript/psi/resolve/BaseJSSymbolProcessor", "handleEvent"));
        }
    }

    protected String[] getContextScopeNames() {
        return (String[])this.myContextScopesCache.getValue();
    }

    @NotNull
    public PsiElement getContext() {
        PsiElement psiElement = this.myContext;
        if (psiElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/resolve/BaseJSSymbolProcessor", "getContext"));
        }
        return psiElement;
    }

    @NotNull
    public TypeInfo getTypeInfo() {
        TypeInfo typeInfo = this.myTypeInfo;
        if (typeInfo == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/resolve/BaseJSSymbolProcessor", "getTypeInfo"));
        }
        return typeInfo;
    }

    @NotNull
    protected MatchType isAcceptableQualifiedItem(@NotNull JSPsiElementBase element, @NotNull Ref<Integer> typeHierarchyLevel) {
        boolean isGlobalIncludeGlobalObjects;
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/psi/resolve/BaseJSSymbolProcessor", "isAcceptableQualifiedItem"));
        }
        if (typeHierarchyLevel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeHierarchyLevel", "com/intellij/lang/javascript/psi/resolve/BaseJSSymbolProcessor", "isAcceptableQualifiedItem"));
        }
        JSQualifiedName namespace = this.getElementNamespace(element);
        boolean isElementLocal = element.getJSNamespace().isLocal();
        boolean isNamespaceExplicitlyDeclared = element.isNamespaceExplicitlyDeclared();
        boolean isGlobal = this.isGlobalNS(namespace, false);
        boolean bl = isGlobalIncludeGlobalObjects = isGlobal || this.isGlobalNS(namespace, true);
        if (isGlobal && BaseJSSymbolProcessor.isPrivate(element) && !this.isFromRelevantFileOrDirectory()) {
            MatchType matchType = MatchType.NOMATCH;
            if (matchType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/resolve/BaseJSSymbolProcessor", "isAcceptableQualifiedItem"));
            }
            return matchType;
        }
        this.myElementFromBestClass = false;
        if (isGlobalIncludeGlobalObjects && BaseJSSymbolProcessor.isPrivate(element) && !this.isFromRelevantFileOrDirectory()) {
            MatchType matchType = MatchType.NOMATCH;
            if (matchType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/resolve/BaseJSSymbolProcessor", "isAcceptableQualifiedItem"));
            }
            return matchType;
        }
        if (this.myTypeInfo.isNonGlobalStatusHint() && isNamespaceExplicitlyDeclared && (isGlobal || isGlobalIncludeGlobalObjects && !(this instanceof WalkUpResolveProcessor) || (element instanceof JSVariable || element instanceof JSFunction && !(element instanceof JSFunctionExpression)) && this.isGlobalNS(namespace, true))) {
            MatchType matchType = MatchType.NOMATCH;
            if (matchType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/resolve/BaseJSSymbolProcessor", "isAcceptableQualifiedItem"));
            }
            return matchType;
        }
        if (this.myTypeInfo.isGlobalStatusHint() && (isNamespaceExplicitlyDeclared && (isElementLocal || !BaseJSSymbolProcessor.isGlobalNS(namespace, this.typescript, true)) || JSPsiImplUtils.isClassMember((PsiElement)element) || element instanceof JSProperty)) {
            MatchType matchType = MatchType.NOMATCH;
            if (matchType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/resolve/BaseJSSymbolProcessor", "isAcceptableQualifiedItem"));
            }
            return matchType;
        }
        MatchType result = this.iterateContextLevels(element, typeHierarchyLevel, namespace, isElementLocal);
        if (result != null) {
            MatchType matchType = result;
            if (matchType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/resolve/BaseJSSymbolProcessor", "isAcceptableQualifiedItem"));
            }
            return matchType;
        }
        if (isNamespaceExplicitlyDeclared && isGlobalIncludeGlobalObjects && this.myTypeInfo.isGlobalStatusHint()) {
            MatchType matchType = MatchType.COMPLETE;
            if (matchType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/resolve/BaseJSSymbolProcessor", "isAcceptableQualifiedItem"));
            }
            return matchType;
        }
        MatchType matchType = MatchType.PARTIAL;
        if (matchType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/resolve/BaseJSSymbolProcessor", "isAcceptableQualifiedItem"));
        }
        return matchType;
    }

    @Nullable
    private MatchType iterateContextLevels(@NotNull JSPsiElementBase element, @NotNull Ref<Integer> typeHierarchyLevel, JSQualifiedName namespace, boolean isElementLocal) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/psi/resolve/BaseJSSymbolProcessor", "iterateContextLevels"));
        }
        if (typeHierarchyLevel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeHierarchyLevel", "com/intellij/lang/javascript/psi/resolve/BaseJSSymbolProcessor", "iterateContextLevels"));
        }
        JSContext elementStaticOrInstance = element.getJSContext();
        boolean jsContextMismatched = false;
        for (JSContextLevel contextLevel : this.myTypeInfo.myContextLevels) {
            JSQualifiedName currentNs;
            if (contextLevel.myJSModule != null && !contextLevel.myJSModule.equals(element.getContainingFile()) || contextLevel.myJSModule == null && isElementLocal && !element.getContainingFile().isEquivalentTo((PsiElement)this.myTargetFile)) continue;
            JSQualifiedName currentContextNamespace = contextLevel.myNamespace.getQualifiedName();
            for (currentNs = namespace; currentContextNamespace != null && currentNs != null && currentContextNamespace.getName().equals(currentNs.getName()); currentNs = currentNs.getParent(), currentContextNamespace = currentContextNamespace.getParent()) {
            }
            if (!BaseJSSymbolProcessor.isGlobalNS(currentContextNamespace) || !this.isGlobalNS(currentNs, true)) continue;
            if (!contextLevel.myNamespace.getJSContext().isCompatibleWith(elementStaticOrInstance)) {
                jsContextMismatched = true;
                continue;
            }
            if (jsContextMismatched && contextLevel.myNamespace.getJSContext() == JSContext.UNKNOWN || this.myAddOnlyCompleteMatches && currentNs != null) continue;
            int relativeLevel = contextLevel.myRelativeLevel;
            typeHierarchyLevel.set((Object)relativeLevel);
            if (relativeLevel == 0) {
                this.myElementFromBestClass = true;
            }
            return relativeLevel == 0 && elementStaticOrInstance != JSContext.UNKNOWN && contextLevel.myNamespace.getJSContext() != JSContext.UNKNOWN ? MatchType.COMPLETE_WITH_CONTEXT : MatchType.COMPLETE;
        }
        return jsContextMismatched ? MatchType.NOMATCH : null;
    }

    private JSQualifiedName getElementNamespace(@NotNull JSPsiElementBase element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/psi/resolve/BaseJSSymbolProcessor", "getElementNamespace"));
        }
        PsiElement parent = element.getContext();
        return this.ecmal4 && parent instanceof JSClass ? JSQualifiedNameImpl.buildProvidedNamespace((JSElementBase)((JSClass)parent)) : element.getJSNamespace().getQualifiedName();
    }

    private static boolean isPrivate(@NotNull JSPsiElementBase element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/psi/resolve/BaseJSSymbolProcessor", "isPrivate"));
        }
        return element.getAccessType() == JSAttributeList.AccessType.PRIVATE;
    }

    @Contract(value="null -> null")
    public static JSExpression getOriginalQualifier(@Nullable JSExpression rawqualifier) {
        if (rawqualifier == null) {
            return null;
        }
        JSExpression element = (JSExpression)CompletionUtilCoreImpl.getOriginalElement((PsiElement)rawqualifier);
        return element != null ? element : rawqualifier;
    }

    protected static boolean isCompleteOrWithContextMatchType(@Nullable MatchType matchType) {
        return matchType == MatchType.COMPLETE_WITH_CONTEXT || matchType == MatchType.COMPLETE;
    }

    public abstract class JSTypeProcessorBase
    implements JSTypeProcessor {
        @Override
        public void processNamespace(@NotNull JSSymbolNamespace namespace, @NotNull JSEvaluateContext evaluateContext, PsiElement source) {
            if (namespace == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "namespace", "com/intellij/lang/javascript/psi/resolve/BaseJSSymbolProcessor$JSTypeProcessorBase", "processNamespace"));
            }
            if (evaluateContext == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "evaluateContext", "com/intellij/lang/javascript/psi/resolve/BaseJSSymbolProcessor$JSTypeProcessorBase", "processNamespace"));
            }
            JSType type = BaseJSSymbolProcessor.namespaceAsType((JSNamespace)namespace, source);
            if (type != null) {
                this.process(type, evaluateContext, source);
            }
        }

        @Override
        public void processResolvedElement(@NotNull PsiElement element, @NotNull JSEvaluationResultContext evaluateContext) {
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/psi/resolve/BaseJSSymbolProcessor$JSTypeProcessorBase", "processResolvedElement"));
            }
            if (evaluateContext == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "evaluateContext", "com/intellij/lang/javascript/psi/resolve/BaseJSSymbolProcessor$JSTypeProcessorBase", "processResolvedElement"));
            }
            if (!(!(element instanceof PsiFile) || element instanceof JSFile && ((JSFile)element).referencesImportInDefaultExport())) {
                BaseJSSymbolProcessor.this.setAddOnlyCompleteMatches(true);
            }
        }

        @Override
        public void setUnknownElement(@NotNull PsiElement element) {
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/psi/resolve/BaseJSSymbolProcessor$JSTypeProcessorBase", "setUnknownElement"));
            }
        }
    }

    public static class TypeInfo
    extends JSTypeInfo {
    }

    public static enum MatchType {
        COMPLETE_WITH_CONTEXT,
        COMPLETE,
        COMPLETE_NS,
        PARTIAL,
        NOMATCH;

    }
}

